/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p5rX
 */

/**
 * TextFieldにフォーカスを当てた状態で、
 * キーボードの↑↓キーを押し下げると、
 * TextField中の値が上下する。
 */
package
{
	import flash.display.Sprite;
	import flash.text.TextFormat;
	
	[SWF(backgroundColor="0xFFFFFF",width=465,height=465)]
	public class NumberField extends Sprite
	{
		public function NumberField()
		{
			var ntf:NumericTextField = new NumericTextField();
			ntf.autoSize = "left";
			ntf.border = true;
			ntf.type = "input";
			ntf.defaultTextFormat = new TextFormat("_typewriter",48,0xFF0000);
			addChild(ntf);
			
			//NumericTextFieldの設定
			ntf.numeric = 123;//Number型で指定できる
			ntf.step = 1;//一回の上下キー操作で変化する量
			ntf.base = 16;//16進数
			ntf.maximum = 0x111;//最大値
			ntf.minimum = 0x00;//最小値
			ntf.isKeyboardControl = true;//上下キー操作を受け付ける
			ntf.length = 3;//桁数の指定
			ntf.isPrefix = true;//16進数の場合に0xを付ける
		}
	}
}
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.text.TextField;

class NumericTextField extends TextField{
	private var _base:int = 10;
	private var _isDecimalPoint:Boolean = true;
	private var _isKeyboardControl:Boolean;
	private var _isUpperCase:Boolean = true;
	private var _length:int = -1;
	private var _maximum:Number = Infinity;
	private var _minimum:Number = -Infinity;
	private var _numeric:Number = 0;
	private var _isPrefix:Boolean;
	private var _step:Number = 1;
	public function NumericTextField(... args){
		for (var i:int = 0; i < args.length; i++) {
			var params:Object = args[i];
			for (var str:String in params) {
				this[str] = params[str];
			}
		}
		this.addEventListener(Event.ADDED_TO_STAGE,atAddedToStage);
	}
	private function atAddedToStage(event:Event):void{
		this.removeEventListener(Event.ADDED_TO_STAGE,atAddedToStage);
		this.addEventListener(Event.REMOVED_FROM_STAGE,atRemoverFromStage);
		//isKeyboardControl = _isKeyboardControl;
	}
	private function atRemoverFromStage(event:Event):void{
		this.removeEventListener(Event.REMOVED_FROM_STAGE,atRemoverFromStage);
		this.removeEventListener(KeyboardEvent.KEY_DOWN,atKeyboardEvent);
	}
	private function atKeyboardEvent(event:KeyboardEvent):void{
		if(event.keyCode == 38){
			numeric += _step;
		}else if(event.keyCode == 40){
			numeric -= _step;
		}
	}
	public var onChange:Function = function():void{};
	/**
	 * 基数（value進数）の設定。デフォルトは10進数。10/16/2の設定ができる。
	 */
	public function get base():int{return _base;};
	public function set base(value:int):void{
		if(value != 16 && value != 10 && value != 2){return};
		_base = value;
		if(value == 16){
			if(_isPrefix){
				this.restrict = "A-F a-f 0-9 x";
			}else{
				this.restrict = "A-F a-f 0-9";
			}
		}else if(value == 10){
			if(_isDecimalPoint){
				this.restrict = "0-9 \.";
			}else{
				this.restrict = "0-9";
			}
		}else if(value == 2){
			this.restrict = "0-1";			
		}
		setText();
	}
	/**
	 * 小数点入力の可否。デフォルトは可
	 */
	public function get isDecimalPoint():Boolean{return _isDecimalPoint;};
	public function set isDecimalPoint(value:Boolean):void{
		if(_isDecimalPoint == value){return};
		_isDecimalPoint = value;
		if(_base == 10){
			if(value){
				this.restrict = "0-9 \.";
			}else{
				this.restrict = "0-9";
			}
		}
	}
	/**
	 * キーボードでのコントロールをするか否か。デフォルトは否
	 */	
	public function get isKeyboardControl():Boolean{return _isKeyboardControl;};
	public function set isKeyboardControl(value:Boolean):void{
		if(_isKeyboardControl == value){return};
		_isKeyboardControl = value;
		if(value){
			this.removeEventListener(KeyboardEvent.KEY_DOWN,atKeyboardEvent);
			this.addEventListener(KeyboardEvent.KEY_DOWN,atKeyboardEvent);
		}else{
			this.removeEventListener(KeyboardEvent.KEY_DOWN,atKeyboardEvent);
		}
	}
	/**
	 * プレフィックス（0x）を付けるか否か。デフォルトはつけない
	 */	
	public function get isPrefix():Boolean{return _isPrefix;};
	public function set isPrefix(value:Boolean):void{
		if(_isPrefix == value){return};
		_isPrefix = value;
		if(_base == 16){
			if(value){
				this.restrict = "A-F a-f 0-9 x";
			}else{
				this.restrict = "A-F a-f 0-9";
			}
		}
		setText();
	}
	/**
	 * 大文字か小文字か。デフォルトは大文字
	 */	
	public function get isUpperCase():Boolean{return _isUpperCase;};
	public function set isUpperCase(value:Boolean):void{
		if(_isUpperCase == value){return};
		_isUpperCase = value;
		setText();
	}
	/**
	 * int型でテキストの桁数指定。-1でなりゆき。デフォルトは-1;
	 */	
	public function set length(value:int):void{
		if(_length == value){return};
		_length = value;
		setText();
	}
	/**
	 * Number型でテキストを設定。デフォルトは0
	 */	
	public function get numeric():Number{
		var string:String = super.text;
		if(string.substr(0,2) != "0x" && base == 16){
			return Number("0x"+super.text);
		}else{
			return Number(super.text);
		}
	};
	public function set numeric(value:Number):void{
		if(_numeric == value){return};
		if(!isNaN(value)){
			_numeric = Math.max(Math.min(value,_maximum),_minimum);
		};
		setText();
	}
	/**
	 * 一回のキー押し下げでどれくらい値が変わるか。デフォルトは1
	 */	
	public function get step():Number{return _step;};
	public function set step(value:Number):void{
		if(_step == value){return};
		_step = value;
	}
	/**
	 * 最大値。デフォルトはInfinity
	 */	
	public function get maximum():Number{return _maximum;};
	public function set maximum(value:Number):void{
		if(_maximum == value){return};
		_maximum = value;
		numeric = Math.min(value,_numeric);
	}
	/**
	 * 最小値。デフォルトは-Infinity
	 */	
	public function get minimum():Number{return _minimum;};
	public function set minimum(value:Number):void{
		if(_minimum == value){return};
		_minimum = value;
		numeric = Math.max(value,_numeric);
	}
	override public function set text(value:String):void{
		if(super.text == value){return};
		if(base == 16){
			if(_isPrefix){
				numeric = Number(value);
			}else{
				numeric = Number("0x"+value);
			}
		}else if(base == 10){
			numeric = Number(value);
		}else if(base == 2){
			numeric = Number(value);
		}
	}
	private function setText():void{
		var string:String = _numeric.toString(_base);
		if(_isUpperCase){
			string = string.toUpperCase();
		}
		if(_length > 0){
			string = ("0000000000000000000000000000000000000000000000000000000000000000"+string).substr(-_length);
		}
		if(_isPrefix && _base == 16){
			string = "0x"+string;
		}
		super.text = string;
		if(this.stage){
			onChange();
		}
	}
}