/**
 * Copyright megane_bomb1 ( http://wonderfl.net/user/megane_bomb1 )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/p5pM
 */

// forked from megane_bomb1's 検索機能つける
// forked from megane_bomb1's 写真にクリックイベント付ける
// forked from megane_bomb1's 写真を上からランダムで流す
// forked from megane_bomb1's 決め打ちスライドショー
// forked from megane_bomb1's 5
// forked from megane_bomb1's 3

package {
    import flash.display.*;
    import flash.net.*;
    import flash.events.*;
    import flash.system.*;
    import flash.text.*; 
    import com.demonsters.debugger.MonsterDebugger;
    import caurina.transitions.Tweener;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import caurina.transitions.properties.FilterShortcuts;
    
    [SWF(backgroundColor = "0")]
    
    public class Main extends Sprite {
        //ボタン
        private var button : SimpleButton;
        
        // LoaderContextを準備
        private var context:LoaderContext = new LoaderContext(true);
       
        //XML系
        private var url : URLRequest;
        private var xmlloader : URLLoader = new URLLoader();
        //要素の数
        private var length:int;
        private var index:int = 0;
        //画像URL格納
        private var imageUrl_arr:Array = new Array();
        private var load_img:Loader = new Loader();
        private var url_str:String;
        private var url_img:URLRequest;
        //URLにジャンプ
        private var userID:String;
        private var ID:String;
        //画像格納
        private var sprite:Sprite;

        private var search_text:TextField = new TextField();  
        private var error_msg:TextField = new TextField();    
        
        
       //height scale
       private var height_s:Number = 1;
       //width scale
       private var width_s:Number = 1;
       
        
       private var _timer:Timer = new Timer(2000);
               
        //コンストラクタ         
        public function Main():void {
          url = new URLRequest("http://api.flickr.com/services/rest?api_key=d66685810fb12432a61842b076228d2e&method=flickr.photos.search&tags=flower&size=medium");
          MonsterDebugger.initialize(stage); 
          FilterShortcuts.init();   
          Bottom(); 
          setStage();
          loadxml(url);
        }
        
         //-------------------------------------------------------
         // ステージの設定   
         //-------------------------------------------------------         
         private function setStage():void {
             
           stage.quality = "BEST";
           stage.addEventListener( Event.RESIZE,  resizeH);
           stage.scaleMode = StageScaleMode.NO_SCALE;
           stage.align     = StageAlign.TOP_LEFT;     
         }
          
         //-------------------------------------------------------
         //XML読み込み
         //-------------------------------------------------------
         private function loadxml(url:URLRequest):void {
             xmlloader.load(url);
             xmlloader.addEventListener (Event.COMPLETE,get_imgURL);
         }
         private function get_imgURL( event:Event ):void {

             //XMLDATA抽出
             var xml : XML =  XML(xmlloader.data);
             var xmlList:XMLList = xml.photos.photo;
             length = xmlList.length();
             
          //-------------------------------------------------------
          //error処理
          //-------------------------------------------------------
          if (length == 0) {      
              error();
              _timer.stop();
          }else{
            tag_name(search_text.text);   
            imageUrl_arr = new Array();
            for(var i:int=0;i<length;i++){
                    var obj:Object = new Object();
                    //XML各要素を格納
                    var farm:String = xmlList[i].@farm;
                    var server:String = xmlList[i].@server;
                    var id:String = xmlList[i].@id;
                    var secret:String = xmlList[i].@secret;
                    var title:String = xmlList[i].@title;
                    var userID:String = xmlList[i].@owner;
    
                    var img_url:String = "http://farm" + farm + ".static.flickr.com/" + server + "/" + id + "_" + secret + "_m" +".jpg"; 
                    obj.url = img_url;
                    obj.title = title;
                    obj.userID = userID;
                    obj.id = id;
                    
                    //画像情報を配列に格納                
                    imageUrl_arr.push(obj);
             }
             timer();
          }

         }
         
                

        //-------------------------------------------------------
        //timer
        //-------------------------------------------------------
        private function timer():void{       
            _timer.addEventListener(TimerEvent.TIMER, img_addchild);
            _timer.start();    

        }
        
        //-------------------------------------------------------
        //画像loop
        //-------------------------------------------------------
        private function img_addchild(event:Event):void{
            
            //読み込んだ画像の数
            if(index == length){
                index = 0;
            }
            url_str = imageUrl_arr[index].url;
            url_img = new URLRequest(url_str);      
            load_img.load(url_img,context);
           
            index += 1;
            load_img.contentLoaderInfo.addEventListener( Event.COMPLETE , resize );
            load_img.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
        }

        
        //-------------------------------------------------------
        //画像リサイズ
        //-------------------------------------------------------
        private function resize(event:Event):void{
            //userID
             userID = imageUrl_arr[index-1].userID;
             ID = imageUrl_arr[index-1].id;
             
             //bitmapをspriteに！(大切)
             sprite = new Sprite();
             //指カーソル！
             sprite.buttonMode = true;
             sprite.useHandCursor = true;
             
             //スムージングをtrueに
             Bitmap(event.target.content).smoothing = true;
             sprite.addChild(load_img.content);
             
             //MouseEvent系
             sprite.addEventListener(MouseEvent.CLICK,jump(ID,userID));
             sprite.addEventListener(MouseEvent.ROLL_OVER,roll_over(sprite));
             sprite.addEventListener(MouseEvent.ROLL_OUT,roll_out(sprite));
             
             sprite.addEventListener(Event.REMOVED_FROM_STAGE,removed);  
             addChild(sprite);
             
             //randomに画像を生成
             random();
             
             //落ちるスピード
             var time:int = 1 + (Math.random() * 10) ;
             var height:int = stage.stageHeight;
             Tweener.addTween(sprite, {y:height,onComplete:remove,onCompleteParams:[sprite],transition:"linear", time:time});       
        }

        //終わった画像消す
        private function remove(sprite:Sprite):void{
            this.removeChild(sprite);
            sprite = null;
        }
        
        private function removed(event:Event):void{
            //event.target.Bottom
     
            sprite.removeEventListener(MouseEvent.CLICK,jump(ID,userID));
            sprite.removeEventListener(MouseEvent.ROLL_OVER,roll_over(sprite));
            sprite.removeEventListener(MouseEvent.ROLL_OUT,roll_out(sprite));
            
            //remove効かない
            MonsterDebugger.trace(this,"kiteru:" + sprite.hasEventListener(MouseEvent.ROLL_OUT));                
             
        }

        //randomな値の生成
        private function random():void{
           sprite.x = Math.random()* stage.stageWidth;
           sprite.scaleX = sprite.scaleY = ((2 + (Math.random() * 5)) / 10) * width_s;
           sprite.y = 0 - sprite.height;
           
           //ブラー
           var blur:int = 10 - (sprite.scaleX * 10);
           Tweener.addTween(sprite,{time:1,_Blur_blurX:blur,_Blur_blurY:blur});
       }


        
        //-------------------------------------------------------
        //マウスイベント系
        //-------------------------------------------------------        
        
        private function jump(id:String,userID:String):Function{
            　return function (event:Event):void{
                var url:URLRequest = new URLRequest("http://www.flickr.com/photos/" + userID + "/" + id );
                navigateToURL( url );
　            }
        }
        private function roll_over(sprite:Sprite):Function{
              return function (event:Event):void{
                    sprite.alpha = 0.7;
　            }
        }
        private function roll_out(sprite:Sprite):Function{
              return function (event:Event):void{
                    sprite.alpha = 1;
　            }
        }
        
        
        
        
        
        
        
        //-------------------------------------------------------
        //ボタンやらラベルやら(表示系)
        //-------------------------------------------------------            
          private function Bottom():void {

            //text
            var tf:TextField =  new TextField();
            var format:TextFormat = new TextFormat(); 
            format.color = "0xFFFFFF"; 
            format.font = "Verdana"; 
            format.size = 10; 
            format.align = TextFormatAlign.LEFT;
            tf.defaultTextFormat = format;
            tf.x = 10;
            tf.y = 5;
            tf.width = stage.stageWidth;
            tf.text = "Please input tag name!";
            stage.addChild(tf);
            
            //bottom
            button = new SimpleButton();
            button.upState = makeRoundRect(0xffaa2b);
            button.overState = makeRoundRect(0xd58000);
            button.downState = makeRoundRect(0x553300);
            button.hitTestState = button.upState;
            button.addEventListener(MouseEvent.CLICK,search);

            stage.addChild(button);
            button.y = 25;
            button.x = 110;
            button.width = 40;
            
            //textfield
            //stage.focus = search_text;
            search_text.addEventListener(KeyboardEvent.KEY_DOWN,push_enter);
            stage.addChild(search_text);    
            search_text.background = true;
            search_text.width = 90;
            search_text.height = 20;
            search_text.y = 25;
            search_text.x = 10;
            search_text.type = "input";
            
            
          }
        //ボタン用グラフィック作成
        private function makeRoundRect(color:uint):Sprite{
            var s:Sprite = new Sprite();
            s.graphics.beginFill(color);
            s.graphics.drawRoundRect(0, 0, 100, 20, 15);
            s.graphics.endFill();
            s.alpha = 1;
            return s;
        }
        
        private function search(event:Event):void{
            if(search_text.text != ""){
                url = new URLRequest("http://api.flickr.com/services/rest?api_key=d66685810fb12432a61842b076228d2e&method=flickr.photos.search&tags="+ search_text.text + "&size=medium");
                loadxml(url);       
            }
        }
        
         private function push_enter(event:KeyboardEvent):void{
             if(event.keyCode === 13){
                if(search_text.text != ""){
                    url = new URLRequest("http://api.flickr.com/services/rest?api_key=d66685810fb12432a61842b076228d2e&method=flickr.photos.search&tags="+ search_text.text + "&size=medium");
                    loadxml(url);       
                }
             }
        }
        
        private function tag_name(search_text:String):void{
            var format:TextFormat = new TextFormat(); 
            format.color = 0xFFFFFF; 
            format.font = "Verdana"; 
            format.size =20 * width_s; 
            format.align = TextFormatAlign.CENTER;
            error_msg.defaultTextFormat = format;
            
            error_msg.width = stage.stageWidth;
            error_msg.height = 25 + (20 * width_s);
            error_msg.y = -100;
            error_msg.text = "Searching " + search_text + "!";
            stage.addChild(error_msg);
            
            Tweener.addTween(error_msg,{y:stage.stageHeight ,onComplete:remove_text,time:3,transition:"easeOutBounce"});            
        }

        
        private function error():void{
            var format:TextFormat = new TextFormat(); 
            format.color = 0xFFFFFF; 
            format.font = "Verdana"; 
            format.size =20 * width_s; 
            format.align = TextFormatAlign.CENTER;
            error_msg.defaultTextFormat = format;
            
            error_msg.width = stage.stageWidth;
            error_msg.height = 25 + (20 * width_s);
            error_msg.y = -100;
            error_msg.text = "no tag";
            stage.addChild(error_msg);
            
            Tweener.addTween(error_msg,{y:stage.stageHeight,onComplete:remove_text,time:3,transition:"easeOutBounce"}); 
        }
        
        //text remove!
        private function remove_text():void{
            stage.removeChild(error_msg);
            //error_msg = null;
        }

        
        
        
        //-------------------------------------------------------
        //変更された比率を格納する(リサイズ時)
        //-------------------------------------------------------      
        private function resizeH(event:Event):void{
             width_s = stage.stageWidth / 465;
             height_s = stage.stageHeight / 465;
        }
        
        //-------------------------------------------------------
        //IOError
        //------------------------------------------------------- 
        private function onIOError(event:Event):void{
            
        }
    }
    
  

    
    
    
}