/**
 * Copyright colin.boo ( http://wonderfl.net/user/colin.boo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p50Q
 */

package {
    import flash.display.Sprite;
    import flash.utils.ByteArray;
    import flash.display.Loader;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.events.MouseEvent;
    import flash.utils.Endian;

    public class FlashTest extends Sprite {
        private var txtInput:TextField = new TextField();
        private var txtOutput:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            /* 
            this tool convert 
            Truelight LUT (*.cube) which export from color finesse 3 
            to LOOK file use in cineform firstLight
            */

            txtInput.multiline = true;
            txtInput.type = TextFieldType.INPUT;
            txtInput.border = true;
            txtInput.width = this.stage.stageWidth-10;
            txtInput.x = 5;
            txtInput.y = 5;
            txtInput.height = 150;
            txtInput.text = '# copy and paste 16x16x16 LUT (*.cube) here';
            
            txtOutput.multiline = true;
            txtOutput.type = TextFieldType.DYNAMIC;
            txtOutput.border = true;
            txtOutput.width = this.stage.stageWidth-10;
            txtOutput.x = 5;
            txtOutput.y = 180;
            txtOutput.height = 150;
            txtOutput.text = 'click here to convert';
            txtOutput.addEventListener(MouseEvent.CLICK,convert);

            this.addChild(txtInput);
            this.addChild(txtOutput);
        }

        private function convert(e:*):void{
            var data:String = txtInput.text;
            data = data.replace(/\r/gi,'');
            data = data.replace(/\t/gi,' ');
            data = data.replace(/ +/gi,' ');
            
            var values:Array = data.match(/\d.\d\d\d\d\d\d/gi);
        
            var size:Number = 16;
            var begin:String = '<look>\n<LUT>\n<size>"'+size+'"</size>\n<data>"\n';
            var content:String = '';
            var end:String = '"</data></LUT></look>';
        
            var bytes:ByteArray = new ByteArray();
            bytes.endian = Endian.LITTLE_ENDIAN;
            var o:uint;
            var output:String;
            var newlineCount:int=0;
        
            for(var cx:int=0;cx<size*size*size*3;cx++){
                bytes.writeFloat(Number(values.shift()));
                bytes.position=0;
                o = bytes.readUnsignedByte()<<24 | bytes.readUnsignedByte()<<16 | bytes.readUnsignedByte()<<8 |bytes.readUnsignedByte();
                output = o.toString(16);
                while(output.length<8){
                    output = '0'+output;
                }
                content =content+output;
                
                //new line every 8 values
                newlineCount++;
                if(newlineCount>7){
                    content =content+'\n';
                    newlineCount = 0;
                }
        
                bytes.clear();
            }
        
            txtOutput.text = begin+content+end;
        }
    }
}