/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p4wE
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;

    [SWF(width = '465', height = '465')]
    public class DOF2 extends Sprite {
        function DOF2() {
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var s3d : Space3D = new Space3D(0xC5C0BA);
            s3d.opaqueBackground = 0x0;
            addChild(s3d);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.StageQuality;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;


internal class Space3D extends Bitmap {
    private const O_SIZE : int = 56;
    private const O_NUM : uint = 10;
    private const O_NUM3 : uint = O_NUM * O_NUM * O_NUM;
    private const BLUR_SIZE : Number = 18.0;
    private const FOV : Number = 70;
    private const NEAR_Z : Number = 1;
    private const Z_LEVELS : uint = 64;
    private const VZPER : Number = (3.141592653589793);
    private const ZMAX : Number = Z_LEVELS / VZPER;
    /* */
    private var ooo : Vector.<O3D>;
    private var cam3d : Cam3D;
    private var depthList : Array;
    private var bg_pts_connect : Array = [[0, 1], [1, 2], [2, 8], [0, 3], [1, 5], [3, 5], [5, 8], [3, 4], [5, 6], [8, 7], [4, 6], [6, 7], [2, 11], [11, 19], [8, 15], [15, 25], [7, 16], [16, 24], [2, 8], [11, 15], [19, 25], [8, 7], [15, 16], [25, 24], [17, 18], [18, 19], [9, 10], [10, 11], [17, 9], [18, 10], [9, 0], [10, 1], [18, 23], [17, 20], [25, 23], [23, 20], [24, 22], [22, 21], [23, 22], [20, 21], [20, 12], [21, 13], [12, 3], [13, 4], [20, 21], [12, 13], [22, 14], [16, 14], [14, 13], [6, 14]];
    private var bg_point : Vector.<V3D>;
    private var skyBox : Shape;
    private var skyBoxG : Graphics;
    private var updateMotion : Function;
    private var wscale : Number;
    private var fillColor : uint;
    private var dstp : Point = new Point();
    private var ang0 : Number = 0.0;
    private var domax : uint;
    private var stateElapsed : int;
    private var id : int;

    function Space3D(fillColor : uint) {
        this.fillColor = fillColor;
        super(null);
        (stage != null) ? onStage(null) : addEventListener(Event.ADDED_TO_STAGE, onStage, false, 0, true);
    }

    private function onStage(e : Event) : void {
        if (e != null) removeEventListener(Event.ADDED_TO_STAGE, onStage);

        stage.addEventListener(Event.RESIZE, resize);
        resize(null);

        /* */

        stage.quality = StageQuality.HIGH;

        var zbmds : Vector.<BitmapData> = new Vector.<BitmapData>(Z_LEVELS, true);
        var ct : ColorTransform = new ColorTransform();
        var blur : BlurFilter = new BlurFilter(0, 0, 3);

        var i : uint;
        while (i < Z_LEVELS) {
            var t : Number = 1 - (i / Z_LEVELS);

            var a : uint = 0xFF << 24;
            var r : uint = (0xFF * (0.8 + 0.2 * (1 - t))) << 16;
            var g : uint = 0xFF * (0.9 + 0.1 * (t - 1)) << 8;
            var b : uint = (0xFF * (0.6 + 0.4 * t)) >> 0;

            var ztex : BitmapData = new BitmapData(2 + (O_SIZE * t), 2 + (O_SIZE * t), true, (a | r | g | b));

            var lum : int = -128 + 256 * (1 - t);
            ct.redOffset = lum;
            ct.greenOffset = lum;
            ct.blueOffset = lum;

            ztex.colorTransform(ztex.rect, ct);

            blur.blurX = blur.blurY = Math.abs(-1 + 2 * t) * BLUR_SIZE;
            var bounds : Rectangle = ztex.generateFilterRect(ztex.rect, blur);
            zbmds[i] = new BitmapData(bounds.width, bounds.height, true);
            zbmds[i].applyFilter(ztex, bounds, dstp, blur);

            ztex.dispose();
            ++i;
        }

        /* */

        ooo = new Vector.<O3D>(O_NUM3, true);
        var cc : uint = 0;
        i = 0;
        while (i < O_NUM) {
            var ii : uint = 0;
            while (ii < O_NUM) {
                var iii : uint = 0;
                while (iii < O_NUM) {
                    ooo[cc] = new O3D(zbmds);
                    ++cc;
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }

        cam3d = new Cam3D(ooo);

        /* */

        skyBox = new Shape();
        skyBoxG = skyBox.graphics;

        var bg_pts_scale : Number = 2;
        var bg_pts_src : Array = [[3.25, 3.25, 3.25], [0, 3.25, 3.25], [-3.25, 3.25, 3.25], [3.25, 0, 3.25], [3.25, -3.25, 3.25], [0, 0, 3.25], [0, -3.25, 3.25], [-3.25, -3.25, 3.25], [-3.25, 0, 3.25], [3.25, 3.25, 0], [0, 3.25, 0], [-3.25, 3.25, 0], [3.25, 0, 0], [3.25, -3.25, 0], [0, -3.25, 0], [-3.25, 0, 0], [-3.25, -3.25, 0], [3.25, 3.25, -3.25], [0, 3.25, -3.25], [-3.25, 3.25, -3.25], [3.25, 0, -3.25], [3.25, -3.25, -3.25], [0, -3.25, -3.25], [0, 0, -3.25], [-3.25, -3.25, -3.25], [-3.25, 0, -3.25]];

        bg_point = new Vector.<V3D>(bg_pts_src.length, true);

        i = bg_pts_src.length;
        while (i-- != 0) {
            bg_point[i] = new V3D(bg_pts_src[i][0] * bg_pts_scale, bg_pts_src[i][1] * bg_pts_scale, bg_pts_src[i][2] * bg_pts_scale);
        }

        changeState();

        stage.quality = StageQuality.LOW;
        addEventListener(Event.ENTER_FRAME, oef);
    }

    private function oef(e : Event) : void {
        /* */

        updateMotion();

        /* */

        var w : Number = bitmapData.width;
        var h : Number = bitmapData.height;
        var cx : Number = w / 2;
        var cy : Number = h / 2;
        var ws : Number = wscale;
        var dist : Number;

        /* */

        cam3d.update();

        var camx : Number = cam3d.x;
        var camy : Number = cam3d.y;
        var camz : Number = cam3d.z;
        var xsa : Number = cam3d.tx - camx;
        var zsa : Number = cam3d.tz - camz;

        cam3d.rot_y = -(Math.atan2(-zsa, xsa) + (1.5707963267948966));
        cam3d.rot_x = -Math.atan2(camy - cam3d.ty, Math.sqrt(xsa * xsa + zsa * zsa));

        var cos_x : Number = Math.cos(cam3d.rot_x);
        var sin_x : Number = Math.sin(cam3d.rot_x);
        var cos_y : Number = Math.cos(cam3d.rot_y);
        var sin_y : Number = Math.sin(cam3d.rot_y);
        var cosx_cosy : Number = cos_x * cos_y;
        var sinx_cosy : Number = sin_x * cos_y;
        var cosx_siny : Number = cos_x * sin_y;
        var sinx_siny : Number = sin_x * sin_y;

        /* */

        for each (var p : V3D in bg_point) {
            var sx : Number = p.dx - camx;
            var sy : Number = p.dy - camy;
            var sz : Number = p.dz - camz;

            var ssz : Number = -sx * cosx_siny + sy * sin_x + sz * cosx_cosy;
            if (ssz > 0) {
                dist = ws / ssz;

                p.x = cx + (sx * cos_y + sz * sin_y) * dist;
                p.y = cy - (sx * sinx_siny + sy * cos_x - sz * sinx_cosy) * dist;
                p.z = ssz;
            }
        }

        skyBoxG.clear();
        skyBoxG.lineStyle(1, 0xE5D8CC, 1.0, false, 'none', 'none');

        var i : uint = bg_pts_connect.length;
        while (i-- != 0) {
            var p0 : V3D = bg_point[bg_pts_connect[i][0]];
            var p1 : V3D = bg_point[bg_pts_connect[i][1]];

            if ((p0.z > 0) && (p1.z > 0)) {
                skyBoxG.moveTo(p0.x, p0.y);
                skyBoxG.lineTo(p1.x, p1.y);
            }
        }

        /* */

        depthList = [];

        i = ooo.length;
        while (i-- != 0) {
            var o : O3D = ooo[i];

            sx = o.dx - camx;
            sy = o.dy - camy;
            sz = o.dz - camz;

            ssz = -sx * cosx_siny + sy * sin_x + sz * cosx_cosy;
            dist = ws / ssz;

            var ox : Number = cx + dist * (sx * cos_y + sz * sin_y);
            var oy : Number = cy - dist * (sx * sinx_siny + sy * cos_x - sz * sinx_cosy);

            if (((ssz > 0) && (ssz < ZMAX)) && ((ox > -O_SIZE) && (ox < w)) && ((oy > -O_SIZE) && (oy < h))) {
                o.x = ox;
                o.y = oy;
                o.z = ssz;
                depthList.push([o, ssz]);
            }
        }

        depthList.sortOn("1", Array.NUMERIC | Array.DESCENDING);

        /* ---> output */

        bitmapData.lock();
        bitmapData.fillRect(bitmapData.rect, fillColor);
        bitmapData.draw(skyBox);

        var len : uint = depthList.length;
        i = 0;
        while (i < len) {
            o = depthList[i][0];
            dstp.x = o.x;
            dstp.y = o.y;

            var obmd : BitmapData = o.zbmds[(o.z * VZPER) >> 0];
            bitmapData.copyPixels(obmd, obmd.rect, dstp);

            i++;
        }

        bitmapData.unlock();
    }

    internal function changeState() : void {
        stateElapsed = 64 + ((64 * Math.random()) >> 0);
        domax = 0;

        id = (7 * Math.random()) >> 0;

        var i : uint;
        var ii : uint;
        var o : O3D;
        var olen : uint = ooo.length;
        var ang : Number;
        var sp : Number;
        var ampy : Number;
        var ocnt : int;

        if (id == 6) {
            i = olen;
            while (i-- != 0) {
                o = ooo[i];
                o.s = 0;
                o.sp = 0.5;
                o.end = false;
                o.vx = Math.random() * 0.5 - 0.25;
                o.vy = Math.random() * 0.5 - 0.25;
                o.vz = Math.random() * 0.5 - 0.25;
            }
        } else if (id == 5) {
            i = olen;
            while (i-- != 0) {
                o = ooo[i];
                o.s = 0;
                o.sp = 0.5;
                o.end = false;
                o.vx += -0.01 + 0.02 * Math.random();
                o.vy += -0.01 + 0.02 * Math.random();
                o.vz += -0.01 + 0.02 * Math.random();
            }
        } else if (id == 4) {
            stateElapsed += 256;

            var sqlen : uint = (Math.sqrt(olen)) >> 0;
            sp = Math.random() * 0.05 + 0.022;
            var sh : Number = -(sqlen - 1) * 0.55 * 0.5;
            ang = 0.0;
            var angv : Number = Math.random() * 0.3 + 0.05;
            ampy = Math.random() * 1 + 1;
            ocnt = 0;

            i = sqlen;
            while (i-- != 0) {
                var gy : Number = Math.cos(ang) * ampy;
                ang = ang + angv;
                ii = sqlen;
                while (ii-- != 0) {
                    o = ooo[ocnt++];
                    o.end = false;
                    o.s = 0;
                    o.sp = sp;
                    o.vz = 0;
                    o.vy = 0;
                    o.vx = 0;
                    o.gx = i * 0.55 + sh;
                    o.gy = gy;
                    o.gz = ii * 0.55 + sh;
                }
            }

            while (ocnt < olen) {
                o = ooo[ocnt];
                o.s = 0;
                o.sp = sp;
                o.end = false;
                o.gx = Math.random() * 7 - 7;
                o.gy = Math.random() * 7 - 7;
                o.gz = Math.random() * 7 - 7;

                ++ocnt;
            }
        } else if (id == 3) {
            sp = 0.022 + 0.05 * Math.random();
            ampy = 0.02 + 0.025 * Math.random();
            var cy : Number = (-(ampy)) * olen * 0.44;

            i = 0;
            while (i < olen) {
                o = ooo[i];
                o.s = 0;
                o.sp = sp;
                o.end = false;
                if (Math.random() > 0.05) {
                    o.gx = i * ampy + cy;
                    o.gy = Math.random() * 1.7 - 0.85;
                    o.gz = Math.random() * 1.7 - 0.85;
                } else {
                    o.gx = Math.random() * 14 - 7;
                    o.gy = Math.random() * 14 - 7;
                    o.gz = Math.random() * 14 - 7;
                }
                ++i;
            }
        } else if (id == 2) {
            sp = Math.random() * 0.05 + 0.022;
            var len : int = O_NUM;
            ocnt = 0;
            var amp : Number = 0.8 + 0.2 * Math.random();
            var center : Number = -(len - 1) * amp * 0.5;

            i = 0;
            while (i < len) {
                ii = 0;
                while (ii < len) {
                    var iii : uint = 0;
                    while (iii < len) {
                        o = ooo[ocnt++];
                        o.s = 0;
                        o.sp = sp;
                        o.gx = i * amp + center;
                        o.gy = ii * amp + center;
                        o.gz = iii * amp + center;
                        ++iii;
                    }
                    ++ii;
                }
                ++i;
            }
            while (ocnt < olen) {
                o = ooo[ocnt];
                o.s = 0;
                o.sp = sp;
                o.vx = Math.random() * 1 - 0.5;
                o.vy = Math.random() * 1 - 0.5;
                o.vz = Math.random() * 1 - 0.5;
                o.end = false;
                o.gx = Math.random() * 14 - 7;
                o.gy = Math.random() * 14 - 7;
                o.gz = Math.random() * 14 - 7;
                ++ocnt;
            }
        } else if (id == 1) {
            var ay : Number = 0;
            var axz : Number = 0;
            var ayStep : Number = (3.141592653589793) * 2 / olen;
            var axzStep : Number = ayStep * (1 + (Math.random() * 40) >> 0);
            var d : Number = 3 + Math.random() * 5;
            sp = Math.random() * 0.05 + 0.022;

            i = 0;
            while (i < olen) {
                o = ooo[i];
                o.s = 0;
                o.sp = sp;
                o.end = false;
                var wave : Number = Math.cos(ay) * d;
                if (Math.random() > 0.06) {
                    o.gx = Math.cos(axz) * wave;
                    o.gy = Math.sin(ay) * d;
                    o.gz = Math.sin(axz) * wave;
                } else {
                    o.gx = Math.random() * 14 - 7;
                    o.gy = Math.random() * 14 - 7;
                    o.gz = Math.random() * 14 - 7;
                }
                ay = ay + ayStep;
                axz += axzStep;
                ++i;
            }
        } else {
            ang = 0.0;
            var va : Number = ((3.141592653589793) * 2 / olen) * (1 + ((Math.random() * 40) >> 0));
            sp = 0.022 + 0.05 * Math.random();
            var dy : Number = (olen - 50) * 0.004;
            i = olen;
            while (i-- != 0) {
                o = ooo[i];
                o.s = 0;
                o.sp = sp;
                o.end = false;
                if (i < (olen - 50)) {
                    o.gx = Math.cos(ang) * 4;
                    o.gy = i * 0.008 - dy;
                    o.gz = Math.sin(ang) * 4;
                } else {
                    o.gx = Math.random() * 14 - 7;
                    o.gy = Math.random() * 14 - 7;
                    o.gz = Math.random() * 14 - 7;
                }
                ang += va;
            }
        }

        if (id == 4) // 4 : ONDULATE
        {
            var ond_amp : Number = 0.5 + 2.0 * Math.random();
            var ond_freq : Number = 0.2 + 0.4 * Math.random();

            updateMotion = function() : void {
                var a : Number = (ang0 += 0.11);
                var ocnt : uint;
                var len : uint = ooo.length;
                var sqlen : uint = Math.sqrt(len) >> 0;

                var i : uint = sqlen;
                while (i-- != 0) {
                    a += ond_freq;
                    var gy : Number = ond_amp * Math.cos(a);

                    var ii : uint = sqlen;
                    while (ii-- != 0) {
                        var o : O3D = ooo[ocnt++];
                        o.gy = gy;
                    }
                }

                i = domax;
                while (i-- != 0) {
                    o = ooo[i];

                    if (o.s < 0.5) o.s += o.sp;

                    o.dx += (o.gx - o.dx) * o.s;
                    o.dy += (o.gy - o.dy) * o.s;
                    o.dz += (o.gz - o.dz) * o.s;
                }

                domax += (len >> 5);
                if (domax > len) domax = len;

                if (stateElapsed-- == 0) changeState();
            };
        } else if (id == 5) // 5 : DISPERSE
        {
            updateMotion = function() : void {
                var i : uint = domax;
                while (i-- != 0) {
                    var o : O3D = ooo[i];
                    o.dx += o.vx;
                    o.dy += o.vy;
                    o.dz += o.vz;
                }

                domax += 8;
                if (domax > ooo.length) domax = ooo.length;

                if (stateElapsed-- == 0) changeState();
            };
        } else if (id == 6) // 6 : FALL
        {
            updateMotion = function() : void {
                var i : uint = ooo.length;
                while (i-- != 0) {
                    var o : O3D = ooo[i];
                    o.dy += o.vy;
                    o.vy -= 0.06;

                    if (o.dy < -9) {
                        o.dy = -9;
                        o.vy *= -o.sp;
                        o.sp *= 0.9;
                    }
                }

                if (stateElapsed-- == 0) changeState();
            };
        } else // 0 1 2 3 : LINEAR
        {
            updateMotion = function() : void {
                var i : uint = domax;
                while (i-- != 0) {
                    var o : O3D = ooo[i];
                    if (o.s < 0.8) {
                        o.s += o.sp;
                        o.dx += (o.gx - o.dx) * o.s;
                        o.dy += (o.gy - o.dy) * o.s;
                        o.dz += (o.gz - o.dz) * o.s;
                    }
                }

                var len : uint = ooo.length;
                domax += (len >> 5);
                if (domax > len) domax = len;

                if (stateElapsed-- == 0) changeState();
            };
        }
    }

    private function resize(e : Event) : void {
        var w : int = stage.stageWidth;
        var h : int = stage.stageHeight;

        if (bitmapData != null) bitmapData.dispose();
        bitmapData = new BitmapData(w, h, false);

        var f : Number = Math.tan(FOV / 2 * (3.141592653589793) / 180);
        wscale = w * NEAR_Z / (f * NEAR_Z * 2);
    }
}

internal class Cam3D {
    public var x : Number = 0.0;
    public var y : Number = -32.0;
    public var z : Number = 0.0;
    public var tx : Number = 0.0;
    public var ty : Number = 0.0;
    public var tz : Number = 0.0;
    public var rot_x : Number = 0.0;
    public var rot_y : Number = 0.0;
    public var rot_z : Number = 0.0;
    /* */
    private var ooo : Vector.<O3D>;
    private var o : O3D;
    private var cut : uint = 1;
    private var v : Number;
    private var py : Number;
    private var av : Number;
    private var trk : Number;
    private var a : Number = -(3.141592653589793) / 2;
    private var dxz : Number = 14.0;
    private var tdxz : Number;

    function Cam3D(ooo : Vector.<O3D>) {
        this.ooo = ooo;
        x = Math.cos(a) * dxz;
        z = Math.sin(a) * dxz;
    }

    public function update() : void {
        cut--;
        if (cut == 0) {
            cut = 128 + ((Math.random() * 128) >> 0);
            py = -2 + 4 * Math.random();
            av = -0.03 + 0.06 * Math.random();
            tdxz = 8 + 4 * Math.random();
            v = 0.0;
            trk = 0.0;
            o = ooo[Math.random() * ooo.length >> 0];
        }

        if (trk < 0.5) trk += 0.005;
        if (v < 0.5) v += 0.005;
        tx += (o.dx - tx) * trk;
        ty += (o.dy - ty) * trk;
        tz += (o.dz - tz) * trk;
        a += av;
        dxz += (tdxz - dxz) * 0.1;
        x += ((o.dx + dxz * Math.cos(a)) - x) * v;
        y += ((o.dy + py) - y) * v;
        z += ((o.dz + dxz * Math.sin(a)) - z) * v;
    }
}

internal class V3D {
    public var x : Number;
    public var y : Number;
    public var z : Number;
    public var dx : Number;
    public var dy : Number;
    public var dz : Number;

    function V3D(dx : Number = 0.0, dy : Number = 0.0, dz : Number = 0.0, x : Number = 0.0, y : Number = 0.0, z : Number = 0.0) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

internal class O3D {
    public var zbmds : Vector.<BitmapData>;
    public var end : Boolean;
    public var y : Number = 0.0;
    public var x : Number = 0.0;
    public var z : Number = 0.0;
    public var gx : Number = 0.0;
    public var gy : Number = 0.0;
    public var gz : Number = 0.0;
    public var dz : Number = 0.0;
    public var dy : Number = 0.0;
    public var dx : Number = 0.0;
    public var vx : Number = 0.0;
    public var vz : Number = 0.0;
    public var vy : Number = 0.0;
    public var sp : Number = 0.0;
    public var s : Number = 0.0;

    function O3D(zbmds : Vector.<BitmapData>) {
        this.zbmds = zbmds;
    }
}