/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p4bu
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
    import flash.system.*;
    import caurina.transitions.Tweener;
    
    public class FlashTest extends Sprite {
        private var checkNum:int = 1;
        private var txt:TextField = new TextField();
        private var txt2:TextField = new TextField();
        private var txt3:TextField = new TextField();//デバッグ
        private var panelNum:int;
        private var panelList:Array;
        private var numList:Array;
        private var panelMain:Sprite = new Sprite();
        private var stTime:Date;
        private var prevTime:Date;
        
        private var level:int;
        //private var exp:int;
        private var bestScore:int;//ベストスコア
        private var score:int;//スコア
        private var combo:int;//コンボ数
        private var retryCnt:int;//リトライ回数
        private var saveData:Object = new Object();
        
        private var panelX:int;
        private var panelY:int;
        
        private var scoreCnt:int;//表示されるポイント
        private var expCnt:int;
        private var save:SaveData;
        private var deffScore:Object = new Object();
        private var deffState:Object;
        
        //レベルアップ経験値
        private var nextLv:Array = [0,50,100,150,250,400,
                                    600,800,1000,1500,2000,2500,
                                    
                                    3500,4700,6000,7900,10000,
                                    12000,14000,16000,18000,21000,
                                    
                                    24000,27000,30000,32000,33000,
                                    34000,35000,37000,38000,40000,
                                    
                                    42000,45000,50000,55000,60000,
                                    65000,70000,80000,90000,100000,
                                    
                                    110000,125000,140000,155000,170000,
                                    195000,220000,250000,270000,300000
                                    ];
 
 
        
        public function FlashTest() {
            // write as3 code here..  
            
            save = new SaveData("my_data");
            //save.clear();
            if(save.length==0)initSaveData();
            saveData = save.data;
            if(saveData.hasOwnProperty("deff"))deffScore = saveData["deff"];
            var format:TextFormat = new TextFormat();
            format.align = TextFormatAlign.LEFT;    // 整列
            format.font = "ＭＳ ゴシック";        // フォント名
            format.size = 30;        // 文字のポイントサイズ
            
            txt.defaultTextFormat = format;          
            txt2.defaultTextFormat = format;
 
   
            setStartPanel();
            
        }
        
        //全画面
        private function f1(e:MouseEvent):void{
            txt.x = 0;
            txt.y = 0;
            
            txt2.x = 400;
            txt2.width = 200;
            txt2.height = 50;
            addChild(txt2);
            
            stage.displayState = StageDisplayState.FULL_SCREEN;
            //setPanel(4+Math.random()*11,3+Math.random()*4);
            txt2.text = saveData["exp"];
            expCnt = saveData["exp"];
            
            //gameStart();
            f2();
            
            var menu:ActionBtn = new ActionBtn();
                menu.x = -120;
                menu.y = 20 ;
                addChild(menu);
                menu.init({id: 1, label: "トレーニング終了", width: 80});
                menu.addEventListener(MouseEvent.CLICK, function():void{
                    //setPanel(4+Math.random()*11,3+Math.random()*4);
                    //gameStart();
                    //stage.displayState = StageDisplayState.NORMAL;
                    setStartPanel();
                });
             
            var menu2:ActionBtn = new ActionBtn();
                menu2.x = 600 ;
                menu2.y = 20 ;
                addChild(menu2);
                menu2.init({id: 2, label: "リセット", width: 80});
                menu2.addEventListener(MouseEvent.CLICK,f2);
        }

        
        //新しいパターンでスタート
        private function f2(e:MouseEvent=null):void{
            var a:int = 6 + saveData["level"]/3;
            var b:int = a-((a-2)*Math.random());
            var limitX:int = 25;
            var limitY:int = 12;
            if(saveData["level"]<35)limitX = 13;
            else if(saveData["level"]<40)limitX = 17
            if(limitX<b)b=limitX;

            var c:int = a-b+2;
            
            if(saveData["level"]<20)limitY = 5;
            else if(saveData["level"]<25)limitY = 6;
            else if(saveData["level"]<30)limitY = 7;
            else if(saveData["level"]<35)limitY = 8;
            else if(saveData["level"]<40)limitY = 9;
            else if(saveData["level"]<45)limitY = 10;
            else if(saveData["level"]<50)limitY = 11;
            
            if(limitY<c)c=limitY;
            
            
            setPanel(b,c);
            //setPanel(4+Math.random()*11,3+Math.random()*4);
            gameStart();
        }
        
        
        
        //レベルを下げてスタート
        private function f3():void{
            
            if(panelX<panelY)panelY-=2;
            else panelX-=2
            
            if(panelX<1)panelX=1;
            if(panelY<1)panelY=1;
            
            setPanel(panelX,panelY);
            gameStart();
        }
        
 

//------------------------------------->        
        //セーブデータ初期化
        private function initSaveData():void{
            var obj:Object = new Object();
            var exp:int=0;
            var level:int=1;
            obj["exp"]=0;
            obj["level"]=level;
            
            save.data=obj;
        }

        
        //スタート画面表示
        private function setStartPanel():void{
            removeEventListener(Event.ENTER_FRAME,onFrame);
            while(0<panelMain.numChildren)panelMain.removeChildAt(0);
            while(0<this.numChildren)removeChildAt(0);
            
            addChild(txt);
            //txt.y = 350;
            txt.width =400;
            txt.text = checkNum.toString();
            addChild(panelMain);
            
            txt2.x = 400;
            txt2.width = 200;
            txt2.height = 50;
            //addChild(txt2);
            stage.displayState = StageDisplayState.NORMAL;
            txt.x = 40;
            txt.y = 150;
            txt.text = "周辺視野拡大トレーニング2\n\n"+"　　　　クリック";            
            
            addEventListener(MouseEvent.MOUSE_UP,f1);//ゲーム画面遷移
            
        }
        


        
 //----------------------------      
        private function setPanel(sizeX:int,sizeY:int):void{
            var name:String = (sizeX*sizeY).toString();
            if(!deffScore.hasOwnProperty(name)){
                var obj:Object = new Object();
                deffScore[name] = obj;
                deffState = obj;
                deffState["clearCnt"] = 0;
                deffState["score"] = 0;
                deffState["miss"] = 3;
                deffState["name"] = name;
                deffState["combo"] = 0;
                deffState["best"] = 0;
                deffScore[name] = deffState;
                
            }
            else{
                deffState = deffScore[name];
            }
            
            removeEventListener(MouseEvent.MOUSE_UP,f1);
            while(0<panelMain.numChildren)panelMain.removeChildAt(0);
            panelMain.y = 50;
            panelMain.x = (455/2)-sizeX*26;
            retryCnt=0;
            bestScore=0;
            
            panelX=sizeX;
            panelY=sizeY;
            
            var list:Array = new Array();
            panelList = new Array();
            for(var i:int=0;i<sizeY;i++){
                for(var j:int=0;j<sizeX;j++){
                    var p1:panel = new panel();
                    p1.x = (p1.width+1)*j;
                    p1.y = (p1.height+1)*i;
                    p1.addEventListener(MouseEvent.MOUSE_UP,onClick);
                    panelMain.addChild(p1);
                    list.push(p1);
                    panelList.push(p1);
                    
                    
                } 
            }
            
            panelNum=sizeX*sizeY;
            var cnt:int=1;
            numList = new Array();
            while(0<list.length){
                var a:int=(list.length)*Math.random();
                //txt.text+=a.toString()+" ";
                //var p:panel = list.pop(a);
                list[a].num = cnt;
                numList.push(list[a]);
                list.splice(a,1);
                //delete list[a];
                cnt++;
            }
            
            ///*
            //スクリーンサイズ
            var screenW:int = Capabilities.screenResolutionX/1.3;
            var screenH:int = Capabilities.screenResolutionY/3;
            //スケールの調整
            var scaleX:Number=1;
            var scaleY:Number=1;
            if(screenW < sizeX*(panelList[0].width*2)){ 
                scaleX = (screenW / ((panelList[0].width*2)*sizeX));
                //panelMain.scaleX = panelMain.scaleY = scale;
                
            }
            
            if(screenH < sizeY*26*2){
                 scaleY = (screenH / ((26*2)*sizeY));
            }
            
            if(scaleY<scaleX)panelMain.scaleX = panelMain.scaleY = scaleY;
            else panelMain.scaleX = panelMain.scaleY = scaleX;
            
            
            
            panelMain.x = (455/2) - (panelMain.width/2);
            //*/
            
            test1();
            addChild(txt3);
            
        }
        
        private function test1():void{
            //addChild(txt3);
            txt3.text = "test";
            txt3.y = 30;
            var str:String = new String();
            for(var key:String in deffState){
                str += key+":"+deffState[key].toString()+"  ";
            }
            for(var i:int=0;i<3-missCnt;i++){
                str+= " ★";    
            }
            txt3.text = str;
            txt3.width = txt3.textWidth+10;
            txt3.height = txt3.textHeight+5;
        }
        
        
        private var endTime:Number;

        //ゲーム開始
        private function gameStart():void{
            checkNum=1;
            for(var i:int=0;i<panelList.length;i++){
                panelList[i].alpha = 1.0;
            }
            
            
            score = 0;
            scoreCnt=0;
            combo=0;
            missCnt=0;
            //txt.text = "game start";
            txt.text = "Lv:"+saveData["level"].toString()+" ["+checkNum.toString()+ "]    score:"+scoreCnt.toString();
            stTime = new Date();
            endTime = stTime.time
            
            prevTime = new Date();
            addEventListener(Event.ENTER_FRAME,onFrame);
            test1();
            
        }
        
        private var missCnt:int=0;

        //パネルクリック
        private function onClick(e:MouseEvent):void{

            if(2<missCnt)return;
            
            if(e.currentTarget.text != numList[checkNum-1].text){
                combo=0;
                return;
            }
            //正解クリック
            var now:Date = new Date();
            var time:int = now.valueOf()-prevTime.valueOf();
            var pt:int = 0;
            if(time<1000){
                score += 200;
                pt = 200;
                combo++;
            }
            else if(time<2000){
                score += 100;
                pt = 100;
                combo++;
            }
            else if(time<3000){
                score += 50;
                pt = 50;
                combo++;
            }
            else if(time<4000){
                score += 30;
                pt = 30;
                combo++;
                
            }
            else if(time<5000){
                score += 20;
                pt = 20;
                combo=0;
                //missCnt++;
            }
            else{
                score += 10;
                pt = 10;
                combo=0;
                missCnt++;
            }
                
            if(deffState["combo"]<combo){
                deffState["combo"] = combo;
                new ScoreIndicator(this,20,30,"コンボ更新",0xffffff,0x000000,20); 
                
            }
            if(deffState["score"] < score){
                deffState["score"] = score;
            }
            if(deffState["best"] < checkNum){
                new ScoreIndicator(this,220,30,"自己ベスト更新",0xffffff,0x000000,20);
            }
                
                
            pt+= combo*10;
            var c1:int = 0x0000ff;
            var c2:int = 0xffffff;
                
            var n:int = 3;
            if(combo<n*1){
                c1 = 0xaaaaff;
                c2 = 0x000000;
                    
            }
            else if(combo<n*2){
                c1 = 0x00aaff;
                c2 = 0x000000;
            }
            else if(combo<n*3){
                c1 = 0x00ff00;
                c2 = 0x000000;
                
            }
            else if(combo<n*4){
                c1 = 0xaaff00;
                c2 = 0x000000;
                    
            }
            else if(combo<n*5){
                c1 = 0xffff00;
                c2 = 0x000000;
            }
            else if(combo<n*6){
                c1 = 0xffaa00;
                c2 = 0x000000;
            }
            else if(combo<n*7){
                c1 = 0xff0000;
                c2 = 0x000000;
            }
            else if(combo<n*8){
                c1 = 0xff00ff;
                c2 = 0x000000;
            }
            else if(combo<n*9){
                c1 = 0x00aa00;
                c2 = 0xffffff;
            }

            test1();



            score += combo*10;
            prevTime = now;
            new ScoreIndicator(panelMain,panelMain.mouseX,panelMain.mouseY,"+"+pt.toString(),c2,c1,20);
            if(1<combo)new ScoreIndicator(panelMain,panelMain.mouseX,panelMain.mouseY+10,combo.toString()+"combo",c2,c1,10);    
            e.currentTarget.alpha = 0.3;
            e.currentTarget.draw(0x000000);
            //numList[checkNum-1].draw(0x000000);
                
            checkNum++;
            //txt.text = checkNum.toString()+ "    score:"+score.toString();
            if(panelNum+1==checkNum){
                    
                deffState["clearCnt"] = deffState["clearCnt"]+1;
                if(deffState["score"] < score)deffState["score"] = score;
                if(missCnt < deffState["miss"])deffState["miss"] = missCnt;
                test1();
                deffState["best"]=checkNum-1;
                new ScoreIndicator(this,223,200,"stage clear!!",0xffffff,0x000000,40); 
                gameClear();//クリア
                checkNum=0;
            }
 

        }//onClick
        
        //ゲームクリア
        private var clearStr:String;
        private function gameClear():void{
            removeEventListener(Event.ENTER_FRAME,onFrame);
            if(bestScore<score && 0<retryCnt){
                 clearStr = "BestScore  "+bestScore.toString()+" -> "+score.toString();
                 bestScore = score;
            }
            else{
                if(retryCnt==0) bestScore = score;
                clearStr = "best "+bestScore.toString()+" score:"+score.toString();
            }
            
            
            
            var a:int = numList.length;
            var ex:int = (score/200)*(a/5)
            clearStr += " +"+ex.toString()+"pt";
            saveData["exp"] += ex;
            var lv:int = saveData["level"];
            while(nextLv[lv] <= saveData["exp"]){//レベルアップ
                if(nextLv.length<=saveData["level"])break;
                saveData["level"]++;
                lv = saveData["level"];
            }
            deffScore[deffState.name] = deffState;
            saveData["deff"] = deffScore;

            save.data =saveData;
            
            
            
            var menu4:ActionBtn = new ActionBtn();
                menu4.x = 700 ;
                menu4.y = 230 ;
                addChild(menu4);
                menu4.init({id: 2, label: "次へ", width: 80});
                menu4.addEventListener(MouseEvent.MOUSE_UP,function():void{ 
                    Tweener.addTween(menu3, {
                        time: 0.5,
                        //x: px,
                        alpha: 0,
                        transition: "easeOutQuar",
                        onComplete: function():void{
                            addEventListener(Event.ENTER_FRAME,onFrame);
                            if(missCnt<2)f2();
                            else f3();
                            removeChild(menu3);
                            removeChild(menu4);
                            menu3=null;
                            menu4=null;
                        }
                    });
                    Tweener.addTween(menu4, {
                        time: 0.5,
                        //x: px,
                        alpha: 0,
                        transition: "easeOutQuar"
                    });
                });
            //var scale:Number = 1;
            var px:Number = (455/2) + 70;

            Tweener.addTween(menu4, {
                time: 0.8,
                x: px,
                transition: "easeOutQuar"
            });
            
            var menu3:ActionBtn = new ActionBtn();
                menu3.x = 700 ;
                menu3.y = 230 ;
                addChild(menu3);
                menu3.init({id: 2, label: "リトライ", width: 80});
                menu3.addEventListener(MouseEvent.MOUSE_UP,function():void{
                    Tweener.addTween(menu3, {
                        time: 0.5,
                        //x: px,
                        alpha: 0,
                        transition: "easeOutQuar",
                        onComplete: function():void{
                            addEventListener(Event.ENTER_FRAME,onFrame);
                            if(0<checkNum)numList[checkNum-1].draw(0x000000);
                            retryCnt++;
                            gameStart();
                            removeChild(menu3);
                            removeChild(menu4);
                            menu3=null;
                            menu4=null;
                        }

                    });
                    Tweener.addTween(menu4, {
                        time: 0.5,
                        //x: px,
                        alpha: 0,
                        transition: "easeOutQuar"
                    });
                });
            var px2:Number = (455/2) - 70;
            Tweener.addTween(menu3, {
                time: 0.8,
                x: px2,
                transition: "easeOutQuar"
            });
            test1();
        }
   
        

        
        private function getTime():Number{
            var now:Date = new Date();
            var time:Number = now.valueOf()-stTime.valueOf();
            return time/1000;
        }

        private function onFrame(e:Event):void{
            var now:Date = new Date();
            var time:int = now.valueOf()-prevTime.valueOf();
            
            if(scoreCnt<score){
                if(scoreCnt+200<score)scoreCnt=score-200;
                scoreCnt+=10;
                txt.text = "Lv:"+saveData["level"].toString()+" ["+checkNum.toString()+ "]    score:"+scoreCnt.toString();
                
            }
            if(expCnt<saveData["exp"]){
                var val:int = (saveData["exp"]-expCnt)/5;
                if(val<2)expCnt++;
                else expCnt += val;
                var lv:int = saveData["level"]
                var n:int = nextLv[lv];
                txt2.text = "exp:"+(n-expCnt).toString();
            }
            //else clearStr ="";


            
            if(time<5000){
                return;
            }
            else if(time<8000){
                numList[checkNum-1].draw(0x00ff00);
                //ゲームオーバー
                if(2<=missCnt){
                    new ScoreIndicator(this,223,200,"終了",0x000000,0xcccccc,40); 
                    deffState["best"]=checkNum;
                    missCnt++;
                    gameClear();//クリア
                    return;
                }
                return;
            }
            else if(time<10000){
                numList[checkNum-1].draw(0xffaa00);
                return;
            }
            else if(time<11000){
                numList[checkNum-1].draw(0xff0000);
                return;
            }
            
            

            //txt.text = checkNum.toString()+"        time:"+getTime().toString();
        }//onFrame
        


    }//class
    

}//package



///---------------------------------------------------------
import flash.display.*;
import flash.events.*;
import flash.text.*;
class panel extends Sprite{
    private var _num:int;
    public var tf:TextField;
    public function panel(){
        tf = new TextField();
        var format:TextFormat = new TextFormat();
        format.align = TextFormatAlign.CENTER;    // 整列
        format.font = "ＭＳ ゴシック";        // フォント名
        format.size = 25;        // 文字のポイントサイズ
        tf.defaultTextFormat = format;
        
        tf.selectable = false;
        tf.width = 50;
        tf.height = 40;
        tf.y = 8;
        tf.text = "test";
        
        addChild(tf);
        draw();

    }
    
    public function set text(str:String):void{
        tf.text = str;
    }
    public function get text():String{
        return tf.text;
    }


    public function set num(n:int):void{
        _num = n;
        tf.text = _num.toString();
    }
    public function get num():int{
        return _num;
    }

    public function draw(col:uint=0x000000):void{
        this.graphics.clear();
        this.graphics.lineStyle(2,col);
        //this.graphics.drawRect(0,0,50,50);
        this.graphics.beginFill(0x000000,0);
        this.graphics.drawRoundRect(0,0,50,50,5,5);
        this.graphics.endFill();
        
    }

}




//////////////////////////////////////////////////

// ActionBtnクラス

//////////////////////////////////////////////////



import flash.display.Sprite;

import flash.display.Shape;

import flash.text.TextField;

import flash.text.TextFieldType;

import flash.text.AntiAliasType;

import flash.text.TextFormat;

import flash.text.TextFormatAlign;

import flash.filters.DropShadowFilter;

import flash.geom.Matrix;

import flash.display.GradientType;

import flash.display.SpreadMethod;

import flash.display.InterpolationMethod;

import flash.geom.ColorTransform;

import flash.events.Event;

import flash.events.MouseEvent;



class ActionBtn extends Sprite {

    public var id:uint;

    private var shade:Shape;

    private var base:Shape;

    private var front:Shape;

    private var light:Shape;

    private var overlay:Shape;

    private var txt:TextField;

    private var label:String = "";

    private static var fontType:String = "_ゴシック";

    private var _width:uint = 60;

    private static var _height:uint = 32;

    private static var corner:uint = 6;

    private static var tHeight:uint = 17;

    private static var bColor:uint = 0xFFFFFF;

    private static var sColor:uint = 0x000000;

    private static var baseColor:uint = 0x0066CC;

    private static var lightColor:uint = 0x00FFFF;

    private static var overColor:uint = 0x3333FF;

    private static var tColor:uint = 0xFFFFFF;

    private static var defaultColorTrans:ColorTransform;

    private static var disableColor:uint = 0xCCCCCC;

    private static var disableColorTrans:ColorTransform;

    private var mode:int;

    private var _selected:Boolean = false;

    private var _enabled:Boolean = true;



    public function ActionBtn() {

    }



    public function init(option:Object):void {

        if (option.id != undefined) id = option.id;

        if (option.label != undefined) label = option.label;

        if (option.width != undefined) _width = option.width;

        draw();

    }

    private function draw():void {

        defaultColorTrans = new ColorTransform();

        disableColorTrans = new ColorTransform();

        disableColorTrans.color = disableColor;

        shade = new Shape();

        base = new Shape();

        front = new Shape();

        light = new Shape();

        overlay = new Shape();

        txt = new TextField();

        addChild(shade);

        addChild(base);

        addChild(front);

        addChild(light);

        addChild(overlay);

        addChild(txt);

        createBase(shade, _width, _height, corner, bColor);

        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];

        createBase(base, _width-2, _height-2, corner, baseColor);

        createFront(front, _width, _height, corner);

        createLight(light, _width-2, _height-2, corner);

        createOverlay(overlay, _width-2, _height-2, corner);

        txt.x = -_width/2;

        txt.y = -tHeight + _height/4;

        txt.width = _width;

        txt.height = tHeight;

        txt.type = TextFieldType.DYNAMIC;

        txt.selectable = false;

        //txt.embedFonts = true;

        //txt.antiAliasType = AntiAliasType.ADVANCED;

        var tf:TextFormat = new TextFormat();

        tf.font = fontType;

        tf.size = 10;

        tf.align = TextFormatAlign.CENTER;

        txt.defaultTextFormat = tf;

        txt.textColor = tColor;

        txt.text = label;

        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];

        light.alpha = 0;

        enabled = true;

        mouseChildren = false;

    }

    private function rollOver(evt:MouseEvent = null):void {

        mode = 1;

        addEventListener(Event.ENTER_FRAME, action, false, 0, true);

    }

    private function rollOut(evt:MouseEvent = null):void {

        mode = -1;

        addEventListener(Event.ENTER_FRAME, action, false, 0, true);

    }

    private function action(evt:Event):void {

        light.alpha += 0.1*mode;

        if (light.alpha < 0) {

            light.alpha = 0;

            removeEventListener(Event.ENTER_FRAME, action);

        }

        if (light.alpha > 1) {

            light.alpha = 1;

            removeEventListener(Event.ENTER_FRAME, action);

        }

    }

    private function _up():void {

        base.transform.colorTransform = defaultColorTrans;

        front.transform.colorTransform = defaultColorTrans;

    }

    private function _down():void {

        base.transform.colorTransform = defaultColorTrans;

        front.transform.colorTransform = defaultColorTrans;

        light.alpha = 1;

    }

    private function _disable():void {

        base.transform.colorTransform = disableColorTrans;

        front.transform.colorTransform = disableColorTrans;

    }

    public function get selected():Boolean {

        return _selected;

    }

    public function set selected(param:Boolean):void {

        _selected = param;

        enabled = !_selected;

        if (_selected) {

            _down();

        } else {

            _up();

            rollOut();

        }

    }

    public function get enabled():Boolean {

        return _enabled;

    }

    public function set enabled(param:Boolean):void {

        _enabled = param;

        buttonMode = _enabled;

        mouseEnabled = _enabled;

        useHandCursor = _enabled;

        if (_enabled) {

            _up();

            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);

            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);

        } else {

            _disable();

            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);

            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);

        }

    }

    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {

        target.graphics.beginFill(color, alpha);

        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);

        target.graphics.endFill();

    }

    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {

        var colors:Array = [baseColor, baseColor];

        var alphas:Array = [0, 0.5];

        var ratios:Array = [0, 255];

        var matrix:Matrix = new Matrix();

        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);

        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);

        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);

        target.graphics.endFill();

    }

    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {

        var colors:Array = [lightColor, overColor];

        var alphas:Array = [1, 0];

        var ratios:Array = [40, 160];

        var matrix:Matrix = new Matrix();

        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);

        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);

        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);

        target.graphics.endFill();

    }

    private function createOverlay(target:Shape, w:uint, h:uint, c:uint):void {

        target.graphics.beginFill(bColor, 0.3);

        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);

        target.graphics.endFill();

        var _mask:Shape = new Shape();

        _mask.graphics.beginFill(sColor);

        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);

        _mask.graphics.endFill();

        addChild(_mask);

        target.mask = _mask;

    }



}





//////////////////////////////////////////////////

// BitmapTileクラス

//////////////////////////////////////////////////



import flash.display.Shape;

import flash.display.BitmapData;

import flash.geom.ColorTransform;



class BitmapTile extends Shape {

    private var _width:uint;

    private var _height:uint;



    public function BitmapTile(w:uint, h:uint, Tile:Class, color:uint = 0x000000) {

        _width = w;

        _height = h;

        draw(Tile, color);

    }



    private function draw(Tile:Class, color:uint):void {

        var tile:BitmapData = new Tile();

        var bitmapdata:BitmapData = new BitmapData(tile.width, tile.height);

        var colorTrans:ColorTransform = new ColorTransform();

        colorTrans.color = color;

        bitmapdata.draw(tile, null, colorTrans);

        graphics.beginBitmapFill(bitmapdata, null, true);

        graphics.drawRect(0, 0, _width, _height);

        graphics.endFill();

    }



}





import flash.display.BitmapData;



class Tile6 extends BitmapData {

    private static var size:uint = 6;

    private static var color:uint = 0xFF000000;



    public function Tile6() {

        super(size, size, true, 0x00000000);

        init();

    }



    private function init():void {

        setPixel32(0, 2, color);

        setPixel32(0, 5, color);

        setPixel32(1, 1, color);

        setPixel32(1, 4, color);

        setPixel32(2, 0, color);

        setPixel32(2, 3, color);

        setPixel32(3, 2, color);

        setPixel32(3, 5, color);

        setPixel32(4, 1, color);

        setPixel32(4, 4, color);

        setPixel32(5, 0, color);

        setPixel32(5, 3, color);

    }



}



//-------Objectデータをローカルに保存する------------------------------------------------

    import flash.net.*;

    class SaveData{

        private var so:SharedObject;

        //オブジェクト名を指定して開く

        public function SaveData(name:String){

            so = SharedObject.getLocal(name);

        }



        //データロード

        public function get data():Object{

            var obj:Object;

            if(so){ 

                obj = so.data;

                return obj;

            }      

            return null;

        }

        

        //データセーブ

        public function set data(obj:Object):void{

            if(so){

                for(var str:String in obj){

                    so.data[str] = obj[str];

                }

            }

        }

        //データ消去

        public function clear():void{

            if(so){

                so.clear();

            }

        }

        public function get length():int{

            var cnt:int=0;

            for(var str:String in so.data)cnt++;

            return cnt;

        }



        

        //データ確認

        public function show():String{

            var text:String = new String();

            for(var str:String in so.data){ 

                text += str;

                text += "="+so.data[str].toString()+"\n";

            }

            return text;

        }



    }
    
    
    
    
    
// -----------------------------------------------------------------------------------------

// ScoreIndicator

// -----------------------------------------------------------------------------------------

//package {
    import flash.display.*;
    import flash.events.Event; 
    import flash.text.TextField;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;    

    //public
    class ScoreIndicator extends Sprite {
        private var _chars:Vector.<TextField>;
        private var _charIndex:int;
        private var _numCompleted:int;
        //private var color1:uint = 0x0000ff;
        private var color1:uint = 0xffffff;
        //private var color2:uint = 0x00007f;
        private var color2:uint = 0xaaaaff;
        private var _size:Number;
        private var _time:Number;
        
        public function ScoreIndicator(parent:DisplayObjectContainer, centerX:int, bottomY:int, text:String,
                            c1:uint=0xffffff,c2:uint=0xaaaaff,size:Number=50,time:Number=2.3) {
            parent.addChild(this);
            this.mouseEnabled = false;
            x = centerX;
            y = bottomY;
            _size = size;
            _time = time;            
            color1 = c1;
            color2 = c2;          
            _chars = new Vector.<TextField>();
            _charIndex = 0;
            _numCompleted = 0;
            
            splitText(text);//文字列を文字に分割
            alignChars();
            playTween();
            
            addEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
        }
        
        //文字列分割
        private function splitText(text:String):void {
            //this.scaleX = 2;
            //this.scaleY = 2;
            // 文字のスタイルを設定する
            var builder:TextBuilder = new TextBuilder();
            builder.autoCorrect(false).autoSize().bold();
            
            //カラー設定
            //var dmg : Number = Number(text);
            //var c : uint = 256 * (1 - dmg / 10000);
            //builder.font(Main.FONT, Main.EMBED).fontColor(color1 | c<<8 | c).fontSize(50);
            builder.font().fontColor(color1).fontSize(_size);
//            builder.textBorder(true, 0x404040, 2, 4);
            //var d : uint = c / 2;
            //builder.textBorder(true, color2 | d<<8 | d, 10, 20);
            builder.textBorder(true, color2, 10, (_size/6));
           
            for (var i:int = 0; i < text.length; i++) {
                _chars.push(builder.build(text.charAt(i)));
            }
        }
        
        private function alignChars():void {
            var i:int, charsWidth:Number = 0;
            
            for (i = 0; i < _chars.length; i++) {
                charsWidth += _chars[i].textWidth;
            }
2            
            if(_chars[0]){
                _chars[0].x = -int(charsWidth / 2);
                _chars[0].y = -_chars[0].textHeight;
            }
            
            for (i = 1; i < _chars.length; i++) {
                _chars[i].x = _chars[i - 1].x + _chars[i - 1].textWidth;
                _chars[i].y = -_chars[i].textHeight;
            }
        }
        
        //モーショントゥイーン
        private function playTween(event:Event = null):void {
            if (event) { removeEventListener(Event.ENTER_FRAME, playTween); }
            
            var char:TextField = _chars[_charIndex++];
            addChild(char);
            
            // 各文字に適用するトゥーイン
            var tween:ITween = BetweenAS3.bezierTo(char, { y: char.y }, { $y: -(char.textHeight * 2) }, 0.3, Sine.easeInOut);
            tween.onComplete = tweenCompleteHandler;
            tween.play();
            
            if (_charIndex < _chars.length) {
                addEventListener(Event.ENTER_FRAME, playTween);
            }
        }
        
        //
        private function tweenCompleteHandler():void {
            _numCompleted++;
        }
        
        private function checkEveryTweenCompleted(event:Event):void {
            if (_numCompleted == _chars.length) {
                removeEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
                BetweenAS3.serial(
                    BetweenAS3.to(this, { alpha: 0 }, _time, Quint.easeInOut),
                    BetweenAS3.removeFromParent(this)
                ).play();
            }
        }
    }
//}


// -----------------------------------------------------------------------------------------

// TextBuilder
/// -----------------------------------------------------------------------------------------
//package {
    import flash.filters.GlowFilter;
    import flash.text.*;
    
    //public
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = true;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number):TextBuilder {
            _posX = x;
            _posY = y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String="Arial", embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            return this;
        }
        
        public function autoCorrect(positionY:Boolean = true):TextBuilder {
            _autoCorrectPositionY = positionY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
           
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}