/**
 * Copyright smirnov48 ( http://wonderfl.net/user/smirnov48 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p4Cb
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TextEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;

    //Based on: Spherical Text Magnification - Jared Tarbell, 2003  |   Flash MX 3D Cheats
    public class Main extends Sprite 
    {
        private var elems:Array = new Array();

        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            for (var gy:int = 0; gy < 10; gy++) {
                for (var gx:int = 0; gx < 10; gx++) {
                    var tf:TextField = new TextField();
                    tf.text = String.fromCharCode(Math.floor(Math.random() * 26 ) + 97);
                    tf.x = 100 + gx * 20;
                    tf.y = 100 + gy * 20;
                    tf.selectable = false;
                    addChild(tf);
                    elems.push( { obj:tf, x: tf.x, y: tf.y } );
                }
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(e:Event):void 
        {
            for (var i:int = 0; i < elems.length; i++) {
                var elem:TextField = elems[i].obj as TextField;
                var dx:Number = mouseX - elems[i].x;
                var dy:Number = mouseY - elems[i].y;
                var d:Number = Math.sqrt(dx * dx + dy * dy);
                if (d >= 100) {
                    elem.x = elems[i].x;
                    elem.y = elems[i].y;
                    elem.scaleX = 1;
                    elem.scaleY = 1;
                } else {
                    var lensDisp:Number = Math.sin(Math.PI * Math.abs(d / 100));
                    elem.x = elems[i].x - 2 * dx * lensDisp / 4;
                    elem.y = elems[i].y - 2 * dy * lensDisp / 4;
                    var lensMag:Number = 2 * (1 - Math.sin(Math.PI * Math.abs(d / 100) / 2));
                    elem.scaleX = 2 * (lensMag + 1);
                    elem.scaleY = 2 * (lensMag + 1);
                }
            }
        }
    }
}