/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p3qY
 */

package {
    
    import caurina.transitions.Tweener;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.DisplayObjectContainer;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    

    public class C2_3 extends Sprite {
        private var _container:Sprite;
        private var _img1:Sprite;
        private var _img2:Sprite;
        private var _img3:Sprite;
        private var _defaultPositions:Array;
        private var _blurY:Number
        
        
        [SWF(frameRate=30, width=800, height=600, backgroundColor="#555555")]
        public function C2_3() {
            init();
            var t:TextField = new TextField()
            
        }
        
        
        private function init():void {
            _container = addChild( new Sprite()) as Sprite;
            _container.x = 400;
            _container.y = 300;
            blurY = 0;
            loadImages();
            addEventListener(Event.COMPLETE, completeHandler);
        }
        
        private function completeHandler(e:Event):void {
            removeEventListener(Event.COMPLETE, completeHandler);
            _defaultPositions = [
                [_img1.x, _img1.y],
                [_img2.x, _img2.y],
                [_img3.x, _img3.y],
            ];
            fadeIn();
        }
        
        private function fadeIn():void{
            Tweener.addTween(_img1, {
                alpha:1, 
                time:.2, 
                transition:"linear" 
            } );
            Tweener.addTween(_img2, { 
                alpha:1, 
                time:.2, 
                delay:.1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img3, { 
                alpha:1, 
                time:.2, 
                delay:.2, 
                transition:"linear",
                onComplete:rotation3d
            } );
        }
        
        private function rotation3d():void {
            Tweener.addTween(_container, {
                rotationY:720,
                time:2, 
                transition:"easeOutCubic",
                onComplete:gainBlur
            } );
        }
        
        private function gainBlur():void {
            Tweener.addTween(this, {
                blurY:80,
                time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(this, {
                blurY:0,
                time:1, 
                delay:1,
                transition:"linear",
                onComplete:zoom
            } );
        }
        
        private function zoom():void { 
            Tweener.addTween(_img1, {
                scaleX:1,
                x:_defaultPositions[0][0],
                y:_defaultPositions[0][1],
                time:.8, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:1,
                x:_defaultPositions[1][0],
                y:_defaultPositions[1][1],
                time:.8, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:1,
                x:_defaultPositions[2][0],
                y:_defaultPositions[2][1],
                time:.8, 
                transition:"easeOutElastic"
            } );         
            Tweener.addTween(_container, { 
                scaleX:1.5,
                rotation: -45,
                time:.8,
                transition:"easeOutElastic"
            } );            
            Tweener.addTween(_container, { 
                scaleX:1.5,
                rotation:30,
                time:.8, 
                delay:.8,
                transition:"easeOutElastic",
                onComplete:scroll
            } ); 
        }
        
        private function scroll():void{
            Tweener.addTween(_img1, {
                scaleY:3,
                y:-60,
                time:1.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img2, { 
                scaleY:3,
                y:60,
                time:1.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img3, { 
                scaleY:3,
                y:-60,
                time:1.5, 
                transition:"easeOutElastic",
                onComplete:reset
            } );
        }
        
        private function reset():void{
            Tweener.addTween(_img1, {
                scaleY:1,
                y:0,
                time:.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img2, { 
                scaleY:1,
                y:0,
                time:.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img3, { 
                scaleY:1,
                y:0,
                time:.5, 
                transition:"easeOutElastic",
                onComplete:compress
            } );
        }
        
        private function compress():void{
            Tweener.addTween(_img1, {
                scaleX:.5,
                x:-220,
                time:1, 
                transition:"easeInOutBack" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:.4,
                x:-134,
                time:1, 
                transition:"easeInOutBack" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:.3,
                x:-85,
                time:1, 
                transition:"easeInOutBack",
                onComplete:charge
            } );
        }
        
        private function charge():void {
            Tweener.addTween(_img1, {
                scaleX:.2,
                time:.5, 
                transition:"easeOutExpo" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:.2,
                x:-186,
                time:.5, 
                transition:"easeOutExpo" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:.2,
                x: -156,
                time:.5, 
                transition:"easeOutExpo",
                onComplete:run
            } );
        }

        private function run():void {
            Tweener.addTween(_img1, {
                scaleX:.5,
                x:350,
                time:.8, 
                transition:"easeOutBounce" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:.4,
                x:436,
                time:.8, 
                transition:"easeOutBounce" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:.3,
                x:485,
                time:.8, 
                transition:"easeOutBounce",
                onComplete:destroy
            } );
        }
        
        private function destroy():void {
            Tweener.addTween(_img1, {
                z:-400,
                rotation:720,
                time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img2, { 
                z:-600,
                rotation:-720,
                time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img3, { 
                z:-800,
                rotation:-720,
                time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img1, {
                x:100,
                y:-340,
                time:.6, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img2, { 
                x:-100,
                y:-100,
                time:.6, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img3, { 
                x:-40,
                y:90,
                time:.6, 
                transition:"easeOutCubic" 
            } );
        }
        
        private function loadImages():void {
            var loader:Loader = Base64ImageLoader.load(Images.IMG_1)
            loader.contentLoaderInfo.addEventListener(
                Event.COMPLETE,
                img1CompleteHander
            )
            function img1CompleteHander(e:Event):void {
                loader.contentLoaderInfo.removeEventListener(
                    Event.COMPLETE,
                    img1CompleteHander
                );
                _img1 = _container.addChild(drawBitmap(loader)) as Sprite;
                _img1.alpha = 0;
                loader = Base64ImageLoader.load(Images.IMG_2);
                loader.contentLoaderInfo.addEventListener(
                    Event.COMPLETE,
                    img2CompleteHander
                );
            }
            function img2CompleteHander(e:Event):void {
                loader.contentLoaderInfo.removeEventListener(
                    Event.COMPLETE, 
                    img2CompleteHander
                );
                _img2 = _container.addChild(drawBitmap(loader)) as Sprite;
                _img2.alpha = 0;
                loader = Base64ImageLoader.load(Images.IMG_3);
                loader.contentLoaderInfo.addEventListener(
                    Event.COMPLETE,
                    img3CompleteHander
                );
            }
            function img3CompleteHander(e:Event):void {
                loader.contentLoaderInfo.removeEventListener(
                    Event.COMPLETE,
                    img3CompleteHander
                );
                _img3 = _container.addChild(drawBitmap(loader)) as Sprite;
                _img3.alpha = 0;
                loader = null;
                setImagePositions();
            }
            function setImagePositions():void {
                var offset:Number = (_img1.width + _img2.width + _img3.width) * .5;
                _img1.x = _img1.width * .5 - offset;
                _img2.x = _img1.width + _img2.width * .5 - offset;
                _img3.x = offset - _img3.width * .5;

                dispatchEvent(new Event(Event.COMPLETE));
            }
            function drawBitmap(loader:Loader):Sprite {
                var bmd:BitmapData = new BitmapData(
                    loader.width,
                    loader.height,
                    true,
                    0
                );
                bmd.draw(loader);
                var img:Bitmap = new Bitmap(bmd)
                img.smoothing = true;
                var container:Sprite = new Sprite();
                container.addChild(img);
                img.x = img.width * -.5;
                img.y = img.height * -.5;
                return container;
            }
        }
        
        public function get blurY():Number { return _blurY; }
        public function set blurY(value:Number):void {
            _blurY = value;
            if (value == 0) {
                filters = null;
                return;
            }
            filters = [new BlurFilter(0,value)];
        }
    }
}

/**
 * Base64化された画像データを表示可能な形式に変換するクラス
 * 
 * 使い方 :
 * var data:String = "Base64化された画像データ";
 * var display:DisplayObject_container = Base64ImageLoader.load(data);
 * if (display != null)
 *     addChild(display);
 */
class Base64ImageLoader{
    import flash.display.Loader;
    import flash.utils.ByteArray;
    import mx.utils.Base64Decoder;
    static public function load(data:String):Loader{
        var byteArray:ByteArray;
        var base64Decoder:Base64Decoder = new Base64Decoder();
        var loader:Loader;
        base64Decoder.decode(data);
        try {
            byteArray = base64Decoder.toByteArray();
            byteArray.position = 0;
        } catch (e:Error) {
            return null;
        }
        loader = new Loader();
        loader.loadBytes(byteArray);
        
        return loader;
    }
}
class Images {
    
    static public const IMG_1:String = "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"
    
    
    static public const IMG_2:String = "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"
    
    static public const IMG_3:String = "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"
}