/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p3EC
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate='60', width='465', height='465')]
    public class Main extends Sprite
    {
        private var _hud :HUD;
        
        public function Main()
        {
            stage.align = StageAlign.TOP;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _hud = new HUD;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        private function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(_hud);
            
            init();
        }
        
        private function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0, 0.75);
            graphics.drawRect(0, 0, 464, 464);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class HUD extends Sprite
{
    private var _healthSprite :Sprite;
    private var _healthOutput :Output;
    private var _scoreSprite :Sprite;
    private var _scoreOutput :Output;
    
    public function HUD()
    {
        _healthSprite = new Sprite();
        _healthOutput = new Output();
        _scoreSprite = new Sprite();
        _scoreOutput = new Output();
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(_healthSprite);
        addChild(_healthOutput);
        addChild(_scoreSprite);
        addChild(_scoreOutput);
        
        init();
    }
    
    private function init() :void
    {
        graphics.clear();
        
        _scoreSprite.graphics.clear();
        _healthSprite.graphics.clear();
        
        _healthOutput.content = "%";
        _healthSprite.graphics.lineStyle(2, 0, 0.625);
        _healthSprite.graphics.drawRoundRect(0, 0, 120, 30, 8, 8)
        _healthOutput.x = _healthSprite.x = int(stage.stageWidth / 8);
        _healthOutput.y = _healthSprite.y = int(stage.stageHeight * 0.8);
        
        _scoreOutput.content = "%";
        _scoreOutput.justify = TextFieldAutoSize.CENTER;
        _scoreSprite.graphics.lineStyle(2, 0, 0.625);
        _scoreSprite.graphics.drawRoundRect(0, 0, _scoreOutput.width, 30, 8, 8);
        _scoreOutput.x = _scoreSprite.x = int(stage.stageWidth / 2);
        _scoreOutput.y = _scoreSprite.y = int(stage.stageHeight * 0.8);
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String = "", $x:Number = 1, $y:Number = 0, $justify:String = TextFieldAutoSize.LEFT, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
        
        autoSize = $justify;
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    public function get justify() :String
    { return autoSize }
    
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
    public function set x_($:Number) :void
    { _x = $; _init() }
    public function set y_($:Number) :void
    { _y = $; _init() }
    public function set justify($:String) :void
    { autoSize = $ }
}