/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p2ob
 */

/*
 * 
 * 印刷機能テスト
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.SimpleButton;
    import flash.display.StageScaleMode;
    //印刷機能のためのimport
    import flash.printing.PrintJob;
    import flash.geom.Rectangle;
    import flash.text.TextFormat;
    import flash.printing.PrintJobOptions;
    
        
    [SWF(backgroundColor="0xFFFFFF")]
    public class Main extends Sprite {
        
        private var page0:Sprite = new Sprite();
        private var page1:Sprite = new Sprite();
           
        private var loadFiles_array:Array;
        private var MultiLoader:MultiLoaderClass;
        private var baseURL:String = "";
        private var dataxmlURL:String = "dscn0137b.jpg";
        
        //この関数がまず実行される。
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = "TL";
            if(isMztmjp()){
                MultiLoader = new MultiLoaderClass();
            }else{
                baseURL = "http://mztm.jp/wonderfl/";
                MultiLoader = new MultiLoaderClass("http://mztm.jp/crossdomain.xml");
            }
            loadFiles_array = MultiLoader.setLoad([baseURL+dataxmlURL], onComp);
        }
        private function isMztmjp():Boolean{
            var _str:String = stage.loaderInfo.url;
            return (_str.substr(0,5) == "file:" || _str.indexOf("mztm.jp") > -1);
        
        }
        private function onComp(e:Array):void {
            //page0、page1はaddChildしていないことに注意    
            //*****文字見本部分ページ*****
            makeMojimihon(page0);
            
            //*****目盛図形ページ*****
            makeMemori(page1);
            
            //*****preview*****
            addChild(makePreview());
        }
        
        //*****文字見本部分ページ*****
        private function makeMojimihon(page0:Sprite):void {
            var i:uint;
            var txt:String;
            var size_array:Array = [3, 4, 5, 6, 7, 8, 9, 10, 12, 16, 18, 21, 24, 36, 48, 60];
            var size:int;
            for (i = 0; i < size_array.length; i++) {
                size = size_array[i];
                txt = "Size:"+size+",水玉製作所（みずたまセイサクショ）,ghijklmnopqy,012345";
                page0.addChild(Create.newTextField([0, page0.height, 590, size+5], [["defaultTextFormat", new TextFormat("_sans", size)], ["text", txt+",font:_sans"]]));
                page0.addChild(Create.newTextField([0, page0.height, 590, size+5], [["defaultTextFormat", new TextFormat("_serif", size)], ["text", txt+",font:_serif"]]));
            }
        }
        
        //*****目盛図形ページ*****
        private function makeMemori(page1:Sprite):void {
            var txt:String;
            //目盛
            for (var k:uint = 0; k < 10; k++) {
                for (var j:uint = 0; j < 10; j++) {
                    for (var i:uint = 0; i < 10; i++) {
                        var lineLength:int = 5;
                        if (i%10 == 0) {
                            lineLength = 100;
                        }else if(i%5 == 0) {
                            lineLength = 10;
                        }
                        page1.addChild(Create.newShape([10 * i+j*100, k*100], null, [["beginFill", [0x999999]], ["drawRect", [0, 0, 1, lineLength ]]]) );
                        page1.addChild(Create.newShape([j*100, 10 * i+k*100], null, [["beginFill", [0x999999]], ["drawRect", [0, 0,  lineLength, 1]]]) );
                    }
                }
            }
            page1.x = 50;
            page1.y = 200;
            
            //目盛の解説
            txt = "本紙の目盛は10px毎にうってあり、升目は100pxの大きさです。\n";
            txt += "72dpi = 72pxで1インチ（2.54cm）になります。\n";
            txt += "A4サイズ210mm*297mmをpxにすると595px*842x\n";
            txt += "A3サイズ420mm*297mmをpxにすると1190px*842x\n";
            txt += "これらは用紙サイズなので、一般向けのプリンターの場合、印刷可能範囲を考慮する必要があります。\n";
            txt += "テストしたレーザープリンターではA4の場合550px*800px程度が印刷可能範囲でした。\n";
            txt += "インクジェットプリンターの場合縦方向の余白が大きいのでさらに少なめにしたほうが良いかもしれません。";
            page1.addChild(Create.newTextField([30, 30, 500, 150, txt], [["wordWrap", true], ["background", true]]));
            
            //beginFillを使って書いた図形たち
            page1.addChild(Create.newSprite([120,500],[["rotation",24]],[["beginFill",[0xC9D787,1]],["drawRoundRect",[10,10,200,200,100]]]));
            page1.addChild(Create.newShape([110, 620], [["rotation",-24]], [["beginFill", [0x000000, 1]], ["drawRect", [0, 0, 100, 100]]]));
            page1.addChild(Create.newSprite([450, 550], null, [["beginFill", [0xFF0000, 1]], ["drawCircle", [0, 0, 20]]]));
            page1.addChild(Create.newSprite([400, 600], null, [["beginFill", [0x00FF00, 1]], ["drawCircle", [0, 0, 40]]]));
            page1.addChild(Create.newSprite([350, 700], null, [["beginFill", [0x0000FF, 1]], ["drawCircle", [0, 0, 60]]]));
            page1.addChild(Create.newTextField([20, 750, 500, 20, "beginFillを使って書いた図形たち","0xFF0000"]));
            
            //bitmapにして貼り付け。
            //文字や図形をBitmap化+loadした写真、これらをscaleX=scaleY=0.3にして貼り付けた。
            //72*(1/0.3)=239.76、240dpi相当
            var bmd:BitmapData = new BitmapData(595*3,842);
            bmd.draw(page0);
            bmd.draw(page1,new Matrix(1,0,0,1,595,0));
            bmd.draw(loadFiles_array[0],new Matrix(1,0,0,1,595*2,0));
            var bm:Bitmap = new Bitmap(bmd);
            bm.x = 20;
            bm.y = 220;
            bm.scaleX = bm.scaleY = 0.3;
            page1.addChild(bm);
            page1.addChild(Create.newTextField([20, 440, 500, 50, "文字や図形をBitmap化+loadした写真、これらをscaleX=scaleY=0.3にして貼り付けた。\n72*(1/0.3)=239.76、240dpi相当","0xFF0000"]));
            
        }
        
        //*****preview*****
        private function makePreview():Sprite {
            var preview:Sprite = Create.newSprite(null, null, [["beginFill", [0xEEEEEE]], ["drawRect", [0, 0, stage.stageWidth, 297+40]]]);
            preview.addChild(Create.newTextField([15,4,300,20,"Preview"]));
            //文字見本部分
            var bitMapData0:BitmapData = new BitmapData(210,297);
            bitMapData0.draw(page0,new Matrix(0.3527,0,0,0.3527,15*0.3527,15*0.3527));
            var bitMap0:Bitmap = new Bitmap(bitMapData0);
            bitMap0.x = 15;
            bitMap0.y = 25;
            preview.addChild(bitMap0);
            
            //目盛と図形
            var bitMapData1:BitmapData = new BitmapData(210,297);
            bitMapData1.draw(page1,new Matrix(0.3527,0,0,0.3527,0,0));
            var bitMap1:Bitmap = new Bitmap(bitMapData1);
            bitMap1.x = 240;
            bitMap1.y = 25;
            preview.addChild(bitMap1);
            
            //印刷ボタン。マウスクリックでプリントする
            var sb:SimpleButton = Create.newSimpleButton([(stage.stageWidth - 200) / 2, 400, 200, 24, "印刷する"]);
            preview.addChild(sb);
            sb.addEventListener(MouseEvent.MOUSE_DOWN, MOUSE_DOWN);
            return preview;
        }
        
        private function MOUSE_DOWN(e:MouseEvent):void {
            var pj:PrintJob = new PrintJob();
            var _isAdded:Boolean;
            if (pj.start()) {
                pj.addPage(page0, new Rectangle(-15, -15, 595,842));
                pj.addPage(page1, new Rectangle(0, 0, 595,842));
            }
            pj.send();
        }
    }
}


import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.SimpleButton;
class Create{
  public static var defaultTextFormat:TextFormat = new TextFormat();
  
    public static function newSimpleButton(x_y_w_h_txt:Array = null,property:Array=null,graphics:Array=null):SimpleButton{
            var upState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xCCCCCC,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
            upState.addChild(newShape([2,2],null,[["beginFill",[0xE5E5E5,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
            var overState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xBBBBBB,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
            overState.addChild(newShape([2,2],null,[["beginFill",[0xEEEEEE,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
            var downState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xAAAAAA,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
            downState.addChild(newShape([2,2],null,[["beginFill",[0xDDDDDD,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
            var hitTestState:Shape = newShape([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
            if(x_y_w_h_txt[4]){
                upState.addChild(newTextField([0,2,x_y_w_h_txt[2],x_y_w_h_txt[3]-2],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
                overState.addChild(newTextField([0,2,x_y_w_h_txt[2],x_y_w_h_txt[3]-2],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
                downState.addChild(newTextField([0,3,x_y_w_h_txt[2],x_y_w_h_txt[3]-3],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
            }
             var sb:SimpleButton = new SimpleButton(upState,overState,downState,hitTestState);
        
        return sb;
    }
  
  public static function newShape(x_y_w_h_sh:Array = null,property:Array=null,graphics:Array=null):Shape{
    var i:int;
    var sh:Shape;
    if(x_y_w_h_sh && x_y_w_h_sh[4]){
      sh = x_y_w_h_sh[4];
    }else{
      sh = new Shape();
    }
    if(x_y_w_h_sh){
      if (x_y_w_h_sh[0]) { sh.x = x_y_w_h_sh[0] };
      if (x_y_w_h_sh[1]) { sh.y = x_y_w_h_sh[1] };
    }
    if(property){
      for (i = 0; i < property.length; i++) {
        if(property[i] && property[i].length > 1){
          sh[property[i][0]] = property[i][1];
        }
      }
    }
    if(graphics){
      for (i = 0; i < graphics.length; i++) {
        if(graphics[i] && graphics[i].length > 1){
          sh.graphics[graphics[i][0]].apply(null, graphics[i][1]);
        }
      }
      
    }
    if(x_y_w_h_sh){
      if (x_y_w_h_sh[2]) { sh.width = x_y_w_h_sh[2] };
      if (x_y_w_h_sh[3]) { sh.height = x_y_w_h_sh[3] };
    }
    return sh;
  }
  public static function newSprite(x_y_w_h_sp:Array = null,property:Array=null,graphics:Array=null,addChild:DisplayObject = null):Sprite{
    var i:int;
    var sp:Sprite;
    if(x_y_w_h_sp && x_y_w_h_sp[4]){
      sp = x_y_w_h_sp[4];
    }else{
      sp = new Sprite();
    }
    if(x_y_w_h_sp){
      if (x_y_w_h_sp[0]) { sp.x = x_y_w_h_sp[0] };
      if (x_y_w_h_sp[1]) { sp.y = x_y_w_h_sp[1] };
    }
    if(property){
      for (i = 0; i < property.length; i++) {
        if(property[i] && property[i].length > 1){
          sp[property[i][0]] = property[i][1];
        }
      }
    }
    if(graphics){
      for (i = 0; i < graphics.length; i++) {
        if(graphics[i] && graphics[i].length > 1){
          sp.graphics[graphics[i][0]].apply(null, graphics[i][1]);
        }
      }
      
    }
    if(addChild){
      sp.addChild(addChild);
    }
    if(x_y_w_h_sp){
      if (x_y_w_h_sp[2]) { sp.width = x_y_w_h_sp[2] };
      if (x_y_w_h_sp[3]) { sp.height = x_y_w_h_sp[3] };
    }
    return sp;
  }

  public static function newTextField(x_y_w_h_txt_color_alpha:Array = null,property:Array=null,method:Array=null):TextField{
    var i:int;
    var ta:TextField = new TextField();
    ta.defaultTextFormat = defaultTextFormat;
    if(x_y_w_h_txt_color_alpha){
      if (x_y_w_h_txt_color_alpha[0]) { ta.x = x_y_w_h_txt_color_alpha[0] };
      if (x_y_w_h_txt_color_alpha[1]) { ta.y = x_y_w_h_txt_color_alpha[1] };
      if (x_y_w_h_txt_color_alpha[2]) { ta.width = x_y_w_h_txt_color_alpha[2] };
      if (x_y_w_h_txt_color_alpha[3]) { ta.height = x_y_w_h_txt_color_alpha[3] };
      if (x_y_w_h_txt_color_alpha[4]) { ta.text = x_y_w_h_txt_color_alpha[4] };
      if (x_y_w_h_txt_color_alpha[5]) { ta.textColor = x_y_w_h_txt_color_alpha[5] };
      if (x_y_w_h_txt_color_alpha[6]) { ta.alpha = x_y_w_h_txt_color_alpha[6] };
    }
    if(property){
      for (i = 0; i < property.length; i++) {
        if(property[i] && property[i].length > 1){
          ta[property[i][0]] = property[i][1];
        }
      }
    }
    if(method){
      for (i = 0; i < method.length; i++) {
        if(method[i] && method[i].length > 1){
          ta[i].apply(null, method[i][1]);
        }
      }
    }
    return ta;
  }
}


import flash.display.Sprite;
class MultiLoaderClass extends Sprite{
    import flash.system.Security;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.display.Loader;
    //import flash.display.LoaderInfo;
    
    private var onComplete:Function = function(arg:Array=null):void{};
    //private var onOpen:Function = function():void{};
    private var loadNum:int;
    private var loadCompNum:int;
    private var error_array:Array = new Array();
    private var URLs_array:Array = new Array();
    private var _uniqueParam:String = "";
    
    public function set uniqueParam(uStr:String):void {
        if (uStr) {
            if (uStr.substr(0,2) == "?=") {
                _uniqueParam = uStr;
            }else {
                _uniqueParam = "?=" + uStr;
            }
        }else {
            _uniqueParam = "";
        }
    }
    public function get uniqueParam():String {
        return _uniqueParam;
    }
    
    public function MultiLoaderClass(_str:String = null,uStr:String = null){
        if(_str){
            Security.loadPolicyFile(_str);
        }
        uniqueParam = uStr;
    }
    
    public function setLoad(__item_array:Array = null, _onComp:Function = null):Array {
        loadCompNum = loadNum = 0;
        if(_onComp != null){
            onComplete = _onComp;
        }
        if (__item_array.length == 0) {
            loadNum ++;
            onComplete();
        }
        
        URLs_array = __item_array.concat();
        error_array = new Array();
        //onOpen = _onOpen;
        var _array:Array = new Array();
        var _length:int = __item_array.length;
        for (var i:int = 0; i < _length; i++) {
            error_array[i] = false;
            if (__item_array[i] == null) { continue };
            var _extension:String = __item_array[i].substr(-4,4).toLowerCase();//拡張子を取り出す。
            if (_extension == ".xml" || _extension == "html") {
                loadNum ++;
                _array[i] = textFromURL(__item_array[i] + uniqueParam);
            }else if(_extension == ".jpg" || _extension == ".gif" || _extension == ".png" || _extension == ".swf"){
                loadNum ++;
                _array[i] = imgFromURL(__item_array[i] + uniqueParam);
            }else if(_extension == ".bin"){
                loadNum ++;
                __item_array[i] = __item_array[i].substr(0, __item_array[i].length - 4);
                _array[i] = binaryFromURL(__item_array[i] + uniqueParam);
            }else{
                //_array[i] = null;
            }
        }
        
        return _array;
    }
    private function binaryFromURL(__url:String):URLLoader{
        var _loader:URLLoader = new URLLoader();
        _loader.dataFormat = URLLoaderDataFormat.BINARY;
        _loader.addEventListener(Event.COMPLETE,completeHandler);
        _loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        _loader.load(new URLRequest(__url));
        return _loader;
    }
    
    private function textFromURL(__url:String):URLLoader{
        var _loader:URLLoader = new URLLoader();
        _loader.addEventListener(Event.COMPLETE,completeHandler);
        _loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        //_loader.addEventListener(Event.OPEN,openHandler);
        _loader.load(new URLRequest(__url));
        return _loader;
    }
    
    private function imgFromURL(__url:String):Loader{
        var _loader:Loader = new Loader();
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        _loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        //_loader.contentLoaderInfo.addEventListener(Event.OPEN,openHandler);
        _loader.load(new URLRequest(__url));
        return _loader;
    }
    
    private function completeHandler(event:Event = null):void {
        loadCompNum ++;
        if(loadCompNum == loadNum){
            onComplete(error_array);
        }
    }
    /*
    private function openHandler (event:Event):void {
        if(Math.random()>0.95){
            trace ("読み込みを開始した");
            //event.currentTarget.contentLoaderInfo.close();
            var str:String = event.currentTarget.toString().substr(8);
            if(str == "LoaderInfo]"){
                //event.currentTarget.contentLoaderInfo.close();
                //event.target.contentLoaderInfo.close();
                //event.currentTarget.close();
                //event.target.close();
            }else if(str == "URLLoader]"){
                event.currentTarget.close();
                completeHandler();
            }
            
            //completeHandler();
            //onOpen();
        }
    }
    */
    private function ioErrorHandler(event:IOErrorEvent):void {
        //event.text = "Error #2035: URL が見つかりません。 URL: file:///~~~~~";
        //event.text = "Error #2036: 読み込みが未完了です。 URL: http://~~~~~";
        //から、URLのみを取り出す。
        //trace(String(event.text).substr(String(event.text).indexOf(" URL: ")+6),"*****");
        for (var i:int = 0; i < URLs_array.length; i++) {
            var _str:String = String(event.text).substr(String(event.text).indexOf(" URL: ")+6).substr(-URLs_array[i].length);
            if(URLs_array[i] == _str){
                error_array[i] = true;
            }
        }
        completeHandler();
    }
}