/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p1uX
 */

// forked from siouxcitizen's PV3DのTriangleMesh3Dの練習04　フラットシェーディング練習
//PV3DのTriangleMesh3Dの練習05　オベリスク型の作成
//
package
{
    import flash.events.Event;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.math.NumberUV;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.view.BasicView;

    [SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
    public class TriangleMesh3DExample extends BasicView
    {
        private var mesh : TriangleMesh3D;
        private var light:PointLight3D

        public function TriangleMesh3DExample() {
            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;

            //マテリアル設定
            var material : FlatShadeMaterial = new FlatShadeMaterial(light, 0xffff99, 0xff9900);
            material.doubleSided = false;

            //TriangleMesh3Dオブジェクト生成
            mesh = new TriangleMesh3D( material, [], [], null ); //配列部分は後で設定
            scene.addChild(mesh);

            //オベリスク型の頂点定義
            //オベリスク型てっぺんのピラミッド部分頂点
            var v0 : Vertex3D = new Vertex3D(-80, -80, 80); //ピラミッド部分の土台となる4頂点の1つ
            var v1 : Vertex3D = new Vertex3D(80, -80, 80); //ピラミッド部分の土台となる4頂点の1つ
            var v2 : Vertex3D = new Vertex3D(0, 80, 0); //ピラミッド部分のてっぺん部分の頂点
            var v3 : Vertex3D = new Vertex3D(-80, -80, -80); //ピラミッド部分の土台となる4頂点の1つ
            var v4 : Vertex3D = new Vertex3D(80, -80, -80); //ピラミッド部分の土台となる4頂点の1つ

            //オベリスク型の柱部分頂点
            var v5 : Vertex3D = new Vertex3D(-80, -500, 80); //柱部分の土台となる4頂点の1つ
            var v6 : Vertex3D = new Vertex3D(80, -500, 80); //柱部分の土台となる4頂点の1つ
            var v7 : Vertex3D = new Vertex3D(-80, -500, -80); //柱部分の土台となる4頂点の1つ
            var v8 : Vertex3D = new Vertex3D(80, -500, -80); //柱部分の土台となる4頂点の1つ

            mesh.geometry.vertices.push( v0 );
            mesh.geometry.vertices.push( v1 );
            mesh.geometry.vertices.push( v2 );
            mesh.geometry.vertices.push( v3 );
            mesh.geometry.vertices.push( v4 );
            mesh.geometry.vertices.push( v5 );
            mesh.geometry.vertices.push( v6 );
            mesh.geometry.vertices.push( v7 );
            mesh.geometry.vertices.push( v8 );

            //面定義
            var uvA : NumberUV = new NumberUV( 0, 0 );
            var uvC : NumberUV = new NumberUV( 1, 0 );
            var uvB : NumberUV = new NumberUV( 0, 1 );

            //ピラミッド部分作成　(時計まわりで指定された三角形が、マテリアル設定される表面となる？)
            //前面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v2,v1,v0), null, new Array(uvA,uvC,uvB) ));
            //後面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v2,v3,v4), null, new Array(uvA,uvC,uvB) ));
            //左面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v2,v0,v3), null, new Array(uvA,uvC,uvB) ));
            //右面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v2,v4,v1), null, new Array(uvA,uvC,uvB) ));

            //柱部分作成　(三角形の3Dオブジェクト2枚で、四角形の3Dオブジェクトを表現)
            //前面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v1,v5,v0), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v1,v6,v5), null, new Array(uvA,uvC,uvB) ));
            //後面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v3,v8,v4), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v3,v7,v8), null, new Array(uvA,uvC,uvB) ));
            //左面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v0,v7,v3), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v0,v5,v7), null, new Array(uvA,uvC,uvB) ));
            //右面
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v4,v6,v1), null, new Array(uvA,uvC,uvB) ));
            mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v4,v8,v6), null, new Array(uvA,uvC,uvB) ));

            mesh.geometry.ready = true;

            startRendering();
        }

        override protected function onRenderTick(event:Event=null):void {
            mesh.rotationX=viewport.mouseX;
            mesh.rotationY=viewport.mouseY;
            super.onRenderTick(event);
        }
    }
}