/**
 * Copyright Nowloading_ ( http://wonderfl.net/user/Nowloading_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p15s
 */

package {
    import flash.display.DisplayObject;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import flash.events.*;
    import flash.ui.Keyboard;

    [SWF(backgroundColor = 0x000000)]
    public class mf extends BasicView {
        //Field格納用オブジェクト
        private var field:DisplayObject3D;
        
        //地形参照用配列
        //0=green,1=brown, 2=blue
        private var uField:Array = [[0,0,0,1,1],
                                    [0,0,1,2,2],
                                    [0,1,2,2,2],
                                   ];
        private var dField:Array = [[1,1,1,1,1],
                                    [1,1,1,1,2],
                                    [1,1,1,2,2],
                                   ];
        
        //Cube用material,primitive
        private var gr:ColorMaterial = new ColorMaterial(0x60ff60);
        private var br:ColorMaterial = new ColorMaterial(0xd0a080);
        private var bl:ColorMaterial = new ColorMaterial(0xd0ddff);
        
        private var g:MaterialsList = new MaterialsList( { all:gr } );
        private var l:MaterialsList = new MaterialsList( { all:br } );
        private var b:MaterialsList = new MaterialsList( { all:bl } );
        private var materials:Array = [g,l,b];
        private var ucube:Cube;
        private var dcube:Cube;
        
        //spher
        private var material:WireframeMaterial= new WireframeMaterial(0xff0000,2);
        //primitives(for Sphere)
        private var sphere:Sphere = new Sphere(material,50);        
        //radiun
        private var rad:int = 0;     

        public function mf() {
            init();
        }
        private function init():void{
            field = new DisplayObject3D;
            scene.addChild(field);
            
            //materialslistの作成
            for(var i:int = 0; i<3; i++){
                for(var j:int = 0; j<5; j++){
                    ucube = new Cube(materials[uField[i][j]],100,100,30);
                    dcube = new Cube(materials[dField[i][j]],100,100,70);
                    
                    ucube.x = dcube.x = -120 + (120*i);
                    ucube.z = dcube.z = -240 + (120*j);
                    ucube.y = 50;
                    field.addChild(ucube,"UCx_"+i+"z_"+j);
                    field.addChild(dcube,"DCx_"+i+"z_"+j);
                }
            }
            
            //Sphereの作成
            scene.addChild(sphere);
            sphere.y = 130;
            material.doubleSided = true;
            
            camera.y = 500;
            camera.z = -600;
            startRendering();
            addEventListener(Event.ENTER_FRAME,oEF);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        private function oEF(e:Event):void{
            camera.x = 600*Math.sin(rad*Math.PI/180);
            camera.z = -600*Math.cos(rad*Math.PI/180);
            rad += 1;
        }
        private function onKeyDown(event:KeyboardEvent):void{       
            if( event.keyCode == Keyboard.LEFT ) {
                if(sphere.x > -120){
                    sphere.x -= 120;
                }
            } else if ( event.keyCode == Keyboard.RIGHT ) {
                if(sphere.x < 120){
                    sphere.x += 120;
                }
            } else if ( event.keyCode == Keyboard.UP ) {
                if(sphere.z < 240){
                    sphere.z += 120;
                }
            } else if ( event.keyCode == Keyboard.DOWN ) {
                if(sphere.z > -240){
                    sphere.z -= 120;
                }
            }
        }
    }
}