/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p127
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    public class FlashTest extends Sprite {
    		private var index:int = 0;
    		private var stageXs:Array = [];
    		private var stageYs:Array = [];
    		private var wheel:Wheel = new Wheel();
    		// マウスを右方向に回すとホイールが右回転、逆は左回転します。
        public function FlashTest() {
            // write as3 code here..
            init();
        }
        
        private function init():void{
        	    stageXs = [stage.mouseX, stage.mouseX];
        	    stageYs = [stage.mouseY, stage.mouseY];
        	    addChild(wheel);
        	    wheel.x = stage.stageWidth/2;
        	    wheel.y = stage.stageHeight/2;
        	    addEventListener(Event.ENTER_FRAME,onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
        }
        private function onEnterFrame(e:Event):void{
        		wheel.update();
        }
        private function onMove(e:MouseEvent):void{
        		var lastIndex:int = index;
        		var lastLastIndex:int = 1 - index;
        		index = lastLastIndex;
        		var rotZ:Number = 
        			(stageXs[lastIndex] - stageXs[lastLastIndex]) * (stage.mouseY - stageYs[lastIndex]) -
        			(stageYs[lastIndex] - stageYs[lastLastIndex]) * (stage.mouseX - stageXs[lastIndex]);
        		stageXs[index] = stage.mouseX;
        		stageYs[index] = stage.mouseY;
        		
        		wheel.rotAccel(rotZ*0.005);
        }
    }
}

import flash.display.Sprite;
class Wheel extends Sprite{
	private var num:int = 10;
	private var radius:Number = 100;
	private var rotSpeed:Number = 0;
	public function Wheel(){
		this.graphics.lineStyle(2);
		for( var i:int = 0; i < num; i++ ){
			this.graphics.moveTo(0,0);
			this.graphics.lineTo(radius * Math.cos((2*i/num)*Math.PI), radius * Math.sin((2*i/num)*Math.PI));
		}
		this.graphics.drawCircle(0, 0, radius);
	}
	public function rotAccel(power:Number):void{
		rotSpeed += power;
	}
	public function update():void{
		rotSpeed *= 0.9;
		this.rotation += rotSpeed;
	}
}
