/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p0Uy
 */

// forked from kotobuki's Funnel Server経由でArduinoボードのLEDを点滅させる
// LEDを点滅させるサンプル
// 
// 参照
// http://arduino.cc/en/Tutorial/Blink
// http://funnel.cc/Software/ActionScript3
// http://funnel.cc/reference/actionscript3/

package {
    import flash.display.Sprite;
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;
    
    public class FlashTest extends Sprite {
        private var arduino:Arduino;
        
        public function FlashTest() {
            var config:Configuration = Arduino.FIRMATA;
            config.setDigitalPinMode(14, OUT);
            config.setDigitalPinMode(15, OUT);
            config.setDigitalPinMode(16, OUT);
            config.setDigitalPinMode(17, OUT);
            config.setDigitalPinMode(18, OUT);
            config.setDigitalPinMode(19, OUT);
            arduino = new Arduino(config);

            // Arduinoボードの状態を表示するGUIを生成して表示
            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            arduino.gui = gui;

            // LEDに接続されているA0/D14を1000ミリ秒（1秒）間隔で点滅
            var led0:LED = new LED(arduino.digitalPin(14));
            var led1:LED = new LED(arduino.digitalPin(15));
            var led2:LED = new LED(arduino.digitalPin(16));
            var led3:LED = new LED(arduino.digitalPin(17));
            var led4:LED = new LED(arduino.digitalPin(18));
            var led5:LED = new LED(arduino.digitalPin(19));
            led0.blink(1000, 0);
            led1.blink(1000, 0);
            led2.blink(1000, 0);
            led3.blink(1000, 0);
            led4.blink(1000, 0);
            led5.blink(1000, 0);
        }
    }
}