/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ozGB
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var charaChip:BitmapData;
		private const C_WIDTH:int = 32;
		private const C_HEIGHT:int = 48;
 
		private var frame:int = 0;
		private var cx:int = 0;
		private var chara:BitmapData;
 
		public function Main()
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/3/33/3384/3384200b2dc435c82a6c311375c2e26b81bc80e2"), new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void
		{
			var loader:Loader = event.currentTarget.loader;
			charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
			charaChip.draw(loader);
			charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0x78c380, 0x0, 0xFFFFFF);
 
			chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
			addChild(new Bitmap(chara));
 
			var bitmap:Bitmap = new Bitmap(chara);
			bitmap.scaleX = bitmap.scaleY = 2;
			bitmap.x = 50;
			addChild(bitmap);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			if (frame++ % 5 == 0)
			{
				chara.copyPixels(charaChip, new Rectangle(C_WIDTH * (cx + 6), C_HEIGHT * 0, C_WIDTH, C_HEIGHT), new Point());
				cx = 2 - cx;
			}
		}
	}
}
