/**
 * Copyright nyamogera ( http://wonderfl.net/user/nyamogera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oy77
 */

package {

    //    初めての朝わん。
    //    案外進まなかったのでここで終わり
        
    import flash.display.Sprite;
    import flash.events.MouseEvent;  
    import flash.display.Shape;   
    public class FlashTest extends Sprite {
         [SWF(width="465", height="465", backgroundColor="0xffffff", framerate="20")]
         
        private var _tmpLine:Line;        //    一時保管ライン
        
        private var _tmpBuffer:Shape;     //    描画ライン一時保存用
        private var _backBuffer:Shape;    //    描画ライン（もう動かさないよう）
        
        private var _lines:Vector.<Line>; //    保管ライン（未使用）
        
        
        private var _debug:DebugTest;
        
        private var _trace:DebugTest;
        private var _traceStr:String;
        
        public function FlashTest() {
            
            // write as3 code here..           
            
            createBackGround() 
            addChild( new AsaWon( 1, 0x000000));
            
            //    トレース用
            _trace= new DebugTest( "trace");
            _trace.x = 350;
            addChild( _trace);
 
            //    デバッグ用（残らない）
            _debug = new DebugTest( "mouse");
            _debug.x = 300;
            addChild( _debug );
             
             _lines = new Vector.<Line>;    //    保管用のライン           
             
             addChild( _tmpBuffer = new Shape() );     //  保存用のバッファと
             addChild(  _backBuffer = new Shape() );   //  表示用のバッファ
             
            //    イベント取り付ける
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }

        //    トレースを追加する
        private function addTrace(str:String) : void
        {
            _traceStr = _traceStr + "\n" + str;
            _trace.add("trace", _traceStr );
        }
        
        //    マウスが移動したとき
        private function mouseMoveHandler(event:MouseEvent) : void
        {
            _debug.add("mouse", "mouse move ->" + _tmpLine);
            _debug.add("pos x:", event.stageX.toString() + ", y:"+ event.stageY.toString() );
            
            //    マウスが押されているときはtmpLineが作られている
            //    = tmpLineが無いときはマウスが押されていない
            if( !_tmpLine ) return ;    //    のでリターンする
            
            _tmpLine.p1.x = mouseX;
            _tmpLine.p1.y = mouseY;
            
            _tmpBuffer.graphics.clear();
            _tmpLine.draw(_tmpBuffer, 0xff0000);
            
        }
        
        //    マウスが押されたとき
        private function mouseDownHandler(event:MouseEvent) : void
        {
            _debug.add("mouse", "mouse down");
            _debug.add("pos put x:", event.stageX.toString() + ", y:"+ event.stageY.toString() );
            
            _tmpLine = new Line();
            _tmpLine.p0.x = mouseX;
            _tmpLine.p0.y = mouseY;
        }
        
        //    マウスがUP！
        private function mouseUpHandler(event:MouseEvent) : void
        {
            _tmpLine.p1.x = mouseX;
            _tmpLine.p1.y = mouseY;
 
            _debug.add("mouse", "mouse up");
            
            _tmpBuffer.graphics.clear();
 
            if( _tmpLine.isDot() )
            {
                _tmpLine = null;
                 return ;
            }
            
            _tmpLine.draw(_backBuffer, 0x000000);    //    バッファに書き込む
            
            _lines.push(_tmpLine);                    //    ラインを保管する
            
            addTrace("line" + _lines.length + 
                    " line1:x=" + _tmpLine.p0.x + ",y=" + _tmpLine.p0.y +
                    " line2:x=" + _tmpLine.p1.x + ",y=" + _tmpLine.p1.y);
            
            _tmpLine = null;    //    操作できなくする
            
            if( _lines.length == 10 )
            {
                crossCheck();
            }
        }
        
        //    背景表示用
        private function createBackGround(color:uint=0xffffff):void
	{
            
	    var sprite:Sprite = new Sprite();
	    addChild( sprite );
	    var shape:Shape = new Shape();
            shape.graphics.beginFill(color, 1);
	    shape.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			
	    sprite.addChild(shape);
			
	}

        private function crossCheck() : void
        {
            var length:int = _lines.length;
            for(var i:int = 0; i < length -1; i ++ ) 
            {
                for( var j:int = i; j < length; j++)
                {
                    if( Line. intersection(_lines[i], _lines[j]))
                    {
                        addTrace( i.toString() + "x" + j.toString() + " is cross");
                    }
                    else
                    {
                        addTrace( i.toString() + "x" + j.toString() + " is not cross");
                    }
                    
                }
            }
        }
    }
}


//    ライン
import flash.display.Graphics;
import flash.geom.Point;
import flash.display.Shape;

internal class Line
{
	public var p0:Point = new Point();
	public var p1:Point = new Point();

        public function draw( shape:Shape, color:uint ) : void
        {
            var g:Graphics = shape.graphics;
            g.lineStyle(1,color,1.0);
            g.moveTo(p0.x,p0.y);
            g.lineTo(p1.x,p1.y);
        }
        //    ここで勉強中
        //    http://www5d.biglobe.ne.jp/~tomoya03/shtml/algorithm/Intersection.htm
        public static function intersection(line0:Line, line1:Line) : Boolean
        {
            if(intersectFunc(line0, line1) && intersectFunc(line1, line0))
            {
                return true;
            }
        
            return false;
        }
        private static function intersectFunc(line0:Line, line1:Line) : Boolean
        {
            if( 
            ((line0.p0.x - line0.p1.x) * (line1.p0.y - line0.p0.y) + 
            (line0.p0.y - line0.p1.y) * (line0.p0.x - line1.p0.x)) * 
            ((line0.p0.x - line0.p1.x) * (line1.p1.y - line0.p0.y) + 
            (line0.p0.y - line0.p1.y) * (line0.p0.x - line1.p1.x)) < 0)
            {
                return true;
            }
            return false;
        }
        
        public function isDot() : Boolean
        {
            return (( p0.x == p1.x) && (p0.y == p1.y));
        }
}

//    あさわん
import flash.text.TextField;
import flash.display.Sprite;
internal class AsaWon extends Sprite
{
    private var textField:TextField;
    
    function AsaWon(day:int, color:uint) 
    {
       textField = new TextField();
       textField.text = "朝 （U＾ω＾） <わん " + day + "日め";
       textField.textColor = color;
       textField.width = textField.textWidth + 4;
       textField.height = textField.textHeight + 4;
       
       addChild( textField );
    }
        
        
}

//    デバッグ用のコード
//    http://wonderfl.net/code/c4bf78ae758a71c3a7bdcdc26fcf79383b2c2f7a/edit
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.utils.Dictionary;

class DebugTest extends Sprite
{
    private var barField:TextField;
    private var openField:TextField;
    private var debugField:TextField;
    private var dictionary:Dictionary;
		
    public function DebugTest(title:String) 
    {
	dictionary = new Dictionary(true);
	
	barField = new TextField();
	openField = new TextField();
	debugField = new TextField();
			
	barField.text = title;
	openField.text = "▲";	//	上三角
		
	barField.background = true;
	barField.backgroundColor = 0x00000;
	barField.textColor = 0xffffff;
	barField.x = 20;
	barField.height = 20;
	barField.addEventListener( MouseEvent.MOUSE_DOWN, startMove);
	barField.addEventListener( MouseEvent.MOUSE_UP, endMove);
	barField.border = true;
	barField.selectable= false;
	
	openField.background = true;
	openField.backgroundColor = 0x00000;
	openField.textColor = 0xffffff;
	openField.height = 20;
	openField.width = 20;
	openField.selectable= false;
	openField.border = true;
        openField.mouseEnabled = true;
	openField.addEventListener( MouseEvent.CLICK, switchVisible);

	debugField.border = true;
	debugField.background = true;		
	debugField.y = 20;
			
	addChild( barField );
	addChild( openField );
	addChild( debugField );
			
	update();
    }
		
    //	すいっち
   private function switchVisible(e:MouseEvent):void 
   {
        debugField.visible = !debugField.visible;

        if ( debugField.visible ) 
        {
	    openField.text = "▲"
	}
        else
	{
	    openField.text = "▼"
       	}
	    
    }
		
    //	
    private function endMove(e:MouseEvent):void 
    {
        stopDrag();
    }

	
    //	
    private function startMove(e:MouseEvent):void 
    {
        startDrag();
    }
    
    //	更新
    private function update():void
    {
        var w:Number = Math.max( barField.textWidth + 20, debugField.textWidth  ) + 4 ;
        barField.width = w - 20;
        debugField.width = w;
    		
        debugField.height = debugField.textHeight + 4;
    }
    	
    public function add(key:String, str:String) : void
    {
        dictionary[key] = str;
        debugField.text = "";
    	
        for ( var s:String in dictionary )
	{
	    debugField.appendText( s + "：" + dictionary[s] + "\n" );
	}
			
        update();
    }
		
    public function remove(key:String) : void
    {
        dictionary[key] = null;
        delete dictionary[key];
    	
        update();
    }
 }