package  
{
	import flash.display.Sprite;
	import flash.text.TextField;
	
	/**
	* Irwin-Hall distribution.
	* @author makc
	* @license WTFPLv2 http://sam.zoy.org/wtfpl/
	* @see http://en.wikipedia.org/wiki/Irwin%E2%80%93Hall_distribution
	*/
	public class IrwinHall extends Sprite
	{
		public var N:int = 6;
		public var v:Array = [];
		public function IrwinHall() 
		{
			for (var i:int = 0; i < N; i++) {
				v [i] = [];
				var tf:TextField = new TextField;
				tf.text = "n = " + (i + 1);
				tf.x = 50 * (1.4 + 3 * (i % 3));
				tf.y = 200 * (1.1 + int (i / 3));
				addChild (tf);
			}
			addEventListener ("enterFrame", loop);
		}
		public function loop (e:*):void
		{
			var i:int, j:int, k:int;

			graphics.clear ();
			for (i = 0; i < N; i++) {
				var vi:Array = v [i];
				// update random vars
				var r:Number = 0;
				for (j = 0; j < i + 1; j++) r += Math.random ();
				vi.push (r); if (vi.length > 1000) vi.shift ();
				// plot distribution
				var x0:Number = 50 * (0.6 + 3 * (i % 3));
				var y0:Number = 200 * (1 + int (i / 3));
				graphics.beginFill (0, 0);
				graphics.lineStyle (0, 0);
				graphics.moveTo (x0, y0 -100);
				graphics.lineTo (x0, y0); graphics.lineTo (x0 +100, y0);
				graphics.lineStyle ();
				graphics.endFill ();
				graphics.beginFill (255);
				for (k = 0; k < 10; k ++) {
					var n:int = 0;
					for (j = 0; j < vi.length; j++)
						if ((0.1 * k <= vi [j] / (i + 1)) && (vi [j] / (i + 1) < 0.1 * (k + 1)))
							n++;
					graphics.drawRect (x0 + 10 * k, y0 - 0.5 * n, 10, 0.5 * n);
				}
				graphics.endFill ();
			}
		}

	}

}