/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oxD4
 */

// http://www.swf.hu/forum/topic/tween-kerdes-as3-ban
package {

    import flash.display.Sprite;
    
    import fl.motion.easing.Sine;
    import fl.transitions.Tween;
    import fl.transitions.TweenEvent;    
    
    public class FlashTest extends Sprite {

        private static const N:int = 10;
        
        public function FlashTest() {
            const W:Number = stage.stageWidth;
            const H:Number = stage.stageHeight;
            for (var i:int = 0; i < N; ++i) {
                var disc:Sprite = new Sprite();
                disc.graphics.beginFill(Math.floor(0x1000000) * Math.random());
                disc.graphics.drawCircle(0, 0, rnd(50, 100));
                disc.graphics.endFill();
                disc.x = rnd(0, W);
                disc.y = rnd(0, H);
                var anim:Tween = new Tween(disc, "scaleX", fl.motion.easing.Sine.easeInOut, 1, 0.1, rnd(20, 60));
                anim.addEventListener(TweenEvent.MOTION_CHANGE, animPhase);
                anim.addEventListener(TweenEvent.MOTION_FINISH, animFinished);
                addChild(disc);
            }
        }

        private function animPhase(e:TweenEvent):void {
            e.target.obj.scaleY = e.target.position;
        }
        
        private function animFinished(e:TweenEvent):void {
            e.target.yoyo();
        }
                
        private static function rnd(n:Number, m:Number):Number {
            return (n + Math.floor((m - n + 1) * Math.random()));
        }
    }
}