/**
 * Copyright gameegg ( http://wonderfl.net/user/gameegg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/owVO
 */

package {
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class Blackhole extends Sprite {
        
        private var dotArray:Array = [];
        private var space:Sprite;
        private var rotationNumber:Number;
        private var rotationNumber2:Number;
        private var textField:TextField;
        private var mouseDown:Boolean = false;
        
        public function Blackhole() {
            
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            space = new Sprite();
            addChild(space);
            
            textField = new TextField();
            textField.textColor = 0xffffff;
            addChild(textField);
            
            rotationNumber = 0;
            rotationNumber2 = 180;
            stage.addEventListener(MouseEvent.MOUSE_DOWN,md);
            stage.addEventListener(MouseEvent.MOUSE_UP,mu);
            addEventListener("enterFrame",ef);
        }
        
        private function ef(e:Event):void {
            textField.text = new String(dotArray.length);
            
            var distance:Number = 200;
            
            if(mouseDown){
            var newDot:Dot = new Dot(Math.cos(rotationNumber*3.14/180)*distance+235.5,-Math.sin(rotationNumber*3.14/180)*distance+235.5,
            0,0);
            newDot.speedX = (465/2-newDot.currentY)/30;
            newDot.speedY = (465/2-newDot.currentX)/30;
            dotArray.push(newDot);
            
            var newDot2:Dot = new Dot(Math.cos(rotationNumber2*3.14/180)*distance+235.5,-Math.sin(rotationNumber2*3.14/180)*distance+235.5,
            0,0);
            newDot2.speedX = (465/2-newDot2.currentY)/30;
            newDot2.speedY = (465/2-newDot2.currentX)/30;
            dotArray.push(newDot2);
            }
            
            space.graphics.clear();
            
            
            for(var i:int = 0; i < dotArray.length; ++i){
                var tmpDot:Dot = dotArray[i];
                var r:Number = pit(tmpDot.currentX,tmpDot.currentY,mouseX,mouseY);
                var X:Number = mouseX-tmpDot.currentX;
                var Y:Number = mouseY-tmpDot.currentY;
                
                tmpDot.speedX += (X*100)/(r*r);
                tmpDot.speedY += (Y*100)/(r*r);
                
                tmpDot.speedX *= 0.95;
                tmpDot.speedY *= 0.95;
                
                tmpDot.currentX += tmpDot.speedX;
                tmpDot.currentY += tmpDot.speedY;
                
                space.graphics.lineStyle(10/tmpDot.getSpeed(),Math.random()*0xffffff);
                
                space.graphics.moveTo(tmpDot.oldX,tmpDot.oldY);
                space.graphics.lineTo(tmpDot.currentX,tmpDot.currentY);
                
                tmpDot.oldX = tmpDot.currentX;
                tmpDot.oldY = tmpDot.currentY;
            }
               
               
            rotationNumber = (rotationNumber+1 >= 360) ? 0:rotationNumber+1;
            rotationNumber2 = (rotationNumber2+1 >= 360) ? 0:rotationNumber2+1;
        }
        
        private function pit(a:Number,b:Number,c:Number,d:Number):Number {
            return Math.sqrt((a-c)*(a-c) + (b-d)*(b-d));
        }
        
        private function md(e:MouseEvent):void{
            mouseDown = true;
        }
        private function mu(e:MouseEvent):void{
            mouseDown = false;
        }
    
    }
}

internal class Dot {
    
    public var oldX:Number;
    public var oldY:Number;
    
    public var currentX:Number;
    public var currentY:Number;
    
    public var speedX:Number;
    public var speedY:Number;
    
    public function Dot (ix:Number,iy:Number,isx:Number,isy:Number) {
        oldX = ix;
        oldY = iy;
        
        currentX = ix;
        currentY = iy;
        
        speedX = isx;
        speedY = isy;
    }
    
    public function getSpeed():Number {
        return Math.sqrt(speedX*speedX + speedY*speedY);
    }

    
}
