/**
 * Copyright WinField95 ( http://wonderfl.net/user/WinField95 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/owNQ
 */

package
{
    import com.bit101.components.NumericStepper;
    import flash.display.Sprite;
    import flash.events.Event;
 
    public class Main extends Sprite
    {
        private var rad:Number = 0.0;
        private var r:Number = 100.0;
        private var xBox:Sprite;
        private var yBox:Sprite;
        private var aStepper:NumericStepper;
        private var bStepper:NumericStepper;
        private var line:Sprite;
 
        public function Main()
        {
            this.x = this.y = stage.stageWidth / 2;
 
            addChild(line = new Sprite());
            addChild(xBox = new Sprite());
            addChild(yBox = new Sprite());
            xBox.graphics.beginFill(0x0);
            xBox.graphics.drawRect( -5, -5, 10, 10);
            xBox.graphics.endFill();
            yBox.graphics.beginFill(0x0);
            yBox.graphics.drawRect( -5, -5, 10, 10);
            yBox.graphics.endFill();
 
            aStepper = new NumericStepper(this, 100, 180, update);
            bStepper = new NumericStepper(this, 100, 200, update);
            aStepper.value = 9;
            bStepper.value = 8;
 
            update();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
        private function update(event:Event = null):void
        {
            graphics.clear();
            graphics.lineStyle(2.0);
 
            rad = 0;
            xBox.y = yBox.x = r * 1.3;
            xBox.x = yBox.y = 0;
        }
 
        private function onEnterFrame(event:Event):void 
        {
            line.graphics.clear();
            if (rad >= Math.PI * 2) return;
            rad += 0.005;
            graphics.lineTo(Math.sin(aStepper.value * rad) * r, Math.sin(bStepper.value * rad) * r);
            xBox.x = Math.sin(aStepper.value * rad) * r;
            yBox.y = Math.sin(bStepper.value * rad) * r;
 
            line.graphics.lineStyle(2.0, 0xED1A3D);
            line.graphics.moveTo(xBox.x, xBox.y);
            line.graphics.lineTo(Math.sin(aStepper.value * rad) * r, Math.sin(bStepper.value * rad) * r);
            line.graphics.lineTo(yBox.x, yBox.y);
        }
    }
}
 