/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ovlR
 */

// forked from yonatan's tree
// forked from yonatan's Depth-aware Lines3D
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;

    public class FlashTest extends BasicView {
        private var lines:BetterLines3D;
        private var lineMat:LineMaterial;
        private var particles:Particles;
        private var skybox:Sphere;
        private var envBmd:BitmapData = new BitmapData(512, 512);
        private var env:Shape = new Shape;
        private var envMat:BitmapMaterial;

        public function FlashTest() {
            var stats:Stats = new Stats;
            stage.quality = "medium";
            addChild(stats);
            stage.addEventListener("click", function(e:*):void { stats.visible = !stats.visible; });
            stats.visible = false;
            
            lineMat = new LineMaterial(0);
            lines = new BetterLines3D(lineMat);
            particles = new Particles;

            // sky and ground
            env.graphics.beginGradientFill("linear",[16777215,16775270,3924696,1551064,2579612,5848846,5125643,4468489,2497027],[1,1,1,1,1,1,1,1,1],[0,25,59,94,126,133,228,237,255],new Matrix(0.0000,0.3125,-0.3125,0.0000,256.0000,256.0000),"pad","rgb",0);
            env.graphics.drawRect(0, 0, 512, 512);
            env.graphics.endFill();
            envBmd.draw(env);
            envMat = new BitmapMaterial(envBmd);
            envMat.doubleSided = true;
            skybox = new Sphere(envMat, 3500);
            for each(var v:Vertex3D in skybox.geometry.vertices) {
                v.y = Math.max(v.y, 0);
            }
            scene.addChild(skybox);

            // tree
            var t:Turtle = new Turtle(lines);
            t.pitch(-90);
            t.y = skybox.y = -500;
            tree(t, 7, 300);
            scene.addChild(lines);
            scene.addChild(particles);
            camera.zoom = 100;
            startRendering();
        }

        override protected function onRenderTick(e:Event = null):void {
            camera.x = 400 * Math.sin(getTimer()/900);
            camera.y = 300 + 600 * Math.cos(getTimer()/1700);
            camera.z = 2550 * Math.cos(getTimer()/2300);
            super.onRenderTick(e);
        }

        private function tree(t:Turtle, levels:int, size:Number):void {
            t.width = size/5;
            t.fd(size);
            if(!levels) {
                var color:ColorHSV = new ColorHSV(55+20*Math.random(), 0.7, 0.5);
                var mat:ParticleMaterial = new ParticleMaterial(color.value, 0.75, ParticleMaterial.SHAPE_CIRCLE);
                particles.addParticle(new Particle(mat, size*5, t.x, t.y, t.z));
            } else {
                t.roll(120);
                t.pitch(-30);
                tree(t.replicate(), levels-1, size*0.75);
                t.pitch(70);
                tree(t, levels-1, size*0.7);
            }
        }
    }
}

import org.papervision3d.objects.DisplayObject3D;   

class Turtle extends DisplayObject3D {
    public var lines:BetterLines3D;
    public var width:Number;

    public function Turtle(lines_:BetterLines3D, width_:Number = 20) {
        lines = lines_;
        width = width_;
    }

    public function replicate():Turtle {
        var ret:Turtle = new Turtle(lines, width);
        ret.copyTransform(this);
        return ret;
    }

    // forward/back
    public function fd(n:Number):Turtle {
        var px:Number = x;
        var py:Number = y;
        var pz:Number = z;
        moveForward(n);
        lines.addNewLine(width, px, py, pz, x, y, z);
        return this;
    }
    public function bk(n:Number):Turtle { return fd(-n); }
}

import org.papervision3d.core.geom.renderables.Line3D;
import org.papervision3d.core.render.command.RenderLine;
import org.papervision3d.core.render.data.RenderSessionData;
import org.papervision3d.materials.special.LineMaterial;
import org.papervision3d.objects.DisplayObject3D;   
import org.papervision3d.core.geom.*;

// This class scales the lines' width relative to their (center) screen Z.
// This can make interconnect points bulge, but I think it's better than the
// lines becoming skinny when they're close to the camera.

class BetterLines3D extends Lines3D {
    public function BetterLines3D(material:LineMaterial = null, name:String=null) {
        super(material, name);
    }
    
    /**
    * Converts 3D vertices into 2D space, to prepare for rendering onto the stage.
    *
    * @param    parent              The parent DisplayObject3D
    * @param    renderSessionData   The renderSessionData object for this render cycle. 
    * 
    */      
    public override function project( parent :DisplayObject3D, renderSessionData:RenderSessionData ):Number
    {
        // This ugly hack is here because I can't do super.super.project(parent, renderSessionData)
        // and I don't want Lines3D::project to add any lines to the render list.
        var tmp:Array = lines;
        lines = [];
        super.project(parent, renderSessionData);
        lines = tmp;
        
        var line3D:Line3D;
        var screenZ:Number;
        var rc:RenderLine;
        
        for each(line3D in lines)
        {
            if(renderSessionData.viewPort.lineCuller.testLine(line3D))
            {
                rc = line3D.renderCommand;
                
                rc.renderer = line3D.material;
                
                screenZ += rc.screenZ = (line3D.v0.vertex3DInstance.z + line3D.v1.vertex3DInstance.z)/2;
                
                var fz:Number = (renderSessionData.camera.focus*renderSessionData.camera.zoom);
                rc.size = line3D.size * fz / (renderSessionData.camera.focus + rc.screenZ);

                rc.v0 = line3D.v0.vertex3DInstance;
                rc.v1 = line3D.v1.vertex3DInstance;
                
                renderSessionData.renderer.addToRenderList(rc);
            }
        }
        
        return screenZ/(lines.length+1);
    }
}
