/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ovWF
 */

package {
    
    import flash.text.TextField
    import flash.display.Sprite
    import flash.utils.setTimeout
    
    public class Hanguel extends Sprite {
        
        private var 질문:글자칸, 답:글자칸, 알림:글자칸
        private var 점수:int = 0, 목숨:int = 5
        
        public function Hanguel() {
            var 설명:글자칸 = 새로운글자칸
            설명.스스로크기바꿈 = 가운데
            설명.내용 = "글자에 해당하는 유니코드를 입력하고 엔터를 누르세요"
            설명.가로곳 = (무대가로길이 - 설명.가로길이) / 2
            설명.세로곳 = 10
            넣는다(설명)
            
            질문 = 새로운글자칸
            질문.스스로크기바꿈 = 가운데
            질문.가로곳 = (무대가로길이 - 질문.가로길이) / 2
            질문.세로곳 = (무대세로길이 - 질문.세로길이) / 2
            넣는다(질문)
            
            답 = 새로운글자칸
            답.내용 = ""
            답.가로길이 = 200
            답.세로길이 = 22
            답.용도 = 입력용
            답.테두리 = 보인다
            답.가로곳 = (무대가로길이 - 답.가로길이) / 2
            답.세로곳 = (무대세로길이 - 답.세로길이) / 1.5
            넣는다(답)
            
            알림 = 새로운글자칸
            알림.스스로크기바꿈 = 가운데
            알림.내용 = ""
            알림.가로곳 = (무대가로길이 - 알림.가로길이) / 2
            알림.세로곳 = (무대세로길이 - 알림.세로길이) / 4
            알림.보임 = 아니다
            넣는다(알림)
            
            새질문()
            무대사건보기(키누름, 키누를때)
        }
        
        private function 새질문():void {
            //var min:int = "ㄱ".charCodeAt(0)
            //var max:int = "힣".charCodeAt(0)
            var 새문제:String = 문자로( 사이값(0xAC00, 0xD7AF) )
            질문.내용 = 새문제
            답.내용 = ""
        }
        
        private function 사이값(바닥:int, 천장:int):int {
            return 바닥 + (천장 - 바닥 + 하나) * Math.random()
        }
        
        private function 키누를때(사건:Object):void {
            if(사건.keyCode == 줄바꿈){
                if(숫자로(답.내용) == 0) 알림창('유니코드 숫자를 입력하세요')
                else if(질문.국제부호 == 숫자로(답.내용)){
                    점수 ++
                    알림창('정답입니다')
                    새질문()
                }else{
                    알림창('틀렸습니다. ' + 질문.내용 + "의 유니코드는 " + 질문.국제부호 + "입니다.")
                    목숨 --
                    if(목숨 == 0){
                        // game over
                        무대사건안보기("키누름", 키누를때)
                        모두없앤다
                        넣는다(알림)
                        알림창('놀이가 끝났습니다. 당신의 점수는 ' + 점수 + '점 입니다', 2000)
                    }else 새질문()
                }
            }
        }
        
        private function 알림창(정보:String, 기간:uint=1000):void {
            알림.내용 = 정보
            알림.보임 = 그렇다
            setTimeout(function():void{알림.보임=아니다}, 기간)
        }
        
        private function get 무대가로길이():Number { return stage.stageWidth }
        private function get 무대세로길이():Number { return stage.stageHeight }
        private function 넣는다(칸:글자칸):void { addChild(칸) }
        private function get 새로운글자칸():글자칸 { return new 글자칸 }
        private function get 모두없앤다():int { while(numChildren) removeChildAt(0) ; return 0 }
        private function 숫자로(문자:String):int { return int(문자) }
        private function 무대사건보기(사건종류:String, 다루기:Function):void { stage.addEventListener(사건종류, 다루기) }
        private function 무대사건안보기(사건종류:String, 다루기:Function):void { stage.removeEventListener(사건종류, 다루기) }
        private function 문자로(국제부호:int):String { return String.fromCharCode(국제부호) }
        
    }
    
}

import flash.ui.Keyboard
const 줄바꿈:int = Keyboard.ENTER
const 가운데:String = "center"
const 아니다:Boolean = false
const 그렇다:Boolean = true
const 보인다:Boolean = true
const 입력용:String = "input"
const 하나:int = 1
const 키누름:String = "keyDown"

import flash.text.TextField
class 글자칸 extends TextField {
    public function get 가로곳():Number { return x }
    public function set 가로곳(새값:Number):void { x = 새값 }
    public function get 세로곳():Number { return y }
    public function set 세로곳(새값:Number):void { y = 새값 }
    public function get 가로길이():Number { return width }
    public function set 가로길이(새값:Number):void { width = 새값 }
    public function get 세로길이():Number { return height }
    public function set 세로길이(새값:Number):void { height = 새값 }
    public function get 내용():String { return text }
    public function set 내용(새값:String):void { text = 새값 }
    public function set 스스로크기바꿈(새값:String):void { autoSize = 새값 }
    public function set 보임(새값:Boolean):void { visible = 새값 }
    public function set 테두리(새값:Boolean):void { border = 새값 }
    public function set 용도(새값:String):void { type = 새값 }
    public function get 국제부호():uint { return 내용.charCodeAt(0) }
}