/**
 * Copyright LawrieCape ( http://wonderfl.net/user/LawrieCape )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ovR2
 */

// forked from mtarbit's flash on 2009-7-15
package {
        import gs.*;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.display.DisplayObject;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.events.Event;
	import flash.events.MouseEvent;
        import flash.display.BitmapData;
        import flash.display.Bitmap;
        import flash.filters.BlurFilter;
        import flash.geom.Point;

	[SWF(backgroundColor=0x000000, frameRate=120)]
	
	public class Main extends Sprite {
		public var mouseIsDown:Boolean = false;

                public var BMD:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xFF000000);
                public var b:Bitmap = new Bitmap(BMD);
                public var bf:BlurFilter = new BlurFilter(2, 2, 1);
		public var maxCircles:int = 250;
		public var circles:MovieClip = new MovieClip();
		

                public var mouseXSpeed:Number = 0;
                public var mouseYSpeed:Number = 0;
        
                public var mouseXPrev:Number  = 0;
                public var mouseYPrev:Number  = 0;

		public function Main() {
                        addChild(b)
			var format:TextFormat = new TextFormat();
			format.bold = true;
			format.size = 24;
			format.align = 'center';
			format.font = "Helvetica";
                        format.color = 0xFFFFFF;

			var field:TextField = new TextField();
			field.width = stage.stageWidth;
			field.text = "Click & Drag";
			field.setTextFormat(format);
                        field.selectable = false;

			field.x = (stage.stageWidth - field.width) / 2;
			field.y = (stage.stageHeight - field.height) / 2;

			addChild(field);
			addChild(circles);

			stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
			stage.addEventListener(Event.ENTER_FRAME, onLoop);
                }

		public function newCircle(x:int, y:int):void {
			var color:uint = (Math.random() * 0xffffff);
			var radius:uint = 5 + Math.round(45 * Math.random());
			var circle:MovieClip = new MovieClip();

			circle.x = x;
			circle.y = y;
                        
                        circle.scaleX = circle.scaleY = 0;
                        
                        TweenLite.to(circle, 0.5,{scaleX:1, scaleY:1})
                            
                        circle.speedX = mouseXSpeed
                        circle.speedY = mouseYSpeed
                        
			circle.graphics.beginFill(color, 1);
			circle.graphics.drawCircle(0, 0, radius);

			circles.addChild(circle);
		}

		public function moveCircle(circle:*, n:int):void {
			
                        circle.alpha = 1 - (n / maxCircles);
			if (circle.alpha <= 0) {
				circle.parent.removeChild(circle);
			}
			if ((circle.y < stage.stageHeight)&&(circle.y > 0)&&(circle.x < stage.stageWidth)&&(circle.x>0)) {
				circle.y += circle.speedY;
                                circle.x += circle.speedX;
			}
                        else{
                            TweenLite.to(circle,5,{scaleX:0,scaleY:0});
                        }
		}

		public function onDown(event:MouseEvent):void {
			mouseIsDown = true;
		}
		public function onMove(event:MouseEvent):void {
                    	mouseXSpeed = mouseX - mouseXPrev;
                	mouseYSpeed = mouseY - mouseYPrev;
	    
                	mouseXPrev  = mouseX;
                	mouseYPrev  = mouseY;
    
			if (mouseIsDown) newCircle(mouseX, mouseY);
		}
		public function onUp(event:MouseEvent):void {
			mouseIsDown = false;
		}

		public function onLoop(event:Event):void {
                        BMD.draw(this);
                        BMD.applyFilter(BMD, BMD.rect, new Point(0,0), bf);                     
			var n:int = circles.numChildren;
			for (var i:int = (n-1); i>=0; i--) {
				moveCircle(circles.getChildAt(i), n-i);
			}
		}

	}

}