/**
 * Copyright igoooon ( http://wonderfl.net/user/igoooon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ovGL
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.events.Event;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;    
    

    /**************************************************
     *
     * ドキュメントクラス
     *
     **************************************************/

    public class Main extends Sprite
    {
        
        /*********************************************
         * 
         * クラスメンバ
         * 
         *********************************************/

        // ビューポート
        private var viewport:Viewport3D;        

        // シーン
        private var scene:Scene3D;        

        // レンダー
        private var renderer:BasicRenderEngine;        

        // カメラ
        private var camera:Camera3D;

        // マテリアルリスト
        private var materialsList:MaterialsList;

        // オブジェクト
        private var cube:Cube;

        // マテリアル
        private var plane1:ColorMaterial; //front
        private var plane2:ColorMaterial; //back
        private var plane3:ColorMaterial; //left
        private var plane4:ColorMaterial; //right
        private var plane5:ColorMaterial; //top
        private var plane6:ColorMaterial; //bottom

        /*********************************************
         *
         * コンストラクタ
         *
         *********************************************/

        public function Main():void
        {
            //ステージ設定
            stage.frameRate = 60;
            stage.quality = "BEST";
            stage.scaleMode = "noScale";
            stage.align = StageAlign.TOP_LEFT;

            initialize3D();
        }

        private function initialize3D():void
        {
            // ビューポート
            viewport = new Viewport3D();
            viewport.viewportWidth = 400; //幅
            viewport.viewportHeight = 300; //高さ
            viewport.x = ( this.stage.stageWidth - viewport.viewportWidth ) / 2; //X座標
            viewport.y = ( this.stage.stageHeight - viewport.viewportHeight ) / 2; //Y座標
            addChild(viewport);

            // シーン
            scene = new Scene3D();

            // カメラ
            camera = new Camera3D();

            // レンダー
            renderer = new BasicRenderEngine();

            // マテリアル
            plane1 = new ColorMaterial( 0xff0000 );
            plane2 = new ColorMaterial( 0xff0000 );
            plane3 = new ColorMaterial( 0x00ff00 );
            plane4 = new ColorMaterial( 0x00ff00 );
            plane5 = new ColorMaterial( 0xffff00 );
            plane6 = new ColorMaterial( 0xffff00 );

            // マテリアルリスト
            materialsList = new MaterialsList();
            materialsList.addMaterial(plane1 , "front");
            materialsList.addMaterial(plane2 , "back");
            materialsList.addMaterial(plane3 , "left");
            materialsList.addMaterial(plane4 , "right");
            materialsList.addMaterial(plane5 , "top");
            materialsList.addMaterial(plane6 , "bottom");

            // オブジェクト
            cube = new Cube(materialsList, 300, 300, 300, 1, 1, 1); //立方体(幅、奥行き、高さ、幅分割、奥行き分割、高さ分割) 
            scene.addChild( cube );

            // レンダリング開始
            addEventListener( Event.ENTER_FRAME, eFrame );
        }

        private function eFrame( e:Event ):void 
        {
            //cube.yaw( ( 200 - mouseX ) / 50 ); //X軸回転
            //cube.pitch( ( 150 - mouseY ) / 50 ); //Ｙ軸回転

            cube.yaw( 1 );
            cube.pitch( 1 );

            renderer.renderScene(scene, camera, viewport);
        }

    }

}