/**
 * Copyright halfmile ( http://wonderfl.net/user/halfmile )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ovCZ
 */

// forked from soundkitchen's シュッ!!
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    import com.flashdynamix.utils.SWFProfiler;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class Main extends Sprite
    {
        private var _moji:Bitmap;

        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            var txt:TextField,
                fmt:TextFormat,
                bmd:BitmapData;

            fmt = new TextFormat();
            fmt.size = 48;
            fmt.color = 0xFFFFFF;
            fmt.font = "Verdana";

            txt = new TextField();
            txt.defaultTextFormat = fmt;
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.text = "孙悟空";

            bmd = new BitmapData(txt.width, txt.height, true, 0);
            bmd.draw(txt);

            _moji = new Bitmap(bmd);
            _moji.x = (stage.stageWidth - _moji.width) >> 1;
            _moji.y = (stage.stageHeight - _moji.height) >> 1;
            addChild(_moji);

            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }

        private function clickHandler(evt:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.CLICK, clickHandler);

            var t:ITween;

            t = BetweenAS3.parallel(
                //  shake.
                BetweenAS3.from(_moji, {
                    '$x': -20
                }, .5, Elastic.easeOutWith(5, .1)),
                //  blur.
                BetweenAS3.to(_moji, {
                    '_blurFilter': {
                        'blurX': 256
                    }
                }, .3, Expo.easeOut),
                //  alpha.
                BetweenAS3.to(_moji, {
                    'alpha': 0
                }, .3, Sine.easeIn)
            );

            t = BetweenAS3.serial(
                //  normal.
                t,
                //  reverse.
                BetweenAS3.delay(BetweenAS3.reverse(t), 1)
            );

            t.onComplete = tweenComplete;
            t.play();
        }

        private function tweenComplete():void
        {
            stage.addEventListener(MouseEvent.CLICK, clickHandler);

            _moji.x += 20;
            _moji.filters = [];
        }
    }
}
