/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/otWU
 */

/**
 * フラクタル + 紅葉です。
 * もっと違うやり方がありそうだけど、、
 */ 
package 
{
	import flash.display.Sprite;
	import flash.display.GradientType;
	import flash.display.SpreadMethod;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.utils.Timer;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	/**
	 * @author Mao Takagi
	 */
	[SWF(backgroundColor="#000000", frameRate="30", width="465", height="465")]
	public class Main extends Sprite
	{
		private var _gradient:Sprite;
		private var _autumnGradient:Sprite;
		private var _snowGradient:Sprite;
		private var _tree:Tree;
		private var _snowTimer:Timer;
		private var _snowField:Sprite;
		private var _blur:BlurFilter;
		/**
		 * constructor
		 */
		public function Main()
		{
			Wonderfl.capture_delay(5);
			_gradient = new Sprite();
			_autumnGradient = createAutumnGradient();
			_snowGradient = createSnowGradient();
			_gradient.addChild(_autumnGradient);
			_gradient.addChild(_snowGradient);
			_snowGradient.alpha = 0;
			
			_snowTimer = new Timer(1000);
			_snowField = new Sprite();
			_blur = new BlurFilter();
			_snowField.filters = [_blur];
			
			_tree = new Tree();
			_tree.rotation = 180;
			_tree.x = 465 / 2;
			_tree.y = 465;
			_gradient.mask = _tree;
			addChild(_gradient);
			addChild(_tree);
			addChild(_snowField);
			
			_tree.addEventListener(Event.COMPLETE, generateTreeComplete);
		}
		/**
		 * 木を作り終えたら
		 * @param event Event
		 */
		private function generateTreeComplete(event:Event):void 
		{
			_tree.removeEventListener(Event.COMPLETE, generateTreeComplete);
			var t:ITween = BetweenAS3.tween(_snowGradient, { alpha:1 }, null, 10);
			t.play();
			
			_snowTimer.addEventListener(TimerEvent.TIMER, function():void
			{
				//雪降らす
				var snow:Sprite = new Sprite();
				snow.graphics.beginFill(0xFFFFFF);
				snow.graphics.drawCircle(0, 0, Math.random() * 3 + 2);
				snow.graphics.endFill();
				snow.x = Math.random() * stage.stageWidth;
				snow.y = -15;
				_snowField.addChild(snow);
				var t:ITween = BetweenAS3.tween(snow, { x:snow.x + 30, y:stage.stageHeight + 15 }, null, Math.random() * 5 + 10);
				t.addEventListener(TweenEvent.COMPLETE, function():void
				{
					t.removeEventListener(TweenEvent.COMPLETE, arguments.callee);
					_snowField.removeChild(snow);
				});
				t.play();
			});
			_snowTimer.start();
		}
		/**
		 * 紅葉グラデーション作成
		 * @return Sprite
		 */
		private function createAutumnGradient():Sprite
		{
			var sprite:Sprite = new Sprite();
			var colors:Array = [0x794E46, 0x05FA05, 0xECEC13, 0xF80E0E];
			var alphas:Array = [1, 1, 1, 1];
			var ratios:Array = [30, 60, 110, 225];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(465, 465, -Math.PI / 2);
			sprite.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
			sprite.graphics.drawRect(0, 0, 465, 465);
			sprite.graphics.endFill();
			return sprite;
		}
		/**
		 * 雪グラデーション作成
		 * @return Sprite
		 */
		private function createSnowGradient():Sprite
		{
			var sprite:Sprite = new Sprite();
			var colors:Array = [0x794E46, 0xFFFFFF];
			var alphas:Array = [1, 1];
			var ratios:Array = [30, 60];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(465, 465, -Math.PI / 2);
			sprite.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
			sprite.graphics.drawRect(0, 0, 465, 465);
			sprite.graphics.endFill();
			return sprite;
		}
	}
}
/**
 * 木クラス
 */
import flash.display.Sprite;
import flash.events.Event;
class Tree extends Sprite 
{
	private var _lastGeneration:uint;
	private var _nowGeneration:uint;
	private var _rotArray:Array;
	private var _branchArray:Array;
	private var _judge:uint;
	/**
	 * constructor
	 */
	public function Tree():void
	{
		_lastGeneration = 6;
		_nowGeneration = 0;
		_judge = 0;
		_rotArray = [ -30, 30, 0];
		_branchArray = new Array();
		var mainBranch:Branch = new Branch(170);
		createBranch(mainBranch, mainBranch.height);
		addChild(mainBranch);
	}
	/**
	 * 枝を_generationMaxの世代まで再帰的に作成。
	 * @param p 親の枝
	 * @param baseLen 親の枝の長さ
	 */
	private function createBranch(p:*, baseLen:Number):void
	{
		_judge = Math.pow(3, _nowGeneration + 1);
		for (var i:uint = 0; i < 3;i++ )
		{
			var branch:Branch = new Branch();
			var perLen:Number = baseLen / 3;
			//var perLen:Number = p.height / 3;
			_branchArray.push(branch);
			branch.y = perLen * i + perLen;
			branch.addEventListener(Event.COMPLETE, function():void
			{
				branch.removeEventListener(Event.COMPLETE, arguments.callee);
				_judge--;
				if (_judge == 0)
				{
					_nowGeneration++;
					if (_nowGeneration != _lastGeneration)
					{
						var j:uint = 0;
						var nextLen:uint = _branchArray.length;
						var nextArray:Array = new Array();
						for (j = 0; j < nextLen; j++ )
						{
							nextArray.push(_branchArray[j]);
						}
						_branchArray = [];
						for (j = 0; j < nextLen;j++ )
						{
							createBranch(nextArray[j], perLen * 2);
						}
					}
					else if (_nowGeneration == _lastGeneration)
					{
						dispatchEvent(new Event(Event.COMPLETE));
					}
				}
			} );
			p.addChild(branch);
			branch.Start(perLen * 2, _rotArray[i]);
		}
	}
}
/**
 * 枝クラス
 */
import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;
import caurina.transitions.Tweener;

class Branch extends Sprite
{
	private var _graphic:Sprite;
	/**
	 * constructor
	 * @param len 長さの初期値
	 */
	public function Branch(len:Number = 1):void
	{
		_graphic = new Sprite();
		/*
		_graphic.graphics.lineStyle(1, 0x000000, 1, false, 'none');
		_graphic.graphics.lineTo(0, len);
		*/
		_graphic.graphics.beginFill(0x000000);
		_graphic.graphics.drawRect(0, 0, 1, len);
		_graphic.graphics.endFill();
		addChild(_graphic);
	}
	/**
	 * にょきにょき
	 * @param len 目標の長さ
	 * @param rot 角度
	 */
	public function Start(len:Number, rot:Number):void 
	{
		//trace(len);
		rotation = rot;
		Tweener.addTween(_graphic, { height:len, time:1, onComplete:onComplete } );
		/*↓本来は
		var t:ITween = BetweenAS3.tween(_graphic, { height:len }, null , 1, Elastic.easeOut);
		t.addEventListener(TweenEvent.COMPLETE, function():void 
		{ 
			t.removeEventListener(TweenEvent.COMPLETE, arguments.callee);
			dispatchEvent(new Event(Event.COMPLETE)) 
		} );
		t.play();
		*/
	}
	/**
	 * 
	 * @param 
	 */
	private function onComplete():void 
	{
		dispatchEvent(new Event(Event.COMPLETE));
	}
}