/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oscj
 */

// forked from Hasufel's Old Skool [Optimised]
// forked from devon_o's Old Skool

//@Hasufel 2010
//***********************************************************************************/
package  {
    
    import com.adobe.utils.StringUtil;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    //import flash.display.StageAlign;
    //import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.system.fscommand;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    import net.hires.debug.Stats;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.tweens.groups.SerialTween;
    //import flash.display.PixelSnapping;
    
    /**
     * old school demo effects: http://iquilezles.org/www/articles/deform/deform.htm
     * @author Devon O.
     * @optimisation Hasufel
     */

    [SWF(width='465', height='465', frameRate='45')]
    public class OldSkool extends Sprite {
        
        private static const res:int = 512;
        private static const _rect:Rectangle = new Rectangle(0,0,res,res);
        private const _xres:uint = 512;//256//128
        private const _yres:uint = 512;//256//128
        private var _input:BitmapData;
        private var _output:BitmapData;        
        private var _lookUpTable:Vector.<uint> = new Vector.<uint>();
        private var _inputVector:Vector.<uint> = new Vector.<uint>();
        private var _time:uint = 0;
        private var _effect:int = 0;
        private var _maxEffects:int = 51; //you should add more, your imagination is the limit!
        private var _outputVector:Vector.<uint> = new Vector.<uint>();
        private var angularSteps:int=60;
        private var angle:Number = 2*Math.PI/angularSteps;
        private var radius:Number=res*0.5*Math.SQRT2;
        private var innerRadius:Number = 25;
        private var g:Graphics;
        private var iSprite:Sprite;
        private var isCartesian:Boolean = true;
        private var isIDown:Boolean;
        private var dimension:int;
        private var gridDimension:int;
        private var counter:int;
        private var counterPeriod:int =45*1;
        private var changesCounter:int;
        
        //[Embed(systemFont="Arial", fontName="FontName", mimeType="application/x-font", embedAsCFF="false")]
        private static var font:Class;
        //[Embed(source="assets/maps.txt",mimeType="application/octet-stream")]
        //private var myText:Class;
        private var textField:TextField;
        private var mapDisplay:TextField;
        private var clean:Array;

        public function parseText ():void
        {       
            /*
            var txt:ByteArray = new myText() as ByteArray;
            var t:String = txt.toString();
            var s:Array = t.split("\n");
            textField = TextField(addChild(new TextField));
            textField.defaultTextFormat = new TextFormat("Arial", 8);
            textField.width  = 465;
            textField.height = 710;
            textField.x = res * Math.SQRT2;
            textField.border = true;
            clean = [];
            for (var i:int = 0; i < s.length; i++) 
            {
                var item:String = s[i];
                var temp:String = StringUtil.trim(item);
                if (temp!=""&&temp!="break;") 
                {
                    //if (temp!="break;") 
                    {
                        clean[clean.length] = temp;
                    }
                }
                
            }
            s.length = 0;
            for (var j:int = 0; j < clean.length; j++) 
            {
                //var item: = clean[j];
                if (j%3) 
                {
                    s[s.length] = clean[j]
                    //cTrace( clean[j] );
                    
                }
                
            }
            clean.length = 0;
            for (var k:int = 0; k < s.length; k++) 
            {
                if (k%2) 
                {
                    
                clean[clean.length] = [s[k], s[k + 1]];
                }
                
            }
            cTrace( "clean.length : " + clean );
            */
        }
        private function cTrace(msg:String):void 
        {
            textField.appendText("\n" + msg);
        }
        public function OldSkool() {
            if (stage) init(null);
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event=null):void {
            //fscommand('fullscreen', 'true');
            //parseText();
            iSprite = Sprite(addChild(new Sprite));
            removeChild(iSprite);
            g = iSprite.graphics;
            gridDimension = 32;
            dimension = 16;
            setInput();
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.align = StageAlign.TOP_LEFT;
            this.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            this.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            _output = new BitmapData(_xres, _yres, false, 0x000000);
            var bmp:Bitmap = new Bitmap(_output);
            bmp.width = bmp.height = 512;
            addChild(bmp);
            //bmp.bitmapData = _input;
            //bmp.visible = false;
            addChild(new Stats());
            createLUT();
            addEventListener(Event.ENTER_FRAME, frameHandler);
            this.addEventListener(MouseEvent.CLICK, onClick);
            
            mapDisplay = TextField(addChild(new TextField()));
            var textFormat:TextFormat = new TextFormat("Lucida Console",9);
            mapDisplay.defaultTextFormat = textFormat;
            //mapDisplay.embedFonts = true;
            mapDisplay.width = 300;
            mapDisplay.height = 50;
            mapDisplay.x = (res*0);
            mapDisplay.y = (res ) * 1.0;
            mapDisplay.background = true;
            mapDisplay.text = 'hello';
            mapDisplay.alpha = 1;
            mapDisplay.backgroundColor = 0xffffaa;
            //setDisplayText();
            
        }
        
        private function setDisplayText():void 
        {
            mapDisplay.text = _effect+'\n'+clean[_effect][0] + '\n' + clean[_effect][1];
        }
        private function onKeyUp(e:KeyboardEvent):void 
        {
            this.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            
        }
        private function onKeyDown(e:KeyboardEvent):void 
        {
            trace( "OldSkool.onKeyDown > e : " + e );
            this.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            switch(e.keyCode)
            {
                case String('I').charCodeAt():
                    isIDown = true;
                break;
            }
        }
        
        private function setInput():void 
        {
            var resHalves:int = res >> 1;
            g.clear();
            g.lineStyle(3, 0);
            if (isCartesian) 
            {
                isCartesian = false;
                for (var i:int = 0; i <gridDimension; i++) 
                {
                    g.moveTo(i * dimension, 0);
                    g.lineTo(i * dimension, res);
                }
                g.lineStyle(3,0);
                for (i = 0; i <gridDimension; i++) 
                {
                    g.moveTo(0  ,i * dimension);
                    g.lineTo(res,i * dimension);
                }
                g.beginFill(0xff);
                g.drawCircle(resHalves, resHalves, innerRadius);
                g.endFill();
            }
            else 
            {
                isCartesian = true;
                g.beginFill(0xff0000);
                for (var j:int = 0; j < Math.ceil(res*0.5*Math.SQRT2-innerRadius)/dimension; j++) 
                {
                    g.drawCircle(res >> 1, res >> 1, innerRadius + j * dimension);
                    
                }
                for (var k:int = 0; k < angularSteps; k++) 
                {
                    g.moveTo(resHalves+innerRadius  * Math.cos(angle*k), resHalves+innerRadius * Math.sin(angle*k));
                    g.lineTo(resHalves+radius * Math.cos(angle*k), resHalves+radius * Math.sin(angle*k));
                    
                }
                g.endFill();
                g.beginFill(0xff);
                g.drawCircle(resHalves, resHalves, innerRadius);
                g.endFill();
                    
            }
            var bitmapData:BitmapData = new BitmapData(res, res,true);
            bitmapData.draw(iSprite);
            _input = bitmapData;
            _inputVector = _input.getVector(_rect);
        }
        
        private function onClick(e:MouseEvent):void {
            if (++_effect > _maxEffects) _effect = 0;
            createLUT();
        }
        
        private function frameHandler(e:Event):void {
            if (isIDown) 
            {
                isIDown = false;;
                setInput();
            }
            counter++;
            if (!(counter%counterPeriod) )
            {
                changesCounter++;
                trace( "(counter%counterPeriod) : " + (counter%counterPeriod) );
                if (changesCounter%2==0) 
                {
                mapDisplay.text =( counter.toString());
                    if (++_effect > _maxEffects) 
                    {
                        _effect = 0;
                        counter = 0;
                    }
                    createLUT();
                    //setDisplayText();
                }
                setInput();
            }
            renderDeformation();
            _time += 5;
        }
         
        private function renderDeformation():void {
            for(var j:uint=0; j < _yres; ++j) {
                for (var i:uint = 0; i < _xres; ++i) {            
                    var o:uint = ((j<<9) + i)>>0;//uint((j<<9) + i);//_xres * j +i; //lets stick to 512 (<<9) for now
                    var u:uint = _lookUpTable[(o<<1)>>0] + _time;//uint(o<<1)] + _time; //cast
                    var v:uint = _lookUpTable[((o<<1)+1)>>0] + _time;//uint((o<<1) + 1)] + _time;//cast
                _outputVector[((j<<9) + i)>>0] = _inputVector[(((v & 511) <<9) + (u & 511))>>0];// _outputVector[uint((j<<9) + i)] = _inputVector[uint(((v & 511)<<9) + (u & 511))]; //never forget casting!
                }
            }
            _output.lock();
            _output.setVector(_rect, _outputVector);
            _output.unlock();
        }                 
        
        private function createLUT():void {
            var k:uint = 0;
            for (var j:int = 0; j < _yres; ++j) {
                for (var i:int = 0; i < _xres; ++i) {
                    var xx:Number = -1.0 + 2.0 * i / _xres;
                    var yy:Number = -1.0 + 2.0 * j / _yres;
                    var d:Number = Math.sqrt(xx * xx + yy * yy);
                    var a:Number = Math.atan2(yy, xx);
                    var r:Number = 1;
                    // MAGIC FORMULAS!
                    var u:Number;
                    var v:Number;
                    switch(_effect) {
                        case 0 :
                            u = Math.cos( a ) / d;
                            v = Math.sin( a ) / d ;
                            break;
                        case 1 :
                            u = xx * Math.cos(2 * r) - yy * Math.sin(2 * r);
                            v = yy * Math.cos(2 * r) + xx * Math.sin(2 * r);
                            break;
                        case 2 :
                            u = .5 * a / Math.PI;
                            v = Math.sin(7 * r);
                            break;
                        case 3 :
                            u = .3 / (r + 0.5 * xx);
                            v = 3.0 * a / Math.PI;
                            break;
                        case 4 :
                            u = r * Math.cos(a + r);
                            v = r * Math.sin(a + r);
                            break;
                        case 5 :
                            u = .02 * yy + .03 * Math.cos(a * 3) / r;
                            v = .02 * xx + .03 * Math.sin(a * 3) / r;
                            break;
                        case 6 :
                            u = 1 / (r + .5 + .5 * Math.sin(5 * a));
                            v = a * 3 / Math.PI;
                            break;
                        case 7 :
                            u = .1 * xx / (.11 + r * .5);
                            v = .1 * yy / (.11 + r * .5);
                            break;
                        case 8 :
                            u = .2 / Math.abs(yy);
                            v = .2 * xx / Math.abs(yy);
                            break;
                        case 9 :
                            u = Math.abs(Math.cos(1.5 * a)/r);
                            v = .2 +.5 * Math.abs(Math.cos(1.5 * a)/r);
                            break;
                        case 10 :
                            u = .3 / (xx*xx-yy);

                            v = 1 -.1 * (Math.abs(xx) + Math.abs(1/(xx*xx-yy)));
                            break;
                        case 11 :
                            u = Math.pow(yy,2);
                            v = Math.pow(xx,2);

                        break;
                        case 12 :
                            u = Math.pow(yy,3);
                            v = Math.pow(xx,2);

                        break;
                        case 13 :
                            u = Math.sin(yy);
                            v = Math.cos(xx);

                        break;
                        case 14 :
                            u = r;
                            v = .2 + .8 * (1.2+ .6 * Math.sin(13 * a))/r;

                        break;
                        case 15 :
                            u = .2 * xx / Math.abs(yy);
                            v = Math.pow(xx,2);

                        break;
                        case 16 :
                            u = .2 * xx / Math.sin(yy);
                            v = .2 * xx / Math.sin(yy);

                        break;
                        case 17 :
                            u = .2 * xx / Math.sin(yy);
                            v = .2 * yy / Math.cos(xx);

                        break;
                        case 18 :
                            u = .2 * xx / Math.tan(yy);
                            v = .2 * yy / Math.cos(yy);

                        break;
                        case 19 :
                            u = xx / Math.tan(yy) * d;
                            v = yy / Math.cos(yy) * d;

                        break;
                        case 20 :
                            u = r * xx / Math.tan(yy) * d * Math.sin(a);
                            v = yy / Math.cos(yy) * d * Math.tan(a);

                        break;
                        case 21 :
                            u = Math.pow(xx,2) * Math.sin(r) * .2 * Math.cos(d);
                            v = Math.pow(yy,2) * Math.cos(r) * .2 * Math.sin(d);

                        break;
                        case 22 :
                            u = a * (3 * Math.cos(d) - Math.cos(3 * d));
                            v = a * (3 * Math.sin(d) - Math.sin(3 * d));

                        break;
                        case 23 :
                            u = Math.pow(a,2);
                            v = Math.pow(d,2);

                        break;
                        case 24 :
                            u = Math.pow(r,2);
                            v = Math.pow(d,2);

                        break;
                        case 25 :
                            u = Math.pow((a + xx),2);
                            v = Math.pow((3*a - yy),2);

                        break;
                        case 26 :
                            u = xx * Math.cos(3) * d;
                            v = yy * Math.sin(3) * d;

                        break;
                        case 27 :
                            u = xx * Math.cos(d);
                            v = yy * Math.sin(d);

                        break;
                        case 28 :
                            u = Math.pow(Math.pow(a,2) - Math.pow(xx,2),2);
                            v = Math.pow((Math.pow(xx,2) + (2 * a * yy) - Math.pow(a,2)),2);

                        break;
                        case 29 :
                            u = xx * d - r * Math.sin(d);
                            v = yy * d - r * Math.cos(d);
                        break;
                        case 30 :
                            u = (a + xx) * Math.cos(d) - yy* Math.cos((a/xx + 1) * d);
                            v = (a + yy) * Math.sin(d) - xx* Math.sin((a/yy + 1) * d);
                        break;
                        case 31 :
                            u = Math.sqrt(d * Math.PI) * xx;
                            v = Math.sqrt(r * Math.PI) * yy;
                        break;
                        case 32 :
                            u = xx * (Math.cos(d) + r * Math.sin(d));
                            v = yy * (Math.sin(d) + r * Math.cos(d));
                        break;
                        case 33 :
                            u = r * (Math.cos(xx) + r * Math.sin(a));
                            v = r * (Math.sin(yy) + r * Math.cos(a));
                        break;
                        case 34 :
                            u = Math.pow((Math.pow(xx,2) + Math.pow(yy,2) - 2 * a * xx),2);
                            v = d * (Math.pow(xx,2) + Math.pow(yy,2));
                        break;
                        case 36 :
                            u = Math.sin(r) * Math.pow(yy,2) + d * yy;
                            v = Math.cos(r) * Math.pow(xx,2) + d * xx;
                        break;
                        case 37 :
                            u = Math.cos( a ) / d;
                            v = Math.sin( a ) / d * xx;
                        break;
                        case 38 :
                            u = Math.cos( a ) / d - yy;
                            v = Math.sin( a ) / d * xx;
                        break;
                        case 39 :
                            u = Math.cos( a ) / d - yy;
                            v = Math.sin( a ) / d - xx;
                        break;
                        case 40 :
                            u = Math.cos( a ) / d * Math.cos(a)*.2;
                            v = Math.sin( a ) / d * Math.sin(a)*.2;
                        break;
                        case 41 :
                            u = Math.cos( a ) / d * Math.tan(a)*.2;
                            v = Math.sin( a ) / d * Math.cos(a)*.2;
                        break;
                        case 42 :
                            u = .1 / yy;
                            v = .1 * xx / Math.abs(yy);
                        break;
                        case 43 :
                            u = Math.PI * .1 / Math.abs(yy) + Math.pow(d * Math.PI,2);
                            v = .1 * xx / Math.abs(yy);
                        break;
                        case 44 :
                            u = .1 / (Math.abs(yy) + Math.pow(d * Math.PI,2));
                            v = .1 * xx / Math.abs(yy);
                        break;
                        case 45 :
                            u = Math.cos( a ) / d;
                            v = 10 * yy / Math.pow(Math.abs(d) * Math.PI, xx * yy * d);
                        break;
                        case 46 :
                            u = 10 * a / Math.PI;
                            v = .1 * yy / (Math.abs(d) * Math.PI,xx * yy * d);
                        break;
                        case 47 :
                            u = 50 * Math.pow(d, Math.PI);
                            v = 50 * Math.pow(d, Math.PI);
                        break;
                        case 48 :
                            u = 500 * Math.pow(d, Math.PI);
                            v = 50 * Math.pow(d, Math.PI);
                        break;
                        case 49 :
                            u = 500 * Math.pow(d, Math.PI);
                            v = 50 * Math.pow(r, Math.PI);
                        break;
                        case 50 :
                            u = 500 * Math.pow(d, Math.PI);
                            v = Math.sin( r ) * a;
                        break;
                        default :
                            u = xx / (yy);
                            v = 1 / (yy);
                    }
                    _lookUpTable[(k++)>>0] = (512.0 * u)>>0 & 511;//_lookUpTable[uint(k++)] = uint(512.0 * u) & 511;
                    _lookUpTable[(k++)>>0] = (512.0 * v)>>0 & 511;//_lookUpTable[uint(k++)] = uint(512.0 * v) & 511;
                }
            }
        }
    }
}