/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/osAw
 */

// Learning Processing
// Daniel Shiffman
// http://www.learningprocessing.com
// http://www.learningprocessing.com/examples/chapter-5/example-5-7/
// Example 5-7: "Bouncing color"をFrocessing用に。
package {
	import frocessing.display.*;
	
	[SWF( width="465" , height="465" )]
	public class BouncingColor extends F5MovieClip {
		// Two variables for color.
		private var c1:Number = 0;
		private var c2:Number = 255;
		
		// Start by incrementing c1.
		private var c1dir:Number = 0.1;
		// Start by decrementing c2.
		private var c2dir:Number = -0.1;
		private var _width:Number = 465;
		private var _height:Number = 465;
		
		public function BouncingColor () {
			super();
		}
		public function setup():void {
			// background(0);
		}
		
		public function draw ():void {
			noStroke();
			
			// Draw rectangle on left
			fill(c1,0,c2);
			rect(0,0,_width/2,_height);
			
			// Draw rectangle of right
			fill(c2,0,c1);
			rect(_width/2,0,_width/2,_height);
			
			// Adjust color values
			c1 = c1+c1dir;
			c2 = c2+c2dir;
			
			// Instead of reaching the edge of a window,these variables  reach the "edge" of color:
			// When this happens, just like with the bouncing ball, the direction is reversed.
			
			// Reverse direction of color change 
			if (c1 < 0 || c1 > 255) {
				c1dir *= -1;
			}
			
			if (c2 < 0 || c2 > 255) {
				c2dir *= -1;
			}
		}
	}
}