/**
 * Copyright marimot ( http://wonderfl.net/user/marimot )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/os1X
 */

// forked from kousho's UstreamViewer_WIF2010
/**
 *
 * 以下のチャンネルを読み込んでください
 * http://www.ustream.tv/channel/barimi
 *
 * 
 * タグにwif2010,ustreamを入れると
 * http://webjam.webdesign-festival.com/o%28_____v%28__w__%29v___~_%29_/
 * にランダムで掲出されます。
 *
 *
 *　自由に使える素材は以下にあります。
 *
 *　イラスト
 *
 *　illust_barimi.png
 * 　http://assets.wonderfl.net/images/related_images/0/0e/0e85/0e859cec4da398db9762ae1c9683f99f94b395a9
 *
 *　illust_iizukayac.png
 * http://assets.wonderfl.net/images/related_images/d/d6/d6c5/d6c5e2c6ac5d052f0ffbdae5634ffbc25a2afa46
 *
 *　　illust_kousho.png
 * http://assets.wonderfl.net/images/related_images/c/c1/c1f5/c1f55ca807c76574b85876caa84cb5371aca857b
 *
 *
 * TODO:
 *  セキュリティサンドボックス侵害のランタイムエラーを何とかする
 *
 */

package 
{
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    
    [SWF(backgroundColor="0xFFFFFF")]
    public class UstreamViewer extends Sprite
    {
        private const CHANNEL_ID:String = "6014465";
        private const VIEWER_URL:String = "http://www.ustream.tv/flash/viewer.rsl.swf";
        
        private var viewerLoader:Loader;
        private var viewer:Object;
        
        public function UstreamViewer() 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            loadViewer();
        }
        
        private function loadViewer():void
        {
           var applicationDomain:ApplicationDomain = ApplicationDomain.currentDomain;
           var loaderContext:LoaderContext = new LoaderContext();
            viewerLoader = new Loader();
            viewerLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, rslLoadCompleteHandler);
            viewerLoader.load(new URLRequest(VIEWER_URL), loaderContext);
        }
        
        private function rslLoadCompleteHandler(event:Event):void 
        {
            viewerLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, rslLoadCompleteHandler);
            
            var debugClass:Class = viewerLoader.contentLoaderInfo.applicationDomain.getDefinition("tv.ustream.tools.Debug") as Class;
            debugClass.enabled = false;
            
            var logicClass:Class = viewerLoader.contentLoaderInfo.applicationDomain.getDefinition("tv.ustream.viewer.logic.Logic") as Class;
            viewer = new logicClass( );
            viewer.display.x = 0;
            viewer.display.y = 0;
            viewer.display.width = 320;
            viewer.display.height = 240;
            
            addChild(viewer.display);
            playChannel();
        }
        
        private function playChannel():void
        {
            viewer.createChannel(CHANNEL_ID);
            viewer.playing = true;
        }
        
    }

}