/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ornS
 */

package {
    //------------------------------------------
    //マンデルブロ集合の画像のスライドショー
    // URL:http://programmingatelier.net/
    //------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.setTimeout;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    
    public class MandelbrotSS extends Sprite {
        //それなりの画像が出来る位置（中心）と幅（d*2）
        public var arrItiData:Array = new Array(
            {x:0.688984757101685,y:-0.3539778440330296,d:0.000027190414540799984},
            {x:0.5566630579124578,y:-0.645191942087542,d:0.00029641975308641964},
            {x:0.52331,y:-0.6880649999999999,d:0.0034999999999999996},
            {x:1.3647425405405404,y:0.042899783783783806,d:0.00025566106647187723},
            {x: -0.2963045325540046, y: -0.01716809438166771, d:0.00025785045609620774 },
            {x:1.4954137491947117, y: -6.795280460316997e-18, d:4.2067307692307686e-8 },
            {x:1.4820357416427117, y: -0.0010250157778823599, d:0.00017028650519031145 },
            {x:1.4810420085796319, y: -0.0017460425056892554, d:0.000012253670176694917 },
            {x:1.4824788017574522, y: -0.00047764694614702995, d:4.1847108041441544e-7 },
            {x:1.484927687206026, y: -0.0011743844504033699, d:2.0299813821321316e-9 },
            {x:0.792830903636544, y:0.1611225381608904, d:0.000037657554334553705 },
            {x:0.8268211215928926, y:0.21528775907359385, d:0.00013712354787274902 },
            {x:0.40138733881564276, y:0.6484296120067408, d:0.000008260454691129458 },
            {x:0.4146558390863823, y:0.6048037452877455, d:0.000009654821565769149 },
            {x: -0.30660887623265226, y: -0.023344354072210326, d:0.00018200500530186895 },
            {x: -0.361951884022834, y:0.07703789783639294, d:0.000004402842003095477 },
            {x: -0.41420991771700244, y:0.21089454565556123, d:0.00019478061566501097 },
            {x: -0.27462301980737835, y:0.47907598824962744, d:0.00002566245497613555 },
            {x: -0.27462301980737835, y:0.47907598824962744, d:0.00002566245497613555 },
            {x:1.953738343858533, y: -0.000006979016668644038, d:4.746242754058168e-10 },
            {x:1.7685874527068617, y: -0.001915797085548576, d:0.0000021133259115657996 },
            {x:1.7509997978717564, y: -0.01297036904525927, d:0.000030516426163010148 },
            {x:1.7497296908611353, y: -1.8567117505617615e-8, d:7.14362997172306e-7 },
            {x:1.74920829683774, y:2.32183266582814E-07, d:1.16863016925228E-08 },
            {x:1.74654447429883, y:1.90824342843112E-05, d:1.69169330018347E-06 },
            {x:1.74592275742902, y:0.00344243428889572, d:4.8E-08 },
            {x:1.78132339315352, y: -0.00396087076298598, d:4.6656E-10 },
            {x: -0.374827748141136, y:0.101350312329572, d:8.33333333333333E-14 },
            {x:1.25902576462412, y: -0.0419243520786155, d:1.59002093703274E-07 },
            {x:1.48024571333573, y: -0.00432691628991069, d:1.62502530612245E-08 },
            {x:1.52161025388102, y: -0.000166272866551647, d:1.10204081632653E-08 },
            {x:1.52269264620533, y: -5.60106094312037E-10, d:1.10679752383325E-07 },
            {x:1.75165137975493, y: -0.0110252815584418, d:1.60941771516962E-08 },
            {x: -0.344768170113559, y:0.0521650749271265, d:4.11072878288446E-10 },
            {x:1.26988796, y:0.061716, d:1.2E-05 },
            {x:1.78570675296957,y:9.90358943081127E-08,d:2.9361028848033E-08},
            {x:-0.3360039424,y:0.05715748864000004,d:0.000009953279999996844},
            {x:-0.335686912,y:0.057350656000000035,d:0.00000921599999999967},
            {x:-0.36718719999999994,y:0.12950719999999988,d:0.0012288000000000032},
            {x:-0.3733311999999999,y:0.13288639999999988,d:0.0012288000000000032},
            {x:0.13158720000000002,y:0.8446752,d:0.00015360000000000262},
            {x:0.5594560000000001,y:0.48512,d:0.0007199999999999984},
            {x:0.7344425600000001,y:0.18182879999999993,d:0.00010080000000000089},
            {x:0.7338982400000001,y:0.1811030399999999,d:0.00010080000000000089},
            {x:0.7309952000000001,y:0.18938879999999994,d:0.001411199999999997},
            {x:0.7376480000000001,y:0.19281599999999993,d:0.001411199999999997},
            {x:0.821389184,y:0.20151187199999995,d:0.00019756799999999243},
            {x:0.8324288,y:0.19820159999999995,d:0.001411199999999997},
            {x:1.4765872000000002,y:0.004964800000000042,d:0.000057600000000004314},
            {x:1.4772208000000002,y:0.005396800000000047,d:0.000057600000000004314},
            {x:0.5563424,y:-0.48256639999999995,d:0.00047040000000000417},
            {x:0.5597024,y:-0.48424639999999997,d:0.00047040000000000417},
            {x:0.6538984960000002,y:-0.481112192,d:0.00006585599999999747},
            {x:0.6728320000000001,y:-0.45876799999999995,d:0.00033599999999999407},
            {x:0.71653152,y:-0.28493408000000003,d:0.000042239999999993395},
            {x:0.71653152,y:-0.28509152,d:0.000042239999999993395},
            {x:0.71666592,y:-0.28509152,d:0.000042239999999993395},
            {x:1.016901504,y:0.2576632575999999,d:0.000004492800000002184},
            {x:1.01856,y:0.2561919999999999,d:0.0002879999999999949},
            {x:1.4003328000000002,y:0.002211199999999992,d:0.000057599999999999875},
            {x:1.4766898124799999,y:-0.004783621120000009,d:5.529600000020452e-7},
            {x:1.476764032,y:-0.0047914240000000085,d:0.000015359999999997596},
            {x:1.2601182080000002,y:-0.04000240000000013,d:0.000007775999999983796},
            {x:1.2599408,y:-0.040321600000000124,d:0.00004320000000000324},
            {x:1.2612800000000002, y: -0.03980800000000013, d:0.00023999999999999578 },
            {x:1.4734391306296761, y: -0.0008832550380522491, d:0.000016271416832162452 },
            {x:1.7473107545989963, y: -0.000016503120490757072, d:5.918427077178728e-11 },
            {x:1.749022688597665, y:0.00038058308629588617, d:0.000027640967391429732 },
            {x:1.7492245089546872, y:0.0002654207916989568, d:0.000030811767531658036 },
            {x:1.7465235223259274,y:-3.9880101146920604e-8,d:0.000003993545585043843}
        );
        //マンデルブロ集合の描画エリア
        private var bdMandelbrot:BitmapData;
        public var arrColor:Array;    //グラデーションカラー
        public var uintHassan:uint;    //発散しない時のカラー
        private var intBMw:Number;    //描画サイズ
        private var intBMh:Number;
        private var iloop:int;        //描画状態(0～39)
        private var iTyp:int;        //画像の切り替え時のエフェクト
        private    var xMin:Number;    //マンデルブロ集合の左上の座標値
        private    var yMin:Number;
        private    var Step:Number;    //マンデルブロ集合の1ピクセルの値
        private const intKurikaesi:Number = 256;    //最大繰り返し数
        
        public function MandelbrotSS():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align =StageAlign.TOP_LEFT;
            intBMw = stage.stageWidth;    //描画サイズ取得
            intBMh = stage.stageHeight;
            //描画エリアの作成
            bdMandelbrot = new BitmapData(intBMw, intBMh, false, 0xffffff);
            var bm:Bitmap = new Bitmap(bdMandelbrot);
            stage.addChild(bm);
            bm.x = (intBMw-stage.width)/2;
            bm.y = (intBMh-stage.height)/2;
            fncDispSt();        //描画開始
        }
        //描画開始
        private function fncDispSt():void {
            iloop = 0;        //描画位置クリア
            fncSerColor();    //グラデーションカラー
            uintHassan = 0x000000;    //発散しない時のカラー
            //それなりの画像が出来る位置テーブルの選択
            var intItiData:int = getIntRand(0, arrItiData.length - 1);
            var d:Number = arrItiData[intItiData].d;
            //マンデルブロ集合の1ピクセルの値
            if (intBMh < intBMw) {
                Step = arrItiData[intItiData].d / intBMh;
            } else {
                Step = arrItiData[intItiData].d / intBMw;
            }
            Step = getNumRand(Step , Step * 1.5 );
            //マンデルブロ集合上の開始位置を決める
            xMin = arrItiData[intItiData].x - d  + getNumRand(0,  2*d-intBMw*Step);
            yMin = arrItiData[intItiData].y - d  + getNumRand(0,  2*d-intBMh*Step);
            
            //画像の切り替え時のエフェクトを指定
            iTyp = getIntRand(0, 5);
            //繰り返しイベントにマンデルブロ集合の描画追加
            this.addEventListener(Event.ENTER_FRAME, fncMandelbroDisp);
        }
        //マンデルブロ集合の描画(1/40分描画、40回繰り返し）
        private function fncMandelbroDisp(e:*):void {
            var bolEnd:Boolean = false
            var bmItiY:int;
            var bmItiX:int;
            var a:Number;
            var b:Number;
            var xx:int;
            var yy:int;
            //描画時エフェクトする。
            switch (iTyp) {
            case 0 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 1 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 2 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY + bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 3 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY +intBMw- bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 4 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY;
                        if ((bmItiX % 60) < 30) { yy += 30; }
                        if (yy >= intBMh) { yy -= intBMh; }
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 5 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        xx = bmItiX;
                        if ((bmItiY % 60) < 30) { xx += 30; }
                        if (xx >= intBMw) { xx -= intBMw; }
                        a = xMin + xx * Step;
                        bdMandelbrot.setPixel(xx, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            }
            if (iloop >= 39) { bolEnd = true; }
            iloop++;            
            
            if(bolEnd == true) {
                this.removeEventListener(Event.ENTER_FRAME,fncMandelbroDisp);
                var setIDName:Number = setTimeout(fncDispSt, 3000);    //3秒後に実行
            }
        }
        //マンデルブロ集合の1点でのカラー
        private function fncGetColor(a:Number, b:Number):uint {
            var uiCol:uint = uintHassan;    //発散しないときのカラー
            var x:Number=0;
            var y:Number=0;
            var i:int = 0;
            for(i=0;i<=intKurikaesi;i++){    //最大繰り返し数繰り返し
                var x2:Number=x*x;
                var y2:Number=y*y;
                var zx:Number=x2-y2-a;
                var zy:Number=2*x*y-b;
                x=zx;
                y=zy;
                if (x2 + y2 >= 4) {
                    var id:int = i % arrColor.length;
                    uiCol= arrColor[id];
                    break;
                }
            }
            return uiCol;
        }
        //グラデーションカラー取得
        private function fncSerColor():void {
            var arrCl0:Array;
            var arrCl1:Array;
            var icflg:uint = 0;
            while (icflg == 0) {    //256階調異なるRGBがあるか？
                icflg = 0;
                arrCl0 = new Array();
                arrCl1 = new Array();
                for (var ino:int = 0; ino < 3; ino++) {    //2色RGBの各値を求める
                    var icf:int = getIntRand(0, 2);
                    //var icf:int = getIntRand(1, 2);
                    icflg += icf;
                    if (icf == 1) {            //明－＞暗
                        arrCl0.push(255);
                        arrCl1.push(0);
                    } else if (icf == 2) {    //暗ー＞明
                        arrCl0.push(0);
                        arrCl1.push(255);
                    } else {                //適当
                        var icf2:int = getIntRand(0, 3);
                        if (icf2 == 0) {
                            arrCl0.push(0);
                            arrCl1.push(127);
                        } else if (icf2 == 1) {
                            arrCl0.push(127);
                            arrCl1.push(0);
                        } else if (icf2 == 2) {
                            arrCl0.push(255);
                            arrCl1.push(127);
                        } else {
                            arrCl0.push(127);
                            arrCl1.push(255);
                        }
                        //arrCl0.push(getIntRand(0, 255));
                        //arrCl1.push(getIntRand(0, 255));
                    }
                }
            }
            arrColor = new Array();
            var icoln:int = 32;// getIntRand(16, 32);    //intKurikaesi;
            var i:int;
            var ir:uint;
            var ig:uint;
            var ib:uint;
            for(i = 0; i < icoln; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * i / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * i / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * i / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
            for(i = 1; i < icoln-1; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * (icoln-i) / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * (icoln-i) / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * (icoln-i) / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
        }
        //乱数
        private function getIntRand(intMin:int, intMax:int):int {
                return intMin + Math.floor(Math.random() * (intMax + 1 - intMin));
        }
        private function getNumRand(numMin:Number, numMax:Number):Number {
                return numMin + Math.random() * (numMax  - numMin);
        }
    }
}