/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/orjv
 */

// forked from ProjectNya's forked from: DotLight (1) [Papervision3D]
// forked from ProjectNya's DotLight (1) [Papervision3D]
//////////////////////////////////////////////////
//    DotLight (1) [Papervision3D]
//////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.utils.getTimer;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var pixels:Pixels;
        private var layer:BitmapEffectLayer;
        private var hsv:ColorHSV;
        private static var radius:uint = 500;
        private static var radian:Number = Math.PI/180;
        private var bitmapData:BitmapData;
        private var matrix:Matrix;
        private static var scale:uint = 8;
        private var afterglow:BitmapData;
        private var aftermatrix:Matrix;
        private var colorTrans:ColorTransform;
        private var blur:BlurFilter;
        private static var acceleration:Number = 0.01;
        private static var gravity:Number = 0.03;
        private static var deceleration:Number = 0.008;
        private var map:BitmapData;
        private var offsets:Array;
        private var seed:uint;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
            addChild(new Stats());
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            scene = new Scene3D();
            camera =new Camera3D();
            viewport = new Viewport3D(0, 0, true, false);
            renderer = new BasicRenderEngine();
            setup();
            initialize();
            addChild(viewport);
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }
        private function setup():void {
            camera.x = 0;
            camera.y = 0;
            camera.z = radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
        }
        private function initialize():void {
            effect();
            layer = new BitmapEffectLayer(viewport, 465, 465, true, 0x00000000, BitmapClearMode.CLEAR_PRE);
            viewport.containerSprite.addLayer(layer);
            pixels = new Pixels(layer);
            scene.addChild(pixels);
            create(10);
        }
        private function effect():void {
            afterglow = new BitmapData(930/scale, 930/scale, false, 0xFF000000);
            var afterbitmap:Bitmap = new Bitmap(afterglow, PixelSnapping.AUTO, true);
            afterbitmap.scaleX = afterbitmap.scaleY = scale/2;
            addChild(afterbitmap);
            aftermatrix = new Matrix(2/scale, 0, 0, 2/scale, 0, 0);
            aftermatrix.translate(465/scale, 465/scale);
            colorTrans = new ColorTransform(0.2, 0.2, 0.2);
            blur = new BlurFilter(2, 2, 1);
            bitmapData = new BitmapData(465/scale, 465/scale, true, 0x00000000);
            var bitmap:Bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, true);
            bitmap.scaleX = bitmap.scaleY = scale;
            bitmap.blendMode = BlendMode.ADD;
            addChild(bitmap);
            matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
            matrix.translate(232/scale, 232/scale);
            hsv = new ColorHSV(0, 0.4);
            map = new BitmapData(465/scale, 465/scale, false, 0xFF000000);
            offsets = [new Point(), new Point()];
            seed = uint(Math.random()*1000);
        }
        private function render(evt:Event):void {
            update();
            sparkle();
            glow();
            var offset:Number = getTimer()*0.05;
            offsets[0].x = offsets[1].y = offset;
            map.perlinNoise(465/scale, 465/scale, 2, seed, true, true, 1, false, offsets);
            layer.fillCanvas(0x00000000);
            renderer.renderScene(scene, camera, viewport);
        }
        private function sparkle():void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            bitmapData.draw(layer, matrix);
            bitmapData.unlock();
        }
        private function glow():void {
            afterglow.lock();
            afterglow.draw(layer, aftermatrix, colorTrans, BlendMode.ADD);
            afterglow.applyFilter(afterglow, afterglow.rect, new Point(), blur);
            afterglow.unlock();
        }
        private function create(max:uint):void {
            hsv.h = 60;
            for (var n:uint = 0; n < max; n++) {
                var color:uint = 0xFF << 24 | hsv.value;
                var a:Number = Math.random()*360;
                var r:Number = 160;
                var cx:Number = Math.cos(a*radian)*r;
                var cy:Number = -140;
                var cz:Number = Math.sin(a*radian)*r;
                var power:Number = Math.random() + 0.5;
                var pixel:Pixel3D = new Pixel3D(color, cx, cy, cz);
                var dot:Object = new Object();
                dot.color = 60;
                dot.cx = 0;
                dot.cy = cy;
                dot.cz = 0;
                dot.va = 0;
                dot.angle = a;
                dot.radius = r;
                dot.vy = 0;
                dot.power = power;
                dot.energy = 2;
                dot.offset = 0;
                pixel.vertex3D.extra = dot;
                pixels.addPixel3D(pixel);
            }
        }
        private function update():void {
            for each (var pixel:Pixel3D in pixels.pixels) {
                var dot:Object = pixel.vertex3D.extra;
                dot.va += acceleration;
                dot.angle += dot.va;
                var c:uint = map.getPixel(dot.x/scale, (dot.y + 140)/scale);
                var offset:Number = (((c >> 16) & 0xFF) - 0x80) / 0x80;
                dot.cx += offset*4;
                dot.cz += offset*4;
                dot.vy += gravity*dot.power;
                dot.vy *= 0.99;
                dot.cy += dot.vy;
                dot.radius = (dot.energy*0.4 + 0.2)*160;
                pixel.x = dot.cx + Math.cos(dot.angle*radian)*dot.radius;
                pixel.y = dot.cy;
                pixel.z = dot.cz + Math.sin(dot.angle*radian)*dot.radius;
                hsv.h = 60*dot.energy/2;
                pixel.color = 0xFF << 24 | hsv.value;
                dot.energy -= deceleration;
                if (dot.energy < 0) {
                    pixels.removePixel3D(pixel);
                    pixel = null;
                }
            }
            create(10);
        }

    }

}
