/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/orI7
 */

package {
    import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;

    public class FlashTest extends Sprite {
		private var _array:/*Butterfly*/Array;
		
        public function FlashTest() {
			var g:Graphics = this.graphics;
			g.beginFill(0x404040);
			g.drawRect(0, 0, 465, 465);
			g.endFill();
			
			_array = new Array();
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function add():void {
			var cr:uint = (Math.random() * 128) + 128;
			var cg:uint = (Math.random() * 128) + 128;
			var cb:uint = (Math.random() * 128) + 128;
			var color:uint = (cr << 16) + (cg << 8) + (cb << 0);
			var size:Number = (Math.random() * 5) + 5;
			var b:Butterfly = new Butterfly(color, size);
			b.x = 232.5;
			b.y = 232.5;
            this.addChild(b);
			_array.push(b);
		}
		
		private function proc(e:Event):void {
			add();
			
			for each(var b:Butterfly in _array) {
				b.update();
			}
			
			for (var index:int = 0; index < _array.length; ++index) {
				var bt:Butterfly = _array[index];
				var isOut:Boolean = false;
				if (bt.x < -10) isOut = true;
				if (bt.x > 465 + 10) isOut = true;
				if (bt.y < -10) isOut = true; 
				if (bt.y > 465 + 10) isOut = true;
				
				if (isOut) {
					this.removeChild(bt);
					_array.splice(index, 1);
					--index;
					continue;
				}
			}
		}
    }
}

import flash.display.Graphics;
import flash.display.Sprite;

class Butterfly extends Sprite {
	private var _rad:Number;
	private var _speedx:Number;
	private var _speedy:Number;
	
	public function Butterfly(color:uint, size:Number) {
		_rad = 0;
		var r:Number = Math.random() * Math.PI * 2;
		var length:Number = (Math.random() * 1.5) + 1.5;
		_speedx = Math.cos(r) * length;
		_speedy = Math.sin(r) * length;
		
		var g:Graphics = this.graphics;
		g.beginFill(color);
		g.moveTo(0, 0);
		g.lineTo(size, -size * 0.75);
		g.lineTo(size, +size * 0.75);
		g.lineTo(0, 0);
		g.endFill();
		g.beginFill(color);
		g.moveTo(0, 0);
		g.lineTo(-size, -size * 0.75);
		g.lineTo(-size, +size * 0.75);
		g.lineTo(0, 0);
		g.endFill();
	}
	
	public function update():void {
		_rad += 0.3;
		if (_rad >= Math.PI * 2) {
			_rad -= Math.PI * 2;
		}
		this.scaleY = Math.abs(Math.sin(_rad));
		this.rotationZ = Math.sin(_rad) * 4;
		
		this.x += _speedx;
		this.y += _speedy;
	}
}