/**
 * Copyright tonsmart5 ( http://wonderfl.net/user/tonsmart5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/or1y
 */

// forked from heart_thai's Toy Car Physic 3D Papervision3D and Jiglib3D
package 
{
	import flash.text.TextField;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.cameras.SpringCamera3D;
	import org.papervision3d.core.proto.DisplayObjectContainer3D;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Cylinder;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.Viewport3D;
	
	import jiglib.math.*;
	import jiglib.physics.*;
	import jiglib.vehicles.JCar;
	import jiglib.vehicles.JWheel;
	import jiglib.plugin.papervision3d.*;
	import flash.text.*;
	
	/**
	 * ...
	 * @author narongrit kanhanoi (heart@howdoflash.net)
	 */
	public class Main extends Sprite 
	{
		private var jcar:JCar;
		
		private var carObj:DisplayObject3D;
		private var body:Cube;
		
		private var view:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var rd:BasicRenderEngine;
		
		
		private var physic:Papervision3DPhysics;
		
		private var steerFR:DisplayObject3D;
		private var steerFL:DisplayObject3D;
		
		private var wheelFL:Cylinder;
		private var wheelFR:Cylinder;
		private var wheelBL:Cylinder;
		private var wheelBR:Cylinder;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			setup3D();
			
			carObj = new DisplayObject3D();
			scene.addChild(carObj);
			carObj.y = 500;
			
			var material:WireframeMaterial = new WireframeMaterial();
			var mats:MaterialsList = new MaterialsList();
			mats.addMaterial(material , "all");
			body = new Cube(mats, 20, 50, 20, 4, 4, 4);
			carObj.addChild(body);
			
			//---------
			wheelBL = new Cylinder(material, 20, 5);
			carObj.addChild(wheelBL);
			wheelBL.rotationZ = 90;
			wheelBL.x = 30;
			wheelBL.z = -35;
			//wheelBL.y = -200;
			
			wheelBR = new Cylinder(material, 20, 5);
			carObj.addChild(wheelBR);
			wheelBR.rotationZ = 90;
			wheelBR.x = -30;
			wheelBR.z = -35;
			//wheelBR.y = -200;
			
			
			wheelFL = new Cylinder(material, 20, 5);
			carObj.addChild(wheelFL);
			wheelFL.rotationZ = 90;
			wheelFL.x = 50;
			wheelFL.z = 50;
			//wheelFL.y = -200;
			
			
			wheelFR = new Cylinder(material, 20, 5);
			carObj.addChild(wheelFR);
			wheelFR.rotationZ = 90;
			wheelFR.x = -50;
			wheelFR.z = 50;
			//wheelFR.y = -200;
			//------------
			
			
			physic = new Papervision3DPhysics(scene);
			
			var plane:Plane = new Plane(material, 1000, 1000, 10, 10);
			scene.addChild(plane);
			plane.rotationX = 90;
			
			jcar = new JCar(new Pv3dMesh(carObj));
			jcar.setCar(20, 5, 500);
			
			jcar.setupWheel("WheelFL", new JNumber3D( -20, -10, 25), 1.2, 1.2, 3, 8, 0.4, 0.5, 2);
			jcar.setupWheel("WheelFR", new JNumber3D(20, -10, 25), 1.2, 1.2, 3, 8, 0.4, 0.5, 2);
			jcar.setupWheel("WheelBL", new JNumber3D( -20, -10, -25), 1.2, 1.2, 3, 8, 0.4, 0.5, 2);
			jcar.setupWheel("WheelBR", new JNumber3D(20, -10, -25), 1.2, 1.2, 3, 8, 0.4, 0.5, 2);
			
			steerFL = wheelFL;
			steerFR = wheelFR;
			
			physic.addBody(jcar.chassis);
			
			this.addEventListener(Event.ENTER_FRAME , render );
			
			physic.createGround(material, 1000,1);
			stage.addEventListener( KeyboardEvent.KEY_DOWN, keyDownHandler );
			stage.addEventListener( KeyboardEvent.KEY_UP, keyUpHandler );
			
			
			var txt:TextField = new TextField();
			addChild(txt);
			txt.text = "key : UP DOWN LEFT RIGHT";
			txt.width = 200;
		}
		
		private function keyDownHandler(event :KeyboardEvent):void
		{
			switch(event.keyCode)
			{
				case Keyboard.UP:
					jcar.setAccelerate(10);
					break;
				case Keyboard.DOWN:
					jcar.setAccelerate(-10);
					break;
				case Keyboard.LEFT:
					jcar.setSteer(["WheelFL", "WheelFR"], -1);
					break;
				case Keyboard.RIGHT:
					jcar.setSteer(["WheelFL", "WheelFR"], 1);
					break;
				case Keyboard.SPACE:
					jcar.setHBrake(1);
					break;
			}
		}
		
		private function keyUpHandler(event:KeyboardEvent):void
		{
			switch(event.keyCode)
			{
				case Keyboard.UP:
					jcar.setAccelerate(0);
					break;
					
				case Keyboard.DOWN:
					jcar.setAccelerate(0);
					break;
					
				case Keyboard.LEFT:
					jcar.setSteer(["WheelFL", "WheelFR"], 0);
					break;
					
				case Keyboard.RIGHT:
					jcar.setSteer(["WheelFL", "WheelFR"], 0);
					break;
				case Keyboard.SPACE:
				   jcar.setHBrake(0);
			}
		}
		private function updateWheelSkin():void
		{
			steerFL.rotationX = jcar.wheels["WheelFL"].getSteerAngle();
			steerFR.rotationX = jcar.wheels["WheelFR"].getSteerAngle();
			
			
			//Roll
			
			//wheelFL.localRotationY += jcar.wheels["WheelFL"].getRollAngle();
			//wheelFR.localRotationY += jcar.wheels["WheelFR"].getRollAngle();
			

			
			wheelBL.localRotationY += jcar.wheels["WheelBL"].getRollAngle();
			wheelBR.localRotationY += jcar.wheels["WheelBR"].getRollAngle();
			
			wheelFL.localRotationY += wheelBL.localRotationY;
			wheelFR.localRotationY += wheelBL.localRotationY;
			
			//
			steerFL.y = jcar.wheels["WheelFL"].getActualPos().y;
			steerFR.y = jcar.wheels["WheelFR"].getActualPos().y;
			wheelBL.y = jcar.wheels["WheelBL"].getActualPos().y;
			wheelBR.y = jcar.wheels["WheelBR"].getActualPos().y;

		}

		
		private function setup3D():void {
			view = new Viewport3D(stage.stageWidth, stage.stageHeight);
			addChild(view);
			scene = new Scene3D();
			camera = new Camera3D();
			rd = new BasicRenderEngine();
		}
		
		private function render(e:Event):void {
			//body.z -= 10;
		
			physic.engine.integrate(0.12);
			updateWheelSkin();
			
			camera.copyTransform(carObj.transform);
			camera.y = 200;
			camera.rotationX = 25;
			camera.moveBackward(250);
			
			rd.renderScene(scene, camera, view);
		}
	}
	
}