/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oqeZ
 */

package  
{
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.media.*;
    import jp.progression.commands.net.*;
    import jp.progression.data.*;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.*;
    
    /**
     * ...
     * @author 393
     */
    
    [SWF(backGroundColor = 0x000000, width = 465, height = 465, frameRate = 30)]
    
    public class CardEffect10 extends Sprite 
    {
        public static const MAIN_CARD_WIDTH:uint = 120;
        public static const MAIN_CARD_HEIGHT:uint = 144;
        public static const SUB_CARD_WIDTH:uint = 60;
        public static const SUB_CARD_HEIGHT:uint = 72;        
        public static const SUB_CARD_NUM:uint = 10;
        public static const SUB_CARD_NUM_MAX:uint = 50;
        public static const STAR_NUM:uint = 40; 
        public static const MAHOUJIN_LENGTH:uint = 2; 
        public static const DEGREE_TO_RADIAN:Number = Math.PI / 180;
                
        private var _w:int;
        private var _h:int;
        private var _subCardLength:int = SUB_CARD_NUM;
        
        private var _mahoujinBaseBmd:BitmapData;
        private var _mainCardBaseBmd:BitmapData;
        
        private var _mahoujinContainer:Sprite;
        private var _mainSubCardContainer:Sprite;
        private var _starContainer:Sprite;
        private var _mainCardContainer:Sprite;
        private var _levelUpContainer:Sprite;
        private var _cardContainer:Sprite;
        
        private var _rect:Rectangle;
        private var _ct:ColorTransform;
        
        private var _starArray:Vector.<Star> = new Vector.<Star>(STAR_NUM);
        private var _mahoujinMainArray:Vector.<BitmapContainer> = new Vector.<BitmapContainer>(3);
        private var _subCardArray:Vector.<BitmapContainer> = new Vector.<BitmapContainer>(SUB_CARD_NUM);
        private var _cardArray:Vector.<Sprite> = new Vector.<Sprite>();
        
        private var _mainTween:ITween;
        private var _levelTween:ITween;
        private var _mainCardLastTween:ITween;
        private var _starTween:ITween;
        
        private var _changeTimer:Timer;
        
        private var _s7:Sound;
        private var _soundList:SerialList;
        
        private var _particleEffect:ParticleEffectInline;
        private var _isFinish:Boolean;
        private var _mahoujinInTween:ITween;
        
        public function CardEffect10() 
        {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            
            _ct = new ColorTransform(.9, .9, 2.9, .95);
            _rect = new Rectangle(0, 0, _w, _h);
            transform.perspectiveProjection.fieldOfView = 70;
            
            Security.loadPolicyFile("http://393.bz/data/crossdomain.xml");
            Security.allowDomain("assets.wonderfl.net");
            Security.allowDomain("393.bz");
            Security.allowDomain("wonderfl.net");
            
            //全体の音量
            SoundMixer.soundTransform = new SoundTransform(0.5);
            
            //外部データ読み込み
            loadIData();
        }
        
        
        private function loadIData():void 
        {
            var tf:TextField = new TextField();
            var tfm:TextFormat = new TextFormat("Arial", 30, 0xFFFFFF, true);
            tf.defaultTextFormat = tfm;
            tf.autoSize = TextFieldAutoSize.RIGHT;
            tf.x = 450;
            tf.text = "0 %";
            addChild(tf);
            
            var loaderList:LoaderList = new LoaderList( {
                onProgress:function():void
                {
                    tf.text = int(this.percent) + " %";
                }                
                ,onComplete:function():void 
                {
                    dispatchEvent(new Event(Event.COMPLETE));
                }
                ,catchError:function(target:Object, e:Error):void
                {
                    //trace( target, e );
                    target.interrupt();
                }
                ,onError:function():void
                {
                    //trace("error : " + this)
                }
            });
            
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.MAIN_CARD),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.SUB_CARD),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.BG),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.MAHOUJIN0),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.MAHOUJIN1),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.MAHOUJIN2),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.LVUP),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadBitmapData(new URLRequest(URL.KIRA),{context:new LoaderContext(true)}));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE0)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE1)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE2)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE3)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE4)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE5)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE6)));
            loaderList.addCommand(new LoadSound(new URLRequest(URL.SE7)));
            
            loaderList.execute();
            this.addEventListener(Event.COMPLETE, loadCompleteHandler);
        }
        
        private function loadCompleteHandler(e:Event):void 
        {
            var i:int;
            
            //背景の設置
            addChild(new Bitmap(getResourceById(URL.BG).data as BitmapData));
            
            //魔方陣
            var mahoujinBmdArray:Vector.<BitmapData> = new Vector.<BitmapData>(3);
            mahoujinBmdArray[0] =  getResourceById(URL.MAHOUJIN0).data as BitmapData;
            mahoujinBmdArray[1] =  getResourceById(URL.MAHOUJIN1).data as BitmapData;
            mahoujinBmdArray[2] =  getResourceById(URL.MAHOUJIN2).data as BitmapData;
            _mahoujinContainer = new Sprite();
            for (i = 0; i < 3; i++)
            {
                _mahoujinMainArray[i] = new BitmapContainer(mahoujinBmdArray[i].clone(),5);
                _mahoujinContainer.addChild(_mahoujinMainArray[i]);
            }
            
            //魔方陣描画用のBitmapData
            _mahoujinBaseBmd = new BitmapData(_w, _h, true, 0x0);
            addChild(new Bitmap(_mahoujinBaseBmd));
            //メインカード描画用のBitmapData
            _mainCardBaseBmd = new BitmapData(_w, _h, true, 0x0);
            addChild(new Bitmap(_mainCardBaseBmd));
            
            //カード用エフェクト
            _particleEffect = new ParticleEffectInline();
            addChild(_particleEffect);
            _particleEffect.addEventListener(Event.COMPLETE, endTimerCompleteHandler);
            
            //メインカード
            _mainSubCardContainer = new Sprite();
            var mainCardBmd:BitmapData =  getResourceById(URL.MAIN_CARD).data as BitmapData;
            _mainCardContainer = new BitmapContainer(mainCardBmd,1);
            _mainSubCardContainer.addChild(_mainCardContainer);
            _cardArray.push(_mainCardContainer);
            
            //サブカード
            var subCardBmd:BitmapData =  getResourceById(URL.SUB_CARD).data as BitmapData;
            _cardContainer = new Sprite();
            addChild(_cardContainer);
            _cardContainer.addChild(_mainSubCardContainer);
            _mainSubCardContainer.x = _w / 2;
            _mainSubCardContainer.y = _h / 2;
            _mainSubCardContainer.z = 0;
            _mainSubCardContainer.rotationX = 0;
            for (i = 0; i < SUB_CARD_NUM; i++)
            {
                _subCardArray[i] = new BitmapContainer(subCardBmd.clone(), 0.7);
                _mainSubCardContainer.addChild(_subCardArray[i]);
                _cardArray[i] = _subCardArray[i];
            }
            
            //スター
            var kiraBmd:BitmapData = getResourceById(URL.KIRA).data as BitmapData;
            _starContainer = new Sprite();
            _starContainer.blendMode = BlendMode.ADD;
            addChild(_starContainer);
            _starContainer.x = _w / 2;
            _starContainer.y = _h / 2;
            _starContainer.z = _w / 2
            for (i = 0; i < STAR_NUM; i++)
            {
                _starArray[i] = new Star(kiraBmd.clone(), 1);
                _starContainer.addChild(_starArray[i]);
            }
            _starContainer.blendMode = BlendMode.ADD;
            
            
            //レベルアップ
            var levelUpBmd:BitmapData = getResourceById(URL.LVUP).data as BitmapData;
            _levelUpContainer = new BitmapContainer(levelUpBmd,2);
            addChild(_levelUpContainer);
            
            //SE初期化
            soundInit();
            //UI生成
            createUI();
            //初期化
            reset();
        }
        
        private function startAnimation():void 
        {
            var i:int;
            var unit:int = 1;
            
            var iTween0:ITween;
            var iTween1:ITween;
            
            //魔方陣の中身の回転
            var moujinInnerTweenArray:Array = [];
            for (i = 0; i < 3; i++)
            {
                if (i == 1) unit = -1;
                else unit = 1;
                moujinInnerTweenArray[i] = BetweenAS3.delay(BetweenAS3.tween(_mahoujinMainArray[i].container,{rotationZ:180*unit},{rotationZ:0},2.8,Sine.easeOut), 2.5);
            }
            _mahoujinInTween = BetweenAS3.parallelTweens(moujinInnerTweenArray);
            _mahoujinInTween.play();
            
            unit = 1;
            //魔法陣
            var mahoujinScaleInTweenArray:Array = [];
            for (i = 0; i < 3; i++)
            {
                if (! i) mahoujinScaleInTweenArray[i] = BetweenAS3.delay(BetweenAS3.tween(_mahoujinMainArray[i], { scaleX:1, scaleY:1,alpha:1 }, { scaleX:0, scaleY:0,alpha:0 }, 1, Expo.easeOut), 0.05+i*0.2);
                else mahoujinScaleInTweenArray[i] = BetweenAS3.delay(BetweenAS3.tween(_mahoujinMainArray[i], { scaleX:1, scaleY:1,alpha:1 }, { scaleX:15, scaleY:15,alpha:0 }, 1, Expo.easeOut), 0.05+(i-1)*0.2);
            }
            var mahoujinScaleInTween:ITween = BetweenAS3.parallelTweens(mahoujinScaleInTweenArray);
            
            //スター
            var starAlphaInTweenArray:Array = [];
            for (i = STAR_NUM-1; i >= 0; i--)
            {
                var iTweenStar:ITween 
                = BetweenAS3.serial(
                    BetweenAS3.delay(BetweenAS3.tween(_starArray[i], {scaleX:1,scaleY:1},{scaleX:0,scaleY:0}, 0.5, Expo.easeOut), i * 0.1/2.5)
                )
                starAlphaInTweenArray[i] = iTweenStar;
            }
            var starAlphaInTween:ITween = BetweenAS3.parallelTweens(starAlphaInTweenArray);
            starAlphaInTween.onComplete = function():void 
            { 
                var i:int;
                var starTweenOutArray:Array = [];
                var starTweenInArray:Array = [];
                var starX:Number;
                var starY:Number;
                var starZ:Number;
                var starTween:ITween;
                for (i = 0; i < STAR_NUM; i++)
                {
                    starX = Math.cos(DEGREE_TO_RADIAN * (360 / STAR_NUM * i )) * 80;
                    starY = -Math.sin(DEGREE_TO_RADIAN * (360 / STAR_NUM * i )) * 100 -100;
                    starZ = Math.sin(DEGREE_TO_RADIAN * (360 / STAR_NUM * i )) * 300;
                    starTween = BetweenAS3.to(_starArray[i], { x:starX, y:starY, z:starZ }, 1, Sine.easeInOut );
                    starTweenOutArray[i] = starTween;
                }
                for (i = 0; i < STAR_NUM; i++)
                {
                    starX = Math.cos(DEGREE_TO_RADIAN * (360 / STAR_NUM * i )) * 2000;
                    starY = -Math.sin(DEGREE_TO_RADIAN * (360 / STAR_NUM * i )) * 1500 -100 + 10* (Math.random()-0.5)
                    starZ = Math.sin(DEGREE_TO_RADIAN * (360 / STAR_NUM * i )) * 3000 - 0;
                    starTween = BetweenAS3.to(_starArray[i], { x:starX, y:starY, z:starZ,alpha:0 }, 3, Sine.easeOut );
                    starTweenInArray[i] = starTween;
                }
                var t0:ITween = BetweenAS3.parallelTweens(starTweenOutArray);
                var t1:ITween = BetweenAS3.parallelTweens(starTweenInArray)
                t0.onComplete = function():void
                {
                    _particleEffect.start(2000);
                    _cardContainer.visible = false;
                }
                _starTween = BetweenAS3.serial(t0, t1);
                _starTween.play();
            };
            
            //サブカード
            var subCardAlphaInTweenArray:Array = [];
            var subCardLength:int = _subCardArray.length;
            var offset:Number = 10 / subCardLength;
            if (offset >= 1) offset = 1;
            for (i = subCardLength-1; i >= 0; i--)
            {
                var subInTween:ITween = BetweenAS3.to(_subCardArray[i], { rotationZ:10 }, i * 0.2 * offset+0.00000001 )
                subInTween.onComplete = function():void
                {
                    new DoSound(_s7, 53, 1, false).execute();
                }
                iTween0 = BetweenAS3.serial(
                    subInTween
                    ,BetweenAS3.tween(_subCardArray[i], { scaleX:1, scaleY:1, transform: { colorTransform: { redOffset:0, greenOffset:0, blueOffset:0  }}}, { scaleX:0, scaleY:0, transform: { colorTransform: { redOffset:255, greenOffset:255, blueOffset:255  }} }, 0.5, Expo.easeOut)
                )
                subCardAlphaInTweenArray[i] = iTween0;
            }
            var subCardAlphaInTween:ITween = BetweenAS3.parallel(BetweenAS3.parallelTweens(subCardAlphaInTweenArray), starAlphaInTween);
            
            //最初のメインカードセット
            var mainCardFirstTween:ITween  = BetweenAS3.bezierTo(_mainSubCardContainer, { y:_h/2, z:_w/2 ,scaleY:1,rotationX:-45},{y:-50,z:-80,scaleY:1,rotationX:-100}, 1.2, Sine.easeInOut);
            var mahoujinTween:ITween = BetweenAS3.parallel(BetweenAS3.serial(mahoujinScaleInTween,subCardAlphaInTween))
            _mainTween = BetweenAS3.serial(mainCardFirstTween,mahoujinTween)
            _mainTween.play();
            
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        //パーティクルからのイベント受け
        private function endTimerCompleteHandler(e:Event):void 
        {
            var subCardLength:int = _subCardArray.length;
            _particleEffect.destroy();
            for (var i:int = 0; i < subCardLength; i++)
            {
                _subCardArray[i].scaleX = _subCardArray[i].scaleY = 0;
            }
            _mainCardContainer.scaleX = _mainCardContainer.scaleY = 2;
            _cardContainer.visible = true;
            _particleEffect.visible = false;
            
            //メインカード拡大
            _mainCardLastTween = BetweenAS3.bezierTo(_mainSubCardContainer, {y:_h/2, z:0 ,scaleY:1,scaleX:1,rotationX:0},{y:_h/2 - 200,z:200,rotationX:90}, 1, Sine.easeInOut);
            _mainCardLastTween.play();
            
            //スターの最後のとびちり
            var starOutTweenArray:Array = [];
            for (i = 0; i < STAR_NUM; i++)
            {
                var posX:Number = Math.cos(DEGREE_TO_RADIAN * 360 / STAR_NUM * i) * 320;
                var posY:Number = Math.sin(DEGREE_TO_RADIAN * 360 / STAR_NUM * i) * 320;
                var posX1:Number = Math.cos(DEGREE_TO_RADIAN * 360 / STAR_NUM * i) * 100 + Math.random() * 50;
                var posY1:Number = Math.sin(DEGREE_TO_RADIAN * 360 / STAR_NUM * i) * 100 + Math.random() * 50;
                starOutTweenArray[i] = BetweenAS3.tween(_starArray[i], { scaleX:1,scaleY:1, x:posX, y:posY ,z:0,alpha:0.8 },{ scaleX:0,scaleY:0, x:posX1, y:posY1 ,z:0 }, Math.random() * 0.5+1, Sine.easeInOut);
            }
            var starOutTween:ITween = BetweenAS3.delay(BetweenAS3.parallelTweens(starOutTweenArray), 1);
            
            _isFinish = true;
                
            for (i = 0; i < STAR_NUM; i++)
            {
                _starArray[i].tweenPlay();
            }
            
            //レベルアップのイン→レベルアップアウト
            var levelTweenArray:Array = [];
            levelTweenArray[0] = BetweenAS3.tween(_levelUpContainer, {alpha:1,y:_h/2 + 100,_blurFilter:{blurX: 0,blurY:0}}, {alpha:0,y:_h/2 + 100,_blurFilter:{blurX: 128 * 2, blurY: 128 * 2} }, 1.5, Sine.easeOut);
            levelTweenArray[1] = BetweenAS3.delay(BetweenAS3.tween(_levelUpContainer, {alpha:0, y:_h / 2 + 100 , _blurFilter: { blurX: 128 * 8, blurY:128 * 8 }},{alpha:1,y:_h/2 + 100,_blurFilter:{blurX: 0,blurY:0}}, 3, Sine.easeOut), 1);
            _levelTween =  BetweenAS3.parallel(BetweenAS3.serialTweens(levelTweenArray), starOutTween);
            _levelTween.play();
        }
        
        
        private function enterFrameHandler(e:Event):void 
        {
            _mahoujinBaseBmd.draw(_mahoujinContainer );
            _mahoujinBaseBmd.colorTransform(_rect, _ct);
            if (_isFinish)
            {
                var unit:int;
                for (var i:int = 0; i < 3; i++)
                {
                    if (i == 1) unit = -1;
                    else unit = 1;
                    _mahoujinMainArray[i].container.rotationZ += 1.5 * unit;
                }
            }
        }
        
        private function reset():void
        {
            var i:int;
            this.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            if (_mainTween) _mainTween.stop();
            if (_levelTween) _levelTween.stop();
            if (_starTween) _starTween.stop();
            if (_mainCardLastTween) _mainCardLastTween.stop();
            if ( _mahoujinInTween) _mahoujinInTween.stop();
                        
            if (_soundList) _soundList.interrupt();
            
            _mahoujinBaseBmd.fillRect(_rect, 0x0);
            
            //魔方陣
            for (i = 0; i < 3; i++)
            {
                _mahoujinMainArray[i].x = _w / 2;
                _mahoujinMainArray[i].y = _h / 2;
                _mahoujinMainArray[i].z = _w / 2;
                _mahoujinMainArray[i].rotationX = 0;
                _mahoujinMainArray[i].rotationY = 0;
                _mahoujinMainArray[i].rotationZ = 0;
                _mahoujinMainArray[i].rotationX = -60;
                _mahoujinMainArray[i].scaleX = _mahoujinMainArray[i].scaleY = 0;
            }
            
            //サブカード
            var subCardLength:int = _subCardArray.length;
            var position:Number = subCardLength;
            var offsetIndex:int = 0;
            var offsetR:int = 0;
            var offsetY:int = 0;
            if (position == 1)
            {
                position = 1 / 0.75;
                offsetIndex = 1;
            }
            else if (position == 2)
            {
                offsetY = 0;
            }
            else if (subCardLength % 2 != 0 && subCardLength < 10) offsetR = 360 / subCardLength - 90;
            
            for (i = 0; i < subCardLength; i++)
            {
                _subCardArray[i].x = Math.cos(DEGREE_TO_RADIAN * (360 / position * (i + offsetIndex) + offsetR)) * 160;
                _subCardArray[i].y = -Math.sin(DEGREE_TO_RADIAN * (360 / position * (i + offsetIndex) + offsetR)) * 130 - offsetY;
                _subCardArray[i].rotationX = 0;
                _subCardArray[i].scaleX = 0
                _subCardArray[i].scaleY = 0
                _subCardArray[i].alpha = 1;
                _subCardArray[i].visible = true;
                _subCardArray[i].name = i.toString();
            }
            _mainSubCardContainer.rotationX = 0;
            _mainSubCardContainer.z = 0;
            _mainSubCardContainer.y = _h / 2;
            
            //スター
            _starContainer.y = _h / 2;
            for (i = 0; i < STAR_NUM; i++)
            {
                _starArray[i].x = Math.cos(DEGREE_TO_RADIAN * (360 / STAR_NUM * i + offsetR)) * 250;
                _starArray[i].z = Math.sin(DEGREE_TO_RADIAN * (360 / STAR_NUM * i + offsetR)) * 350 - 0;
                _starArray[i].y = -Math.sin(DEGREE_TO_RADIAN * (360 / STAR_NUM * i + offsetR)) * 160 -100 + 10* (Math.random()-0.5)
                _starArray[i].scaleX = _starArray[i].scaleY = 0;
                _starArray[i].alpha = 1;
                _starArray[i].tweenStop();
            }
            //メインカード
            _mainCardContainer.scaleX = _mainCardContainer.scaleY = 1;
            _mainCardContainer.y = 0;
            _mainCardContainer.rotation = 0;
            _mainCardContainer.rotationX = 0;
            _mainCardContainer.z = 0;
            _mainCardContainer.filters = [];
            BetweenAS3.to(_mainCardContainer, { transform: { colorTransform: { redOffset:0, greenOffset:0, blueOffset:0  }} }, .01).play();
            
            //パーティクルの破棄
            _particleEffect.destroy();
            
            //ビットマップ状態を保持
            _mainSubCardContainer.y = _h / 2;
            _mainSubCardContainer.z = _w / 2;
            _mainSubCardContainer.rotationX = -45;
            _mainCardContainer.scaleX = _mainCardContainer.scaleY = 2
            
            var bmd0:BitmapData = new BitmapData(_w, _h, true, 0x0);
            bmd0.draw(_cardContainer);
            
            for (i = 0; i < subCardLength; i++)
            {
                _subCardArray[i].scaleX = _subCardArray[i].scaleY = 1;
            }
            _mainCardContainer.scaleX = _mainCardContainer.scaleY = 1;
            
            var bmd1:BitmapData = new BitmapData(_w, _h, true, 0x0);
            bmd1.draw(_cardContainer);
            
            _particleEffect.setImageData(bmd1, bmd0);
            
            for (i = 0; i < subCardLength; i++)
            {
                _subCardArray[i].scaleX = _subCardArray[i].scaleY = 0;
            }
            
            _mainSubCardContainer.rotationX = 0;
            _mainSubCardContainer.z = 0;
            _mainSubCardContainer.y = _h / 2;
            _cardContainer.visible = true;
            _particleEffect.visible = true;
            
            //レベル
            _levelUpContainer.x = _w / 2;
            _levelUpContainer.y = _h / 2 +100;
            _levelUpContainer.alpha = 0;
            
            _isFinish = false;
        }
        
        //UIの生成
        private function createUI():void 
        {
            var panel:Panel = new Panel(stage, 0, 0);
            panel.width = 190;
            panel.addEventListener(MouseEvent.MOUSE_OVER, function():void { BetweenAS3.to(panel,{alpha:1,x:0},0.5,Expo.easeOut).play()} );
            panel.addEventListener(MouseEvent.MOUSE_OUT, function():void {BetweenAS3.to(panel,{alpha:0.5,x:-panel.width+30},0.5,Expo.easeOut).play()} );
            var slider:HUISlider = new HUISlider(panel, 10, 10, "CARD_NUM", sliderChangeHandler);
            slider.minimum = 1;
            slider.width = 200;
            slider.maximum = SUB_CARD_NUM_MAX;
            slider.value = SUB_CARD_NUM;
            var restartBtn:PushButton = new PushButton(panel, 10, 70, "START", function():void {reset(); startAnimation();_soundList.execute(); } );
            var resetButton:PushButton = new PushButton(panel, 10, 40, "RESET", function():void { reset();} );
            resetButton.width = restartBtn.width = 170;
            _changeTimer = new Timer(200, 1);
        }
        //スライダー変更時
        private function sliderChangeHandler(e:Event):void 
        {
            _subCardLength = e.target.value;
            if (_changeTimer.running)
            {
                _changeTimer.stop();
            }
            _changeTimer.addEventListener(TimerEvent.TIMER_COMPLETE, timerCompleteHandler);
            _changeTimer.start();
        }
        //スライダー変更の決定処理
        private function timerCompleteHandler(e:TimerEvent):void 
        {
            var subCardLength:int = _subCardArray.length;
            for (var i:int = 0; i < subCardLength + 1; i++)
            {
                if (i < subCardLength)
                {
                    _subCardArray[i].destroy();
                    _mainSubCardContainer.removeChild(_subCardArray[i]);
                    _subCardArray[i] = null;
                }
                _cardArray[i] = null;
            }
            _subCardArray  = new Vector.<BitmapContainer>(_subCardLength);
            _cardArray  = new Vector.<Sprite>();
            
            var subCardBmd:BitmapData =  getResourceById(URL.SUB_CARD).data as BitmapData;
            for (i = 0; i < _subCardLength; i++)
            {
                _subCardArray[i] = new BitmapContainer(subCardBmd.clone(), 0.7);
                _mainSubCardContainer.addChild(_subCardArray[i]);
                _cardArray.push(_subCardArray[i]);
            }
            _cardArray.push(_mainCardContainer);
            
            reset();
        }
        
        //効果音
        private function soundInit():void
        {            
            var s0:Sound = getResourceById(URL.SE0).data;
            var s1:Sound = getResourceById(URL.SE1).data;
            var s2:Sound = getResourceById(URL.SE2).data;
            var s3:Sound = getResourceById(URL.SE3).data;
            var s4:Sound = getResourceById(URL.SE4).data;
            var s5:Sound = getResourceById(URL.SE5).data;
            var s6:Sound = getResourceById(URL.SE6).data;
            _s7 = getResourceById(URL.SE7).data;
            
            _soundList = new SerialList();
            _soundList.addCommand(
                //ジャンプ
                new DoSound(s0,0,1,false)
                ,1
                //魔方陣出現
                ,new DoSound(s1, 0, 1, false)
                ,.05
                ,new DoSound(s1, 0, 1, false)
                ,.05
                ,new DoSound(s1, 0, 1, false)
                ,1.0
                //カード出現
                ,new DoSound(s2, 0, 1, false)
                ,0.1
                ,new DoSound(s2, 0, 1, false)
                ,0.1
                ,new DoSound(s2, 0, 1, false)
                ,2.7
                //カード合体
                ,new DoSound(s3, 0, 1, false)
                ,2
                //魔方陣回転
                ,new DoSound(s4, 0, 1, false)
                ,3
                //カード拡大
                ,new DoSound(s5, 0, 1, false)
                ,0.7
                //魔方陣解散
                ,new DoSound(s6,0,1,false)
            )
        }
        
    }

}

import flash.display.*;
import flash.events.*;
import flash.utils.getTimer;
import flash.utils.Timer;
import org.libspark.betweenas3.*;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.*;

class BitmapContainer extends Sprite
{
    private var _scale:Number = 1;
    private var _bmd:BitmapData;
    private var _container:Sprite;
    
    function BitmapContainer(bmd:BitmapData,scale:Number = 1)
    {
        _scale = scale;
        _bmd = bmd;
        var bm:Bitmap = new Bitmap(_bmd,PixelSnapping.NEVER,true);
        bm.x = -bm.width / 2;
        bm.y = -bm.height / 2;
        _container = new Sprite();
        _container.scaleX = _container.scaleY = scale;
        _container.addChild(bm);
        addChild(_container);
    }
    public function destroy():void
    {
        _bmd.dispose();
    }
    
    public function get container():Sprite 
    {
        return _container;
    }
}

class Star extends Sprite
{
    private var _container:Sprite;
    private var _fadeTween:ITween;
    public var scale:Number = 1;
    
    public function Star(bmd:BitmapData,scale:Number = 1)
    {
        this.scale = 1.5 * Math.random() + 1;
        var bm:Bitmap = new Bitmap(bmd,PixelSnapping.NEVER,true);
        bm.x = -bm.width / 2;
        bm.y = -bm.height / 2;
        _container = new Sprite();
        _container.scaleX = _container.scaleY = this.scale;
        _container.addChild(bm);
        addChild(_container);
        this.alpha = 0.9;
        
        this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function enterFrameHandler(e:Event):void
    {
        this.rotation += 10;
    }
    public function tweenPlay():void
    {
        this.scale = 3 * Math.random() + 1;
        var iTween:ITween = BetweenAS3.tween(_container, { scaleX:0.3, scaleY:0.3,$rotation:30 }, { scaleX:this.scale, scaleY:this.scale,rotation:0 }, 1, Expo.easeOut);
        _fadeTween = BetweenAS3.serial(BetweenAS3.tween(_container, { scaleX:0, scaleY:0 }, { scaleX:0, scaleY:0 }, Math.random()/2), iTween);
        _fadeTween.stopOnComplete = false;
        _fadeTween.play();
    }
    public function tweenStop():void
    {
        if(_fadeTween) _fadeTween.stop();
        this.scale = 1.5 * Math.random() + 1;
        _container.scaleX = _container.scaleY = this.scale;
    }
}

class URL
{
    public static const MAIN_CARD:String = "http://assets.wonderfl.net/images/related_images/f/fc/fcfb/fcfb1f18a586ad79fd30a5c08cb4f267e9714530";
    public static const SUB_CARD:String = "http://assets.wonderfl.net/images/related_images/c/c3/c3b9/c3b9c082c57786d6d70cd72f342b232942865a1c";
    public static const BG:String = "http://assets.wonderfl.net/images/related_images/6/6a/6a39/6a39d24903a88ef0e43693fa953fb2aabe242387";
    public static const MAHOUJIN:String = "http://assets.wonderfl.net/images/related_images/d/d3/d3a6/d3a65301bb89f0e7db4ea5b727224b8b944fba97";
    public static const LVUP:String = "http://assets.wonderfl.net/images/related_images/e/ef/efdd/efdd32f0082c3456d2268d25c487a3fc1bb12d33";
    public static const KIRA:String = "http://assets.wonderfl.net/images/related_images/3/31/3167/31679ab5ea5e6b984bd4476ca107be3bf2c37391";
    public static const MAHOUJIN2:String = "http://393.bz/data/magic0.png";
    public static const MAHOUJIN1:String = "http://393.bz/data/magic1.png";
    public static const MAHOUJIN0:String = "http://393.bz/data/magic2.png";
    public static const SE0:String = "http://393.bz/data/10.mp3";
    public static const SE1:String = "http://393.bz/data/11.mp3";
    public static const SE2:String = "http://393.bz/data/12.mp3";
    public static const SE3:String = "http://393.bz/data/13.mp3";
    public static const SE4:String = "http://393.bz/data/14.mp3";
    public static const SE5:String = "http://393.bz/data/15.mp3";
    public static const SE6:String = "http://393.bz/data/16.mp3";
    public static const SE7:String = "http://393.bz/data/17.mp3";
}


class ParticleEffectInline extends Sprite
{
    private var _loaderInfo:LoaderInfo ;
    private var _particleList:ParticleList ;
    private var _canvas:BitmapData ;
    private var _startTime:int ;
    private var _bm:Bitmap;
    private var _ratio:Number = 0.02;
    private var _count:int = 0;
    private var bmContainer:Sprite;
    private var sp:Sprite;
    private var sp1:Sprite;
    private var _timer:Timer;
    private var _isEnd:Boolean;
    private var _endCount:int;
    private var _endTimer:Timer;
    
    public function ParticleEffectInline(stage:Stage = null)
    {
        addEventListener(Event.ADDED_TO_STAGE , init);
    }
    
    private function init(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        
        _particleList = new ParticleList() ;
        
        _timer = new Timer(1,1);
        _timer.addEventListener(TimerEvent.TIMER_COMPLETE, timercompleteHandler);
        _endTimer = new Timer(2800, 1);
        _endTimer.addEventListener(TimerEvent.TIMER_COMPLETE, endTimerCompleteHandler);
        
        _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00FFFFFF ) ;
        addChild( new Bitmap( _canvas ) )
    }
    
    public function setImageData(bmd0:BitmapData, bmd1:BitmapData):void
    {
        _particleList.setImageData(bmd0, bmd1);
    }
    
    public function destroy():void
    {
        _timer.stop();
        _timer.reset();
        _endTimer.stop();
        _endTimer.reset();
        _canvas.fillRect(_canvas.rect, 0x0);
        _particleList.destroy();
        removeEventListener( Event.ENTER_FRAME, onRender );
    }
    
    public function start(delay:int):void
    {
        removeEventListener( Event.ENTER_FRAME, onRender );
        _timer.reset();
        _timer.stop();
        _timer.delay = delay;
        _timer.start();
        
         _startTime = getTimer( ) ;
         _isEnd = false;
        
        _ratio = 0.03;
        _particleList.changeListStart();
        
        addEventListener( Event.ENTER_FRAME, onRender);
        onRender(null);
    }
            
    private function timercompleteHandler(e:TimerEvent):void 
    {
        _isEnd = true;
        _ratio = 0.1;
        _particleList.changeListEnd();
        
        _endTimer.reset();
        _endTimer.stop();
        _endTimer.start();
    }
    
    private function endTimerCompleteHandler(e:TimerEvent):void 
    {
        dispatchEvent(new Event(Event.COMPLETE));
    }
    
    private function onRender( event:Event ):void
    {
        var current:Particle ;
        var nLength:uint = _particleList.list.length ;
        var now:int = getTimer( ) ;
        var wait:Number ;
        
        _canvas.lock( ) ;
        _canvas.fillRect(_canvas.rect, 0x00000000);
        
        var nTargetX:Number = 0;
        var nTargetY:Number = 0;
        var nStepX:Number = 0;
        var nStepY:Number = 0;
        
        for ( var i:uint = 0; i < nLength; i++ )
        {
            current = _particleList.list[ i ] ;
            
            // 下から吸着させる
            wait = ( ( current.endY / stage.stageHeight ) ) * 5000 ;
            
            _canvas.setPixel32( current.x, current.y, uint(current.color) ) ;
            
            if ( _startTime + wait < now + 0 ) 
            {
                nTargetX = current.endX;
                nTargetY = current.endY;
                nStepX = (current.endX  - current.x) * _ratio;
                nStepY = (current.endY  - current.y) * _ratio;
                
                //絶対値比較
                if (  (nStepX ^ (nStepX >> 31)) - (nStepX >> 31) < 0.2 )
                {
                    current.x = nTargetX ;
                    _endCount ++;
                }
                else
                {
                    current.x += nStepX ;
                }
                //絶対値比較
                if ( (nStepY ^ (nStepY >> 31)) - (nStepY >> 31) < 0.2 )
                {
                    current.y = nTargetY ;
                    _endCount ++;
                }
                else
                {
                    current.y += nStepY ;
                }
            }
        }
        _canvas.unlock( ) ;
    }
}


class ParticleList
{
    private var _image0:DisplayObject;
    private var _image1:DisplayObject;
    
    private var _list:Vector.<Particle>  = new Vector.<Particle>();
    private var _list0:Vector.<Particle> = new Vector.<Particle>();
    private var _list1:Vector.<Particle> = new Vector.<Particle>();
    private var _w:int = 465;
    private var _h:int = 465;
    
    public function ParticleList()
    {
    }
    
    public function setImageData(bmd0:BitmapData = null, bmd1:BitmapData = null):void
    {
        
        var image0BitmapData:BitmapData = bmd0;
        var image1BitmapData:BitmapData = bmd1;
        
        
        setDotData(image0BitmapData,_list0);
        setDotData(image1BitmapData, _list1);
        
        setDotData(image0BitmapData, _list);
        
        var length0:int = _list0.length; ;
        var length1:int = _list1.length; ;
        //初期位置の決定
        for ( var i:uint = 0; i < length0; i++ )
        {
            _list0[ i ].endX =  _list0[ i ].x+ (Math.random() - 0.5) *2000;
            _list0[ i ].endY =  _list0[ i ].y + (Math.random() - 0.5) * 400 - 500;
        }
        
        for ( i = 0; i < length1; i++ )
        {
            _list1[ i ].endX =  _list1[ i ].x;
            _list1[ i ].endY =  _list1[ i ].y;
        }
        if (length0 > length1)
        {
            for ( i = 0; i < length0; i++ )
            {
                _list[ i ].x =  _list0[ i ].x;
                _list[ i ].y =  _list0[ i ].y;
                _list[ i ].endX =  _list0[ i ].x;
                _list[ i ].endY =  _list0[ i ].y;
                _list[ i ].color =  _list0[ i ].color;
            }
        }
        else
        {
            for ( i = 0; i < length1; i++ )
            {
                if (i < length1 - (length1 - length0))
                {
                    _list[ i ].x =  _list0[ i ].x;
                    _list[ i ].y =  _list0[ i ].y;
                    _list[ i ].endX =  _list0[ i ].x;
                    _list[ i ].endY =  _list0[ i ].y;
                    _list[ i ].color =  _list0[ i ].color;
                }
                else _list[ i ] = new Particle();
            }
        }
    }
    public function destroy():void
    {
        var length:int = _list.length;
        var i:int;
        for (i = 0; i < length; i++)
        {
            _list[i] = null;
        }
        _list.length = 0;
        
        length = _list0.length;
        for (i = 0; i < length; i++)
        {
            _list0[i] = null;
        }
        _list0.length = 0;
        
        length = _list1.length;
        for (i = 0; i < length; i++)
        {
            _list1[i] = null;
        }
        _list1.length = 0;
    }
    
    private function setDotData(bitmapData:BitmapData,list:Vector.<Particle>):void 
    {
        for ( var i:uint = 0; i < _w; i++ )
        {
            for ( var j:int = 0; j < _h; j++ )
            {
                var color:uint = bitmapData.getPixel32( i, j ) ;
                if ( color == 0x00000000 ) continue ;
                
                list.push( new Particle( i, j, color ) ) ;
            }
        }
    }
    public function changeListStart():void
    {
        var currentLength:int;
        var nextLength:int;
        var tLength:int;
        var length0:int = _list0.length;
        var length1:int = _list1.length;
        
        var nextList:Vector.<Particle>;
        
        nextList = _list0.concat();
        currentLength = length1;
        nextLength = length0;
        
        tLength = Math.abs(currentLength - nextLength);
        
        if (currentLength >= nextLength)
        {
            if (nextLength != _list.length) 
            {
                nextLength += tLength;
                for ( var i:uint = 0; i < nextLength; i++ )
                {
                    if (nextLength - tLength > i)
                    {
                        _list[i].endX = nextList[i].endX;
                        _list[i].endY = nextList[i].endY;
                        _list[i].x = nextList[i].x;
                        _list[i].y = nextList[i].y;
                        _list[i].color = nextList[i].color;
                    }
                    else
                    {
                        _list[i].color = 0;
                        _list[i].x = 0
                        _list[i].y = 0;
                        _list[i].endX = 0
                        _list[i].endY = 0;
                    }
                }
            }
            else
            {
                for ( i = 0; i < nextLength; i++ )
                {
                    _list[i].endX = nextList[i].endX;
                    _list[i].endY = nextList[i].endY;
                    _list[i].x = nextList[i].x;
                    _list[i].y = nextList[i].y;
                    _list[i].color = nextList[i].color;
                }
            }
        }
        else
        {
            currentLength += tLength;
            for ( i = 0; i < currentLength; i++ )
            {
                _list[i].endX = nextList[i].endX;
                _list[i].endY = nextList[i].endY;
                _list[i].x = nextList[i].x;
                _list[i].y = nextList[i].y;
                _list[i].color = nextList[i].color;
            }
        }
        
    }
    
    public function changeListEnd():void
    {
        var currentLength:int;
        var nextLength:int;
        var tLength:int;
        var length0:int = _list0.length;
        var length1:int = _list1.length;
        
        var nextList:Vector.<Particle>;
        
        nextList = _list1.concat();
        currentLength = length0;
        nextLength = length1;
        
        tLength = Math.abs(currentLength - nextLength);
        
        if (currentLength >= nextLength)
        {
            nextLength += tLength;
            for ( var i:uint = 0; i < nextLength; i++ )
            {
                if (nextLength - tLength > i)
                {
                    _list[i].endX = nextList[i].endX;
                    _list[i].endY = nextList[i].endY;
                    _list[i].color = nextList[i].color;
                    
                }
                else
                {
                    _list[i].color = 0x0;
                }
            }
        }
        else
        {
            for ( i = 0; i < nextLength; i++ )
            {
                if (i < nextLength - tLength )
                {
                    _list[i].endX = nextList[i].endX;
                    _list[i].endY = nextList[i].endY;
                    _list[i].color = nextList[i].color;
                }
                else
                {
                    _list[i].x =  _list[i-tLength].x;
                    _list[i].y =  _list[i-tLength].y;
                    _list[i].endX = nextList[i].endX;
                    _list[i].endY = nextList[i].endY;
                    _list[i].color = nextList[i].color;
                }
            }
        }
    }
    
    public function get list( ):Vector.<Particle>
    {
        return _list ;
    }
}


class Particle
{
    public var endX:Number = 0;
    public var endY:Number = 0;
    public var x:Number = 0 ;
    public var y:Number = 0 ;
    public var color:int = 0 ;
    
    public function Particle( x:Number = 0, y:Number = 0, color:int = 0 )
    {
        this.x = this.endX = x ;
        this.y = this.endY = y ;
        this.color = color + 0xFF000000;
    }
}
