/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/opEE
 */

package {
  import flash.display.Sprite;
  import flash.events.KeyboardEvent;
  import flash.ui.Keyboard;
  import net.user1.reactor.*;
  import net.user1.logger.Logger;
  import flash.text.*;
  
  /*
  Reactor:接続用オブジェクト
      -> 接続
      -> ルーム作成
      -> 
  
  Room:メッセージ共有グループ
      -> メッセージ送信
      -> メッセージ監視
      
  */
  
  
  // メインクラス
  public class UnionRamen extends Sprite {
    // Union用オブジェクト
    protected var reactor:Reactor;
    protected var room1:Room;
    
    //送信メッセージ
    private const MES1:String = "ADD_NARUTO";
    
    // Viewオブジェクト
    protected var ramenBowl:Sprite;
    
    // コンストラクタ
    public function UnionRamen () {
      // View作成
      buildUI();
      // 接続用のReactorオブジェクトを作成
      reactor = new Reactor();
      // 接続完了したら readyListener() を起動
      reactor.addEventListener(ReactorEvent.READY, readyListener);
      // Unionサーバーに接続。
      reactor.connect("www.ozworks.dip.jp", 9100);
      //reactor.getLog().setLevel(Logger.DEBUG);
    }
    
    // 接続完了時に起動されるメソッド
    protected function readyListener (e:ReactorEvent):void {
      // このアプリ用のルームを作成
      room1 = reactor.getRoomManager().createRoom( "wonderfl.ramenRoom");
                                   
      // 他ユーザーがこのルームに送信する"ADD_NARUTO"メッセージを監視します
      room1.addMessageListener(MES1, addNarutoListener);
                                   
      // ルームに入室
      room1.join();
    }
    
    private var input:TextField = new TextField();
    // UI作成
    protected function buildUI ():void {
      // キー入力を監視
      stage.addEventListener(KeyboardEvent.KEY_UP, 
                                        keyUpListener);
      stage.addChild(input);
      input.border = true;
      input.width = 300;
      input.height =20;
      input.type="input";
      
      // ラーメン容器を作成
      ramenBowl = new Sprite();
      ramenBowl.graphics.beginFill(0xCCCC99);
      ramenBowl.graphics.drawCircle(150, 150, 150);
      addChild(ramenBowl);
    }
    
    // キー入力のリスナー
    protected function keyUpListener (e:KeyboardEvent):void {
      // 未接続だったら何もしない
      if (!reactor.isReady()) {
        return;
      }
      
      // 'n'キーが押されていたら...
      if (e.keyCode == 13) {
        //ルーム内のグループにメッセージ発信
        // sendMessage( メッセージ名, 自分自身も受信するかどうか, フィルター ,メッセージ=null)
        room1.sendMessage(MES1, true, null,input.text);
        input.text = "";
      }
    }
    
/*
    //メッセージ受信
    private static function onChatMessage(from:IClient, msg:String):void{
        //_incoming.appendText("Guest" + from.getClientID() + " : " + msg + "\n");
        _incoming.appendText(_getUserName(from) + " : " + msg + "\n");
        _incoming.scrollV=_incoming.maxScrollV;
    }
*/
    // 他ユーザーの"ADD_NARUTO"メッセージ受信時に起動するメソッド
    protected function addNarutoListener (fromClient:IClient,msg:String):void {
      // 15より多くのナルトが容器にあったら、一番古いナルトを削除しておく
      if (ramenBowl.numChildren > 15) {
        ramenBowl.removeChildAt(0);
      }

      // 容器に新しいナルトを追加
      var naruto:Naruto = new Naruto();
      naruto.x = 40 + Math.floor(Math.random()*150);
      naruto.y = 40 + Math.floor(Math.random()*150);
      var txt:TextField = new TextField();
      txt.x = 25;
      txt.y = 50;
      //メッセージ＋識別番号
      txt.text = msg+"("+fromClient.getClientID().toString()+")";
      naruto.addChild(txt);
      ramenBowl.addChild(naruto);
    }
  }
}

import flash.display.Sprite;
class Naruto extends Sprite {
  public function Naruto () {
    draw();
  }

  protected function draw ():void {
    graphics.beginFill(0xFFFFFF);
    graphics.drawCircle(40, 40, 20);
    graphics.beginFill(0xFF5599);
    graphics.drawCircle(40, 40, 7);
  }
}

