/**
 * Copyright stenpel ( http://wonderfl.net/user/stenpel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/opAU
 */

package
{
	import caurina.transitions.Tweener;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.utils.Timer;
	
	public class ClockSample extends Sprite {
		private const WIDTH:uint = stage.stageWidth;
		private const HEIGHT:Number = stage.stageHeight;
		
		private const SEC:uint = stage.stageWidth / 60;
		private const MIN:uint = stage.stageWidth / 60;
		private const HOU:uint = stage.stageWidth / 24;
		private const MUL:Number = .5;
		
		private var _timer:Timer;
		private var _secContainer:Sprite;
		private var _minContainer:Sprite;
		private var _houContainer:Sprite;
		private var _loader:Loader;
		
		public function ClockSample() {
			addEventListener(Event.DEACTIVATE, onDeactivate);
			addEventListener(Event.ACTIVATE, onActivate);
			
			_timer = new Timer(1000, 0);
			_timer.addEventListener(TimerEvent.TIMER, onTimer);
			
			init();
		}
		
		private function init():void {
			var d:Date = new Date();
			_secContainer = new Sprite();
			_minContainer = new Sprite();
			_houContainer = new Sprite();
			
			for (var i:uint = 0; i < d.getHours(); i++) {
				var h:Shape = _houContainer.addChild(this.createHou()) as Shape;
				h.x = HOU * i;
				h.y = 0;
			}
			for (var j:uint = 0; j < d.getMinutes(); j++) {
				var m:Shape = _minContainer.addChild(this.createMin()) as Shape;
				m.x = MIN * j;
				m.y = HEIGHT / 3;
			}
			for (var k:uint = 0; k < d.getSeconds(); k++) {
				var s:Shape = _secContainer.addChild(this.createSec()) as Shape;
				s.x = SEC * k;
				s.y = 2 * HEIGHT  / 3;
			}
			
			addChild(_houContainer);
			addChild(_minContainer);
			addChild(_secContainer);
			this._timer.start();
		}
		
		private function createSec():Shape {
			var _sec:Shape = new Shape();
			_sec.graphics.beginFill(0x0000FF);
			_sec.graphics.drawRect(0,0,SEC * MUL, HEIGHT / 3);
			_sec.graphics.endFill();
			
			return _sec;
		}
		
		private function createMin():Shape {
			var _min:Shape = new Shape();
			_min.graphics.beginFill(0x0000FF);
			_min.graphics.drawRect(0,0,MIN * MUL, HEIGHT / 3);
			_min.graphics.endFill();
			
			return _min;
		}
		
		private function createHou():Shape {
			var _hou:Shape = new Shape();
			_hou.graphics.beginFill(0x0000FF);
			_hou.graphics.drawRect(0,0,HOU * MUL, HEIGHT / 3);
			_hou.graphics.endFill();
			
			return _hou;
		}
		
		private function onTimer(e:TimerEvent):void {
			var d:Date = new Date();
			
			if(d.getSeconds() == 0) {
				removeChild(_secContainer);
				_secContainer = new Sprite();
				addChild(_secContainer);
				var m:Shape = _minContainer.addChild(this.createMin()) as Shape;
				m.x = (d.getMinutes() - 1) * MIN;
				m.y = HEIGHT / 3;
			} else {
				var s:Shape = _secContainer.addChild(this.createSec()) as Shape;
				s.x = (d.getSeconds() - 1) * SEC;
				s.y = 2 * HEIGHT / 3;
			}
			
			if(d.getMinutes() == 0) {
				removeChild(_minContainer);
				_minContainer = new Sprite();
				addChild(_minContainer);
				var h:Shape = _houContainer.addChild(this.createHou()) as Shape;
				h.x = (d.getHours() - 1) * HOU;
				h.y = 0;
			}
			
			if(d.getHours() == 0) {
				removeChild(_houContainer);
				_houContainer = new Sprite();
				addChild(_houContainer);
			} 
		}
		
		private function onActivate(e:Event):void {
			init();
		}
		
		private function onDeactivate(e:Event):void {
			for(var i:int = 0; i < this.numChildren; i++) {
				delete(this.removeChildAt(i));
			}
			_timer.stop();
		}
		
		private function onComplete(e:Event):void {
			init();
		}
	}
}