/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ooRw
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.text.*;
    
    import net.wonderfl.widget.Wanco;
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            var bd:BitmapData = new BitmapData(465, 465, false);
            // make sure noise in unhidden areas remains sharp
            bd.noise(9988, 0, 64);
            addChild(new Bitmap(bd));
            // something not hidden
            var w1:Wanco = new Wanco();
            w1.x = 100;
            w1.y = 200;
            addChild(w1);
            // something hidden; test transformations
            var w2:Wanco = new Wanco();
            w2.x = 300;
            w2.y = 200;
            w2.scaleX = w2.scaleY = 2;
            addChild(w2);
            // something hidden
            var tf:TextField = new TextField();
            tf.textColor = 0xffffff;
            tf.text = 'don\'t show us this text';
            tf.width = tf.textWidth + 4;
            tf.height = tf.textHeight + 4;
            tf.x = 250;
            tf.y = 400;
            addChild(tf);
            // a rectangle to hide
            var r:Rectangle = new Rectangle(50, 250, 100, 50);
            // call hide with stage object and array of stuff to hide
            Hider.hide(stage, [w2, tf, r]);
        }
        
    }
}

import flash.display.*;
import flash.filters.*;
import flash.geom.*;
import flash.utils.*;

internal class Hider {
    
    private static const pixelation:int = 8;
    private static var stage:Stage;
    private static var elements:Array;
    private static var cover:Bitmap;
    
    public static function hide(s:Stage, e:Array):void {
        stage = s;
        elements = e;
        // run before() right before the capture mechanism
        // Wonderfl._capture is also on a 3000ms timeout, but we register ours first
        setTimeout(before, 3000);
    }
    
    private static function before():void {
        var inv:Number = 1. / pixelation;
        var dim:int = Math.ceil(465 * inv);
        // the mask bitmap is white where we want to hide and black elsewhere
        var mask:BitmapData = new BitmapData(dim, dim, false, 0x000000);
        var mct:ColorTransform = new ColorTransform(1, 1, 1, 16, 255, 255, 255);
        var origin:Point = new Point();
        for each (var o:Object in elements) {
            if (o is DisplayObject) {
                // display object: render the object in white
                var m:Matrix = o.transform.concatenatedMatrix;
                m.scale(inv, inv);
                mask.draw(o as DisplayObject, m, mct);
            } else if (o is Rectangle) {
                // rectangle: fill it with white
                var left:Number = Math.floor(o.left / pixelation);
                var top:Number = Math.floor(o.top / pixelation);
                var right:Number = Math.ceil(o.right / pixelation);
                var bottom:Number = Math.ceil(o.bottom / pixelation);
                mask.fillRect(new Rectangle(left, top, right - left, bottom - top), 0xffffff);
            }
        }
        // make it completely white if any part of it is filled
        mask.threshold(mask, mask.rect, origin, '>', 0, 0xffffffff, 0xff);
        // expand it by 1 px just to be safe...
        mask.applyFilter(mask, mask.rect, origin, new ConvolutionFilter(3, 3, [1, 1, 1, 1, 1, 1, 1, 1, 1]));
        // draw the stage to a low-resolution image
        var bd:BitmapData = new BitmapData(dim, dim);
        bd.draw(stage, new Matrix(inv, 0, 0, inv));
        // copy a channel from the mask bitmap to alpha
        bd.copyChannel(mask, mask.rect, origin, BitmapDataChannel.BLUE, BitmapDataChannel.ALPHA);
        // put the pixelated bitmap on the stage
        cover = new Bitmap(bd);
        cover.scaleX = cover.scaleY = pixelation;
        stage.addChild(cover);
        // yield for actual capture mechanism
        setTimeout(after, 0);
    }
    
    private static function after():void {
        // clean up
        stage.removeChild(cover);
        stage = null;
        elements = null;
        cover = null;
    }
    
}