/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ondj
 */

// forked from matsu4512's Stage3Dã§ã·ã‚‹ã·ã‚‹
package 

{

    import com.adobe.utils.AGALMiniAssembler;

    import com.adobe.utils.PerspectiveMatrix3D;

    

    import flash.display.*;

    import flash.display3D.*;

    import flash.display3D.textures.Texture;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.geom.*;

    import flash.net.URLRequest;

    import net.wonderfl.utils.SequentialLoader;

    

    [SWF(width="500", height="500", frameRate="60")]

    public class Stage3D_09 extends Sprite

    {

        private const WIDTH:Number = 465;

        private const HEIGHT:Number = 465;

        

        private var stage3D:Stage3D;

        private var context3D:Context3D;

                

        // é ‚ç‚¹ã‚·ã‚§ãƒ¼ãƒ€

        private const VERTEX_SHADER:String =

            "m44 op, va0, vc0 \n" +        

            "mov v0, va1 \n";            //ãƒ”ã‚¯ã‚»ãƒ«ã‚·ã‚§ãƒ¼ãƒ€ã¸

        

        // ãƒ”ã‚¯ã‚»ãƒ«ã‚·ã‚§ãƒ¼ãƒ€

        private const FRAGMENT_SHADER:String =

            //ãƒ†ã‚¯ã‚¹ãƒãƒ£æƒ…å ±ã®å‡¦ç†

            "tex oc, v0, fs0<2d, linear>";    //è‰²æƒ…å ±ã®å–å¾—  v2:uvåº§æ¨™, fs0:ç”»åƒãƒ‡ãƒ¼ã‚¿

        

        //é ‚ç‚¹ãƒ‡ãƒ¼ã‚¿

        private var indices:IndexBuffer3D;

        private var vertices:VertexBuffer3D;

        private var vertexData:Vector.<Number>;

        private var indexData:Vector.<uint>;

        

        //ã°ã­å®šæ•°

        private const k:Number = 1.2;

        //æ¸›è¡°å®šæ•°

        private const a:Number = 0.9;

        //ã“ã®å€¤ãŒå¤§ãã„ã»ã©ã€ã‚ˆã‚Šãƒžã‚¦ã‚¹ã«å¼•ãä»˜ã‘ã‚‰ã‚Œã‚‹

        private const rep:Number = 50;

        //é ‚ç‚¹ã®å€‹æ•°

        private var W:int = 30, H:int = 30;

        //ä¸€ãƒžã‚¹ã®å¤§ãã•

        private var MASSW:Number, MASSH:Number;

        //é ‚ç‚¹ã®ä½ç½®æƒ…å ±ã¨åŠ ã‚ã£ã¦ã„ã‚‹åŠ›ã‚’æ ¼ç´ã™ã‚‹é…åˆ—

        private var forces:Vector.<Number>;

        

        private var imageArray:Array = [];

        

        public function Stage3D_09()

        {

            stage.scaleMode = StageScaleMode.NO_SCALE;

            stage.align = StageAlign.TOP_LEFT;

            

            stage3D = this.stage.stage3Ds[0];

            

            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContext3DCreate);

            stage3D.requestContext3D(Context3DRenderMode.AUTO);

        }

        

        private function initVertex(e:Event=null):void{

            MASSH = 2.0/(W-1);

            MASSW = 2.0/(H-1);

            

            forces = new Vector.<Number>();

            vertexData = new Vector.<Number>();

            indexData = new Vector.<uint>();

            

            //é ‚ç‚¹ã®åº§æ¨™ã¨uvåº§æ¨™ã®è¨­å®š

            for(var i:int = 0; i < H; i++){

                for(var j:int = 0; j < W; j++){

                    vertexData.push(

                        j/(W-1)*2.0-1.0,    //x

                        -(i/(H-1)*2.0-1.0),    //y

                        0.0,                //z

                        j/(W-1),            //u

                        i/(H-1)                //v

                    );

                    forces.push(0, 0);

                }

            }

            

            //å„ä¸‰è§’å½¢ã«ã‚¤ãƒ³ãƒ‡ãƒƒã‚¯ã‚¹ã‚’å‰²ã‚ŠæŒ¯ã‚‹

            for(i = 0; i < H-1; i++){

                for(j = 0; j < W-1; j++){

                    indexData.push(j+i*(W), (j+1)+i*(W), j+(i+1)*(W));

                    indexData.push((j+1)+i*(W), j+(i+1)*(W), (j+1)+(i+1)*(W));

                }

            }

            

            // 5å€‹(é ‚ç‚¹åº§æ¨™(x,y,z)ã€uvåº§æ¨™(u,v))ã®å€¤ã‚’æŒã¤é ‚ç‚¹ç”¨ã®é ‚ç‚¹ãƒãƒƒãƒ•ã‚¡ã‚’ä½œæˆ

            vertices = context3D.createVertexBuffer(W*H, 5);

            // é ‚ç‚¹ãƒ‡ãƒ¼ã‚¿ã‚’ã‚¢ãƒƒãƒ—ãƒ­ãƒ¼ãƒ‰

            vertices.uploadFromVector(vertexData, 0, W*H);

            // æœ€åˆã®å±žæ€§ã¯åº§æ¨™ã®æƒ…å ±ï¼šFloatåž‹ã®æ•°å€¤ãŒ3ã¤ã€€ã“ã‚Œã‚’å±žæ€§ãƒ¬ã‚¸ã‚¹ã‚¿0ã«å…¥ã‚Œã‚‹

            context3D.setVertexBufferAt(0, vertices, 0, Context3DVertexBufferFormat.FLOAT_3);

            // uvæƒ…å ± Floatåž‹ãŒ2ã¤ã€€ã“ã‚Œã‚’å±žæ€§ãƒ¬ã‚¸ã‚¹ã‚¿1ã«å…¥ã‚Œã‚‹

            context3D.setVertexBufferAt(1, vertices, 3, Context3DVertexBufferFormat.FLOAT_2);

            //ã‚¤ãƒ³ãƒ‡ãƒƒã‚¯ã‚¹ãƒãƒƒãƒ•ã‚¡ã‚’ä½œæˆ

            indices = context3D.createIndexBuffer(indexData.length);

            //ã‚¤ãƒ³ãƒ‡ãƒƒã‚¯ã‚¹æƒ…å ±ã‚’ã‚¢ãƒƒãƒ—ãƒ­ãƒ¼ãƒ‰

            indices.uploadFromVector(indexData, 0, indexData.length);

            

            var texture:Texture = context3D.createTexture(512, 512, Context3DTextureFormat.BGRA, false);

            

            var loader:Loader = imageArray.pop();

            var bmpd:BitmapData=new BitmapData(512, 512);

            

            bmpd.draw(loader, new Matrix(512/loader.width, 0,0,512/loader.height));

            texture.uploadFromBitmapData(bmpd);

            //fs0ã«è¨­å®š

            context3D.setTextureAt(0, texture);

            

            //ãƒ¬ã‚¸ã‚¹ã‚¿ã«ç™»éŒ²

            context3D.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, new Matrix3D());

            

            addEventListener(Event.ENTER_FRAME, onEnterFrame);

        }

        

        private function onContext3DCreate(event:Event):void

        {

            context3D = Stage3D(event.target).context3D;

            

            context3D.enableErrorChecking = true;

            context3D.configureBackBuffer(WIDTH, HEIGHT, 2, false);

            

            // é ‚ç‚¹ã‚·ã‚§ãƒ¼ãƒ€ã‚’ã‚³ãƒ³ãƒ‘ã‚¤ãƒ«;

            var vertexAssembly:AGALMiniAssembler = new AGALMiniAssembler();

            vertexAssembly.assemble(Context3DProgramType.VERTEX, VERTEX_SHADER);

            // ãƒ”ã‚¯ã‚»ãƒ«ã‚·ã‚§ãƒ¼ãƒ€ã‚’ã‚³ãƒ³ãƒ‘ã‚¤ãƒ«;

            var fragmentAssembly:AGALMiniAssembler = new AGALMiniAssembler();

            fragmentAssembly.assemble(Context3DProgramType.FRAGMENT, FRAGMENT_SHADER);

            

            var programPair:Program3D;

            // Program3Dã®ã‚¤ãƒ³ã‚¹ã‚¿ãƒ³ã‚¹ã‚’å–å¾—

            programPair = context3D.createProgram();

            // é ‚ç‚¹ã‚·ã‚§ãƒ¼ãƒ€ã¨ãƒ”ã‚¯ã‚»ãƒ«ã‚·ã‚§ãƒ¼ãƒ€ã®ã‚³ãƒ¼ãƒ‰ã‚’GPUã«ã‚¢ãƒƒãƒ—ãƒ­ãƒ¼ãƒ‰

            programPair.upload(vertexAssembly.agalcode, fragmentAssembly.agalcode);

            // ä½¿ç”¨ã™ã‚‹ã‚·ã‚§ãƒ¼ãƒ€ã®ãƒšã‚¢ã‚’æŒ‡å®š;

            context3D.setProgram(programPair);

            

//            initVertex();

            SequentialLoader.loadImages(["http://assets.wonderfl.net/images/related_images/3/36/3605/3605f29686918e48eefff9cc0a4f93002777b3de"], imageArray, initVertex);

        }

        

        private function onEnterFrame(e:Event):void{

            // drawTriangles()ã‚’å‘¼ã¶å‰ã«å¿…ãšãƒãƒƒãƒ•ã‚¡ã‚’ã‚¯ãƒªã‚¢;

            context3D.clear(0, 0, 0);

            

            doPuyo(mouseX/stage.stageWidth*2.0-1.0, -(mouseY/stage.stageHeight*2.0-1.0), 300.0);

            for(var i:int = 0; i < H; i++){

                for(var j:int = 0; j < W; j++){

                    var x:Number = vertexData[(i*W+j)*5], y:Number = vertexData[(i*W+j)*5+1];

                    var fx:Number = forces[(i*W+j)*2], fy:Number = forces[(i*W+j)*2+1];

                    fx = fx*a + (j*MASSW-1.0-x)*k;

                    fy = fy*a + (-(i*MASSH-1.0)-y)*k;

                    x += fx/10;

                    y += fy/10;

                    

                    vertexData[(i*W+j)*5] = x;

                    vertexData[(i*W+j)*5+1] = y;

                    forces[(i*W+j)*2] = fx;

                    forces[(i*W+j)*2+1] = fy;

                }

            }

            

            // é ‚ç‚¹ãƒ‡ãƒ¼ã‚¿ã‚’ã‚¢ãƒƒãƒ—ãƒ­ãƒ¼ãƒ‰

            vertices.uploadFromVector(vertexData, 0, W*H);

            

            // 3è§’å½¢ã‚’å…¨ã¦æç”»ã™ã‚‹;

            context3D.drawTriangles(indices, 0, -1);

            //ãƒ“ãƒ¥ãƒ¼ãƒãƒ¼ãƒˆã«è¡¨ç¤º;

            context3D.present();

        }

        

        //æŒ‡å®šã—ãŸåº§æ¨™ã‚’ä¸­å¿ƒã«ãƒ—ãƒ«ãƒ—ãƒ«ã•ã›ã‚‹ã€‚

        public function doPuyo(xx:Number, yy:Number, strength:Number):void{

            for(var i:int = 0; i < H; i++){

                for(var j:int = 0; j < W; j++){

                    var x:Number = vertexData[(i*W+j)*5], y:Number = vertexData[(i*W+j)*5+1];

                    var d:Number = new Point(x-xx,y-yy).length*100;

                    //ãƒžã‚¦ã‚¹ã®ä½ç½®ã«å¼•ãå¯„ã›ã‚‹

                    forces[(i*W+j)*2] += ((xx - x)/(d/strength) + (j*MASSW - x)/rep)/30;

                    forces[(i*W+j)*2+1] += ((yy - y)/(d/strength) + (i*MASSH - y)/rep)/30;

                }

            }

        }

    }

}