/**
 * Copyright tarotarorg ( http://wonderfl.net/user/tarotarorg )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/omiw
 */

/**
 * FLARToolKit basic Sample
 * 
 * Copyright (c) tarotarorg
 * 
 * This work complements FLARToolkit, developed by Saqoosha as part of the Libspark project.
 *     http://www.libspark.org/wiki/saqoosha/FLARToolKit
 * FLARToolKit is Copyright (C)2008 Saqoosha,
 * and is ported from NyARToolKit, which is ported from ARToolKit.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Rectangle;
	import flash.media.*;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import org.libspark.flartoolkit.core.FLARCode;
	import org.libspark.flartoolkit.core.param.FLARParam;
	import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
	import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
	import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
	import org.libspark.flartoolkit.support.pv3d.*;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.render.LazyRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;

	public class FLARTKSample extends Sprite
	{
		private var _raster:FLARRgbRaster_BitmapData;
		private var _detector:FLARSingleMarkerDetector;
		private var _video:Video;
		private var _capture:Bitmap;
		private var _renderer:LazyRenderEngine;
		private var _markerNode:FLARBaseNode;
		
		private var _resultMat:FLARTransMatResult;

		private const AR_SCREEN_WIDTH:int = 320;
		private const AR_SCREEN_HEIGHT:int = 240;
		private const SCREEN_WIDTH:int = 640;
		private const SCREEN_HEIGHT:int = 480;
		
		public function FLARTKSample() 
		{
			var webcam:Camera = Camera.getCamera();
			if (!webcam) throw new Error('No webcam!!!!');
			webcam.setMode(AR_SCREEN_WIDTH, AR_SCREEN_HEIGHT, 30);
			_video = new Video(AR_SCREEN_WIDTH, AR_SCREEN_HEIGHT);
			_video.attachCamera(webcam);

			_capture = new Bitmap(new BitmapData(AR_SCREEN_WIDTH, AR_SCREEN_HEIGHT, false, 0), PixelSnapping.AUTO, true);
			_capture.width = SCREEN_WIDTH;
			_capture.height = SCREEN_HEIGHT;
			
			var code:FLARCode = new FLARCode(16, 16);
			code.loadARPatt(" 255 255 255 255 255 255 191   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  87  63  47   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  31   0   0   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  31   0   0   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255  95   0   0   0   0   0   0   0 159 255 255 239 239 239 239\r\n" + 
							" 255  95   0   0   0   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							" 175  65   0   0   0   0   0   0   0 109 175 175 175 175 175 175\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0  71 127 127  15   0   0   0   0  79 127 127 127 127 127 127\r\n" + 
							"   0 143 255 255  31   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							"   0 143 255 255  31   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							" 191 227 255 255 199 191 143   0   0 159 255 255 255 255 207  63\r\n" + 
							" 255 255 255 255 255 255 191   0   0 159 255 255 255 255 191   0\r\n" + 
							" 255 235 223 223 249 255 191   0   0 159 255 255 223 223 171  15\r\n" + 
							" 255  95   0   0 207 255 191   0   0 159 255 255   0   0  63 255\r\n" + 
							" 255 255 255 255 255 255 191   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  87  63  47   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  31   0   0   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  31   0   0   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255  95   0   0   0   0   0   0   0 159 255 255 239 239 239 239\r\n" + 
							" 255  95   0   0   0   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							" 175  65   0   0   0   0   0   0   0 109 175 175 175 175 175 175\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0  71 127 127  15   0   0   0   0  79 127 127 127 127 127 127\r\n" + 
							"   0 143 255 255  31   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							"   0 143 255 255  31   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							" 191 227 255 255 199 191 143   0   0 159 255 255 255 255 207  63\r\n" + 
							" 255 255 255 255 255 255 191   0   0 159 255 255 255 255 191   0\r\n" + 
							" 255 235 223 223 249 255 191   0   0 159 255 255 223 223 171  15\r\n" + 
							" 255  95   0   0 207 255 191   0   0 159 255 255   0   0  63 255\r\n" + 
							" 255 255 255 255 255 255 191   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  87  63  47   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  31   0   0   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255 255 255 255  31   0   0   0   0 159 255 255   0   0   0   0\r\n" + 
							" 255  95   0   0   0   0   0   0   0 159 255 255 239 239 239 239\r\n" + 
							" 255  95   0   0   0   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							" 175  65   0   0   0   0   0   0   0 109 175 175 175 175 175 175\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0  71 127 127  15   0   0   0   0  79 127 127 127 127 127 127\r\n" + 
							"   0 143 255 255  31   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							"   0 143 255 255  31   0   0   0   0 159 255 255 255 255 255 255\r\n" + 
							" 191 227 255 255 199 191 143   0   0 159 255 255 255 255 207  63\r\n" + 
							" 255 255 255 255 255 255 191   0   0 159 255 255 255 255 191   0\r\n" + 
							" 255 235 223 223 249 255 191   0   0 159 255 255 223 223 171  15\r\n" + 
							" 255  95   0   0 207 255 191   0   0 159 255 255   0   0  63 255\r\n" + 
							"\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255  63   0  15 255\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 207 191 171  63\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 255 255 223   0\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255 255 255 175   0   0 127 255 255 255 255 255 255\r\n" + 
							" 255 255 255 255 255 255 175   0   0 127 255 255 255 255 255 255\r\n" + 
							" 159 159 159 159 159 159 109   0   0  79 159 159 159 159 159 159\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 191  47   0   0   0   0   0   0   0   0   0   0 143 191 191 191\r\n" + 
							" 255  63   0   0   0   0   0   0   0   0   0   0 191 255 255 255\r\n" + 
							" 255  87  31  31   0   0   0   0   0  15  31  31 199 255 249 207\r\n" + 
							" 255 255 255 255   0   0   0   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255   0   0   0   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255  95  95  65   0   0  71 143 143 227 255 235  95\r\n" + 
							" 255 255 255 255 255 255 175   0   0   0   0   0 191 255 255 255\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255  63   0  15 255\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 207 191 171  63\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 255 255 223   0\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255 255 255 175   0   0 127 255 255 255 255 255 255\r\n" + 
							" 255 255 255 255 255 255 175   0   0 127 255 255 255 255 255 255\r\n" + 
							" 159 159 159 159 159 159 109   0   0  79 159 159 159 159 159 159\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 191  47   0   0   0   0   0   0   0   0   0   0 143 191 191 191\r\n" + 
							" 255  63   0   0   0   0   0   0   0   0   0   0 191 255 255 255\r\n" + 
							" 255  87  31  31   0   0   0   0   0  15  31  31 199 255 249 207\r\n" + 
							" 255 255 255 255   0   0   0   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255   0   0   0   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255  95  95  65   0   0  71 143 143 227 255 235  95\r\n" + 
							" 255 255 255 255 255 255 175   0   0   0   0   0 191 255 255 255\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255  63   0  15 255\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 207 191 171  63\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 255 255 223   0\r\n" + 
							"   0   0   0   0 239 255 175   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255 255 255 175   0   0 127 255 255 255 255 255 255\r\n" + 
							" 255 255 255 255 255 255 175   0   0 127 255 255 255 255 255 255\r\n" + 
							" 159 159 159 159 159 159 109   0   0  79 159 159 159 159 159 159\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 191  47   0   0   0   0   0   0   0   0   0   0 143 191 191 191\r\n" + 
							" 255  63   0   0   0   0   0   0   0   0   0   0 191 255 255 255\r\n" + 
							" 255  87  31  31   0   0   0   0   0  15  31  31 199 255 249 207\r\n" + 
							" 255 255 255 255   0   0   0   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255   0   0   0   0   0 127 255 255 255 255 223   0\r\n" + 
							" 255 255 255 255  95  95  65   0   0  71 143 143 227 255 235  95\r\n" + 
							" 255 255 255 255 255 255 175   0   0   0   0   0 191 255 255 255\r\n" + 
							"\r\n" + 
							" 255  63   0   0 255 255 159   0   0 191 255 207   0   0  95 255\r\n" + 
							"  15 171 223 223 255 255 159   0   0 191 255 249 223 223 235 255\r\n" + 
							"   0 191 255 255 255 255 159   0   0 191 255 255 255 255 255 255\r\n" + 
							"  63 207 255 255 255 255 159   0   0 143 191 199 255 255 227 191\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0  31 255 255 143   0\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0  31 255 255 143   0\r\n" + 
							" 127 127 127 127 127 127  79   0   0   0   0  15 127 127  71   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 175 175 175 175 175 175 109   0   0   0   0   0   0   0  65 175\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0   0   0   0  95 255\r\n" + 
							" 239 239 239 239 255 255 159   0   0   0   0   0   0   0  95 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0   0   0  31 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0   0   0  31 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0  47  63  87 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0 191 255 255 255 255 255 255\r\n" + 
							" 255  63   0   0 255 255 159   0   0 191 255 207   0   0  95 255\r\n" + 
							"  15 171 223 223 255 255 159   0   0 191 255 249 223 223 235 255\r\n" + 
							"   0 191 255 255 255 255 159   0   0 191 255 255 255 255 255 255\r\n" + 
							"  63 207 255 255 255 255 159   0   0 143 191 199 255 255 227 191\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0  31 255 255 143   0\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0  31 255 255 143   0\r\n" + 
							" 127 127 127 127 127 127  79   0   0   0   0  15 127 127  71   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 175 175 175 175 175 175 109   0   0   0   0   0   0   0  65 175\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0   0   0   0  95 255\r\n" + 
							" 239 239 239 239 255 255 159   0   0   0   0   0   0   0  95 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0   0   0  31 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0   0   0  31 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0  47  63  87 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0 191 255 255 255 255 255 255\r\n" + 
							" 255  63   0   0 255 255 159   0   0 191 255 207   0   0  95 255\r\n" + 
							"  15 171 223 223 255 255 159   0   0 191 255 249 223 223 235 255\r\n" + 
							"   0 191 255 255 255 255 159   0   0 191 255 255 255 255 255 255\r\n" + 
							"  63 207 255 255 255 255 159   0   0 143 191 199 255 255 227 191\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0  31 255 255 143   0\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0  31 255 255 143   0\r\n" + 
							" 127 127 127 127 127 127  79   0   0   0   0  15 127 127  71   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 175 175 175 175 175 175 109   0   0   0   0   0   0   0  65 175\r\n" + 
							" 255 255 255 255 255 255 159   0   0   0   0   0   0   0  95 255\r\n" + 
							" 239 239 239 239 255 255 159   0   0   0   0   0   0   0  95 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0   0   0  31 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0   0   0  31 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0  47  63  87 255 255 255 255\r\n" + 
							"   0   0   0   0 255 255 159   0   0 191 255 255 255 255 255 255\r\n" + 
							"\r\n" + 
							" 255 255 255 191   0   0   0   0   0 175 255 255 255 255 255 255\r\n" + 
							"  95 235 255 227 143 143  71   0   0  65  95  95 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0   0   0   0 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0   0   0   0 255 255 255 255\r\n" + 
							" 207 249 255 199  31  31  15   0   0   0   0   0  31  31  87 255\r\n" + 
							" 255 255 255 191   0   0   0   0   0   0   0   0   0   0  63 255\r\n" + 
							" 191 191 191 143   0   0   0   0   0   0   0   0   0   0  47 191\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 159 159 159 159 159 159  79   0   0 109 159 159 159 159 159 159\r\n" + 
							" 255 255 255 255 255 255 127   0   0 175 255 255 255 255 255 255\r\n" + 
							" 255 255 255 255 255 255 127   0   0 175 255 255 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							"   0 223 255 255 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							"  63 171 191 207 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							" 255  15   0  63 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							" 255 255 255 191   0   0   0   0   0 175 255 255 255 255 255 255\r\n" + 
							"  95 235 255 227 143 143  71   0   0  65  95  95 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0   0   0   0 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0   0   0   0 255 255 255 255\r\n" + 
							" 207 249 255 199  31  31  15   0   0   0   0   0  31  31  87 255\r\n" + 
							" 255 255 255 191   0   0   0   0   0   0   0   0   0   0  63 255\r\n" + 
							" 191 191 191 143   0   0   0   0   0   0   0   0   0   0  47 191\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 159 159 159 159 159 159  79   0   0 109 159 159 159 159 159 159\r\n" + 
							" 255 255 255 255 255 255 127   0   0 175 255 255 255 255 255 255\r\n" + 
							" 255 255 255 255 255 255 127   0   0 175 255 255 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							"   0 223 255 255 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							"  63 171 191 207 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							" 255  15   0  63 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							" 255 255 255 191   0   0   0   0   0 175 255 255 255 255 255 255\r\n" + 
							"  95 235 255 227 143 143  71   0   0  65  95  95 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0   0   0   0 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0   0   0   0 255 255 255 255\r\n" + 
							" 207 249 255 199  31  31  15   0   0   0   0   0  31  31  87 255\r\n" + 
							" 255 255 255 191   0   0   0   0   0   0   0   0   0   0  63 255\r\n" + 
							" 191 191 191 143   0   0   0   0   0   0   0   0   0   0  47 191\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							"   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\r\n" + 
							" 159 159 159 159 159 159  79   0   0 109 159 159 159 159 159 159\r\n" + 
							" 255 255 255 255 255 255 127   0   0 175 255 255 255 255 255 255\r\n" + 
							" 255 255 255 255 255 255 127   0   0 175 255 255 255 255 255 255\r\n" + 
							"   0 223 255 255 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							"   0 223 255 255 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							"  63 171 191 207 255 255 127   0   0 175 255 239   0   0   0   0\r\n" + 
							" 255  15   0  63 255 255 127   0   0 175 255 239   0   0   0   0\r\n");

			var param:FLARParam = new FLARParam();
			param.changeScreenSize(AR_SCREEN_WIDTH, AR_SCREEN_HEIGHT);

			_raster = new FLARRgbRaster_BitmapData(_capture.bitmapData);
			_resultMat = new FLARTransMatResult();
			_detector = new FLARSingleMarkerDetector(param, code, 80);
			_detector.setContinueMode(true);

			var base:Sprite = addChild(new Sprite()) as Sprite;
			base.addChild(_capture);
			
			var viewport:Viewport3D = base.addChild(new Viewport3D(AR_SCREEN_WIDTH, AR_SCREEN_HEIGHT)) as Viewport3D;
			viewport.scaleX = SCREEN_WIDTH / AR_SCREEN_WIDTH;
			viewport.scaleY = SCREEN_HEIGHT / AR_SCREEN_HEIGHT;
			viewport.x = -4;
			
			var camera3d:FLARCamera3D = new FLARCamera3D(param);
			
			var scene:Scene3D = new Scene3D();
			_markerNode = scene.addChild(new FLARBaseNode()) as FLARBaseNode;
			
			var light:PointLight3D = new PointLight3D();
			light.x = 0;
			light.y = 1000;
			light.z = -1000;

			var fmat:FlatShadeMaterial = new FlatShadeMaterial(light, 0xff22aa, 0x75104e);
			var cube:Cube = new Cube(new MaterialsList( { all:fmat } ), 40, 40, 40);
			cube.z = 20;
			_markerNode.addChild(cube);
			_renderer = new LazyRenderEngine(scene, camera3d, viewport);
			addEventListener(Event.ENTER_FRAME, _onEnterFrame);
		}

		private function _onEnterFrame(e:Event = null):void {
			_capture.bitmapData.draw(_video);
			try {
				if (_detector.detectMarkerLite(_raster, 80) && _detector.getConfidence() > 0.5) {
					_detector.getTransformMatrix(_resultMat);
					_markerNode.setTransformMatrix(_resultMat);
					_markerNode.visible = true;
				} else {
					_markerNode.visible = false;
				}
			} catch (e:Error) {}
			_renderer.render();
		}
	}
}
