/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/omaF
 */

package
{
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class StaffRoll extends Sprite
	{
		private var _player:Object;
		private var _loader:Loader;
		private var _base:Sprite;
		private var _speed:Number;
		
		public function StaffRoll()
		{
			Security.allowDomain("*");
			if(stage)
				init();
			else
				addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event = null):void
		{
			stage.frameRate = 30;
			stage.scaleMode = StageScaleMode.SHOW_ALL;
			
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
			_loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
		}
		
		private function onLoaderInit(event:Event):void
		{
			_loader.content.addEventListener("onError", onPlayerError);
			_loader.content.addEventListener("onReady", onPlayerReady);
			_loader.content.addEventListener("onStateChange", onPlayerStateChange);
		}
		
		private function onPlayerError(event:Event):void
		{
			trace("動画が対応してない");
		}
		
		private function onPlayerStateChange(event:Event):void {
			if(Object(event).data == 5)
			{
				if(!hasEventListener(Event.ENTER_FRAME))
					addEventListener(Event.ENTER_FRAME, onVideoLoad);
			}
			if(Object(event).data == 1)
			{
				_speed = (_base.height + stage.stageHeight + stage.stageHeight / 1.5) / _player.getDuration() / stage.frameRate;
				addEventListener(Event.ENTER_FRAME, onPlay);
			}
			if(Object(event).data == 0)
			{
				removeEventListener(Event.ENTER_FRAME, onPlay);
				var tf:TextField = new TextField();
				tf.text = "Bye.";
				tf.x = stage.stageWidth / 2 - tf.textWidth / 2;
				tf.y = stage.stageHeight / 2 - tf.textHeight / 2;
				addChild(tf);
			}
		}
		
		private function onPlayerReady(event:Event):void
		{
			_player = _loader.content;
			
//			var loader:URLLoader = new URLLoader();
//			loader.addEventListener(Event.COMPLETE, onCreditsLoaded);
//			loader.load(new URLRequest("staff.xml"));
			onCreditsLoaded();
		}
		
//		private function onCreditsLoaded(event:Event):void
//		{
//			var xml:XML = XML(event.target.data);
		private function onCreditsLoaded():void
		{
			var xml:XML = <stafflist><staff><credit>Project Lead</credit><name>aaharu</name></staff><staff><credit>Executive Producer</credit><name>aaharu</name></staff><staff><credit>Producer</credit><name>aaharu</name></staff><staff><credit>Producer</credit><name>aaharu</name></staff><staff><credit>Director</credit><name>aaharu</name></staff><staff><credit>Chief Coordinator</credit><name>aaharu</name></staff><staff><credit>Coordinator</credit><name>aaharu</name></staff><staff><credit>Chief Planner</credit><name>aaharu</name></staff><staff><credit>Planner</credit><name>aaharu</name></staff><staff><credit>Chief Programmer</credit><name>aaharu</name></staff><staff><credit>Programmer</credit><name>aaharu</name></staff><staff><credit>Special Thanks</credit><name>aaharu</name></staff><staff><credit>Music</credit><name>NOT aaharu</name></staff></stafflist>;
			var len:uint = xml.staff.length();
			
			_base = new Sprite();
			_base.x = stage.stageWidth / 2;
			_base.y = stage.stageHeight;
			addChild(_base);
			
			var creditStyle:TextFormat = new TextFormat(null, 10);
			var nameStyle:TextFormat = new TextFormat(null, 18);
			for(var i:uint = 0; i < len; i++)
			{
				var credit:TextField = new TextField();
				credit.text = xml.staff[i].credit;
				credit.setTextFormat(creditStyle);
				credit.x = -credit.textWidth;
				credit.y = stage.stageHeight * i + stage.stageHeight / 2 - credit.textHeight;
				_base.addChild(credit);
				
				var name:TextField = new TextField();
				name.text = xml.staff[i].name;
				name.setTextFormat(nameStyle);
				name.y = stage.stageHeight * i + stage.stageHeight / 2;
				_base.addChild(name);
			}
			
			_player.cueVideoById("PzZYfzJw8qg");
		}
		
		private function onVideoLoad(event:Event):void
		{
			if(_player.getVideoBytesLoaded() == _player.getVideoBytesTotal())
			{
				_player.playVideo();
				removeEventListener(Event.ENTER_FRAME, onVideoLoad);
			}
		}
		
		private function onPlay(event:Event):void
		{
			_base.y -= _speed;
		}
	}
}