/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/olyx
 */

package 

{

    import flash.display.Sprite;

    import flash.events.Event;

    

    /**

     * ...

     * @author umhr

     */

    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]

    public class WonderflMain extends Sprite 

    {

        

        public function WonderflMain():void 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            // entry point

            

            addChild(new Canvas());

            

        }

        

    }

}

    

    import flash.display.Sprite;

    import flash.events.Event;

    /**

     * ...

     * @author umhr

     */

     class Canvas extends Sprite 

    {

        private var _viewCanvas:ViewCanvas = ViewCanvas.getInstance();

        public function Canvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            

            CameraManager.getInstance().addEventListener(Event.ACTIVATE, activate);

            

            addChild(CameraManager.getInstance());

            

            addChild(_viewCanvas);

        }

        

        private function activate(e:Event):void 

        {

            CameraManager.getInstance().removeEventListener(Event.ACTIVATE, activate);

            

            addEventListener(Event.ENTER_FRAME, enterFrame);

        }

        

        private function enterFrame(e:Event):void 

        {

            _viewCanvas.enterFrame();

        }

    }

    

    

    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.Shape;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.geom.ColorTransform;

    import flash.geom.Matrix;

    /**

     * ...

     * @author umhr

     */

    class ViewCanvas extends Sprite 

    {

        private static var _instance:ViewCanvas;

        public function ViewCanvas(block:Block){init();};

        public static function getInstance():ViewCanvas{

            if ( _instance == null ) {_instance = new ViewCanvas(new Block());};

            return _instance;

        }

        

        private var _bitmap:Bitmap;

        private var _blurBitmap:Bitmap = new Bitmap(new BitmapData(100, 100, true, 0xFFFFFFFF));

        private const FADE:ColorTransform = new ColorTransform(1.1, 1.1, 1.1, 1);

        //private const FADE:ColorTransform = new ColorTransform(1, 1, 1, 1);

        private var _cameraManager:CameraManager = CameraManager.getInstance();

        private function init():void

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            _bitmap = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFF000000));

            addChild(_bitmap);

            

            //_blurBitmap.filters = [new BlurFilter(1,1)];

            

        }

        

        public function enterFrame(e:Event = null):void 

        {

            setBlur();

            setBlur();

            //setBlur();

            //setBlur();

            

            _cameraManager.enter();

            

            drawTextSet();

            

        }

        

        private function setBlur():void 

        {

            var tx:int = Math.random() * 465 - 50;

            var ty:int = Math.random() * 465 - 50;

            

            _blurBitmap.bitmapData.fillRect(_blurBitmap.bitmapData.rect, 0x00000000);

            _blurBitmap.bitmapData.draw(_bitmap, new Matrix(1, 0, 0, 1, -tx, -ty));

            

            _bitmap.bitmapData.draw(_blurBitmap, new Matrix(1, 0, 0, 1, tx, ty), FADE);

        }

        

        private function drawTextSet():void 

        {

            var tx:int;

            var ty:int;

            var n:int = 100;

            for (var i:int = 0; i < n; i++) 

            {

                tx = 465 * Math.random();

                ty = 465 * Math.random();

                drawText(tx, ty);

            }

        }

        

        private var _charctor:Bitmap;

        private function drawText(tx:int,ty:int):void 

        {

            var rgb:int = _cameraManager.getPixel(tx, ty);

            

            if (_charctor) {

                var scale:Number = Math.random()*0.8 + 0.1;

                _bitmap.bitmapData.draw(_charctor, new Matrix(scale, 0, 0, scale, tx-10, ty-10),Utils.colorFromRGB(rgb),null,null,true);

            }else {

                var shape:Shape = new Shape();

                shape.graphics.beginFill(0x0);

                shape.graphics.drawCircle(10, 10, 10);

                shape.graphics.endFill();

                

                _charctor = new Bitmap(new BitmapData(20, 20, true, 0x0));

                _charctor.bitmapData.draw(shape);

                

            }

            

        }

        

    }

    

class Block { };



    import flash.display.BitmapData;

    import flash.display.IBitmapDrawable;

    import flash.display.Sprite;

    import flash.events.ActivityEvent;

    import flash.events.Event;

    import flash.media.Camera;

    import flash.media.Video;

    /**

     * ...

     * @author umhr

     */

    class CameraManager extends Sprite

    {

        private static var _instance:CameraManager;

        public function CameraManager(block:Block){init();}

        public static function getInstance():CameraManager{

            if ( _instance == null ) {_instance = new CameraManager(new Block());};

            return _instance;

        }

        

        private var _video:Video = new Video();

        private var _bitmapData:BitmapData;

        private var _scale:Number = 1;

        public var activating:Boolean = false;

        private var _count:uint = 0;

        private var _dx:Number = 0;

        private var _dy:Number = 0;

        private function init():void

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }

        

        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            var camera:Camera = Camera.getCamera();

            //カメラの存在を確認

            if (camera) {

                camera.setMode(320, 240, 15);

                camera.addEventListener(ActivityEvent.ACTIVITY, camera_activity);

                _video.attachCamera(camera);

                _scale = Math.min(320 / stage.stageWidth, 240 / stage.stageHeight);

                _dx = (320 - stage.stageWidth * _scale) * 0.5;

                _dy = (240 - stage.stageHeight * _scale) * 0.5;

                

                _bitmapData = new BitmapData(320, 240);

                dispatchEvent(new Event(Event.ACTIVATE));

            } else {

                trace("カメラが見つかりませんでした。");

            }

        }

        

        private function camera_activity(event:ActivityEvent):void 

        {

            activating = true;

        }

        

        /**

         * カメラで取得した結果を_bitmapDataに保持する。

         */

        public function enter():void {

            if (!activating) { return };

            if (_count % 4 == 0) {

                _bitmapData.draw(_video);

            }

            _count ++;

        }

        

        public function getVideo():Video {

            return _video;

        }

        

        /**

         * 対応する座標の色を返す。

         * @param    x

         * @param    y

         * @return

         */

        public function getPixel(x:int, y:int):int {

            if (!activating) { return 0x0 };

            var tx:int = x * _scale + _dx;

            var ty:int = y * _scale + _dy;

            return _bitmapData.getPixel(tx, ty);

        }

    }

    



    import flash.geom.ColorTransform;

    //Dump

    import flash.utils.getQualifiedClassName;

    

    //zSort

    import flash.display.DisplayObjectContainer;

    import flash.geom.PerspectiveProjection;

    import flash.geom.Point;

    import flash.geom.Vector3D;

    import flash.geom.Matrix;

     class Utils {

        public function Utils():void { };

        /**

         * フィールドカラーに変色します.

         * 6桁16進数から、2桁ぶんずつを取り出す。 

         * 色情報は24bit。r8bit+g8bit+b8bit。24桁の二進数 

         * @param    rgb

         * @param    ratio

         * @return

         */

        static public function colorFromRGB(rgb:int, ratio:Number = 1):ColorTransform {    

            //ratioが1以外の場合、明度変更関数へ

            if(ratio != 1){rgb = rgbBrightness(rgb,ratio)};

            var color:ColorTransform = new ColorTransform();

            color.redMultiplier = color.blueMultiplier = color.greenMultiplier = 0;

            color.redOffset = rgb >> 16;//16bit右にずらす。

            color.greenOffset = rgb >> 8 & 0xff;//8bit右にずらして、下位8bitのみを取り出す。

            color.blueOffset = rgb & 0xff;//下位8bitのみを取り出す。

            return color;

        }

        /*

        色の明度を相対的に変える関数。

        rgb値と割合を与えて、結果を返す。

        rgbは、0xffffff段階の値。

        ratioが0の時に0x000000に、1の時にそのまま、2の時には0xffffffになる。

        相対的に、ちょっと暗くしたい時には、ratioを0.8に、

        ちょっと明るくしたい時にはratioを1.2などに設定する。

        */

        static public function rgbBrightness(rgb:int,ratio:Number):int{

            if(ratio < 0 || 2 < ratio){ratio = 1;trace("function colorBrightness 範囲外")}

            var _r:int = rgb >> 16;//16bit右にずらす。

            var _g:int = rgb >> 8 & 0xff;//8bit右にずらして、下位8bitのみを取り出す。

            var _b:int = rgb & 0xff;//下位8bitのみを取り出す。

            if(ratio <= 1){

                _r *= ratio;

                _g *= ratio;

                _b *= ratio;

            }else{

                _r = (255 - _r)*(ratio-1)+_r;

                _g = (255 - _g)*(ratio-1)+_g;

                _b = (255 - _b)*(ratio-1)+_b;

            }

            return _r<<16 | _g<<8 | _b;

        }

        //shuffle

        static public function shuffle(num:int):Array {

            var _array:Array = new Array();

            for (var i:int = 0; i < num; i++) {    

                _array[i] = Math.random();

            }

            return _array.sort(Array.RETURNINDEXEDARRAY);

        }

        //Dump

        static public function dump(obj:Object, isTrace:Boolean = true):String {

            var str:String = returnDump(obj)

            if (isTrace) {

                trace(str);

            }

            return str;

        }

        static public function returnDump(obj:Object):String {

            var str:String = _dump(obj);

            if (str.length == 0) {

                str = String(obj);

            }else if (getQualifiedClassName(obj) == "Array") {

                str = "[\n" + str.slice( 0, -2 ) + "\n]";

            }else {

                str = "{\n" + str.slice( 0, -2 ) + "\n}";

            }

            return str;

        }

        

        static public function traceDump(obj:Object):void {

            trace(returnDump(obj));

        }

        

        //zSort

        static private function _dump(obj:Object, indent:int = 0):String {

            var result:String = "";

            

            var da:String = (getQualifiedClassName(obj) == "Array")?'':'"';

            

            var tab:String = "";

            for ( var i:int = 0; i < indent; ++i ) {

                tab += "    ";

            }

            

            for (var key:String in obj) {

                if (typeof obj[key] == "object") {

                    var type:String = getQualifiedClassName(obj[key]);

                    if (type == "Object" || type == "Array") {

                        result += tab + da + key + da + ":"+((type == "Array")?"[":"{");

                        var dump_str:String = _dump(obj[key], indent + 1);

                        if (dump_str.length > 0) {

                            result += "\n" + dump_str.slice(0, -2) + "\n";

                            result += tab;

                        }

                        result += (type == "Array")?"],\n":"},\n";

                    }else {

                        result += tab + '"' + key + '":<' + type + ">,\n";

                    }

                }else if (typeof obj[key] == "function") {

                    result += tab + '"' + key + '":<Function>,\n';

                }else {

                    var dd:String = (typeof obj[key] == "string")?"'":"";

                    result += tab + da + key + da + ":" + dd + obj[key] +dd + ",\n";

                }

            }            

            return result;

        }

        static public function zSort(target:DisplayObjectContainer, generation:int = 2):void {

            if(generation == 0 || !target.root){return};

            var n:int = target.numChildren;

            var array:Array = [];

            var reference:Array = [];

            for (var i:int = 0; i < n; i++) {

                if (target.getChildAt(i).transform.matrix3D) {

                    var poz:Vector3D = target.getChildAt(i).transform.getRelativeMatrix3D(target.root.stage).position;

                    var point:Point = target.root.stage.transform.perspectiveProjection.projectionCenter;

                    array[i] = poz.subtract(new Vector3D(point.x, point.y, -target.root.stage.transform.perspectiveProjection.focalLength)).length;

                    reference[i] = target.getChildAt(i);

                }

            }

            var temp:Array = array.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);

            for (i = 0; i < n; i++) {

                if (target.getChildAt(i).transform.matrix3D) {

                    target.setChildIndex(reference[temp[i]],0);

                    if(reference[temp[i]].numChildren > 1){

                        zSort(reference[temp[i]], generation - 1);

                    }

                }

            }

            //return;

            for (i = 0; i < n; i++) {

                if (target.getChildAt(i).transform.matrix3D) {

                    target.getChildAt(i).visible = (target.getChildAt(i).transform.getRelativeMatrix3D(target.root.stage).position.z > -400);

                }

            }

        }

    }



