/**
 * Copyright muta244 ( http://wonderfl.net/user/muta244 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/olii
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 500000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var array1:Array = new function ():Array
        {
            var temp:Array = [];
            for (var i:uint = 0; i < 1; i++) {
                temp.push(i);
            }
            return temp;
        };
        
        var array2:Array = new function ():Array
        {
            var temp:Array = [];
            for (var i:uint = 0; i < 100; i++) {
                temp.push(i);
            }
            return temp;
        };
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("1 個の要素を含む配列で indexOf(最初の要素)", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                array1.indexOf(0);
            }
        });
        
        _measure("100 個の要素を含む配列で indexOf(最初の要素)", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                array2.indexOf(0);
            }
        });
        
        _measure("100 個の要素を含む配列で indexOf(真ん中の要素)", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                array2.indexOf(49);
            }
        });
        
        _measure("100 個の要素を含む配列で indexOf(最後の要素)", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                array2.indexOf(99);
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
