/**
 * Copyright Henry.Tseng ( http://wonderfl.net/user/Henry.Tseng )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/olK9
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.AntiAliasType;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.display.Shape;
    
    public class CanvasType extends Sprite {
        private var _HiraginoKaku:FontEmbed;  
        
        // paper
        private var _paper : Bitmap;
        private var _paperData : BitmapData;
        
        // scratch
        private var _scratchFieldLine : Shape;
        private var _scratchField : TextField;
        private var _scratchFormat : TextFormat;
        
        // ui
        private var _clearBtn : Sprite;
        
        // point
        private var _lastP : Point;
        private var _dp : Point;
        private var _ds : Number;
        
        public function CanvasType() {
            _initFonts();
            
        }
        
        private function _initFonts():void {
            _HiraginoKaku = new FontEmbed("http://www.digifie.jp/files/HiraginoKakuW6.swf", "HirakakuW6");
            _HiraginoKaku.addEventListener(FontEmbed.FONT_LOADED, _onFontLoaded);
        }
        
        private function _onFontLoaded($e:Event):void {
            _initDrawing();
            _initButtons();
            
            _HiraginoKaku.embetedFont(_scratchField, "Hiragino Kaku Gothic Pro W6", 18, _scratchFormat);
            _HiraginoKaku.removeEventListener(FontEmbed.FONT_LOADED, _onFontLoaded);
        }
        
        private function _initButtons():void {
            addChild(_scratchFieldLine = new Shape());
            
            addChild(_clearBtn = new Sprite());
            _clearBtn.x = 10;
            _clearBtn.y = 10;
            var label:TextField = new TextField();
            var fmt:TextFormat = new TextFormat();
            fmt.color = 0xffffff;
            fmt.font = 'Helvetica';
            fmt.size = 11;
            label.embedFonts = false;
            label.defaultTextFormat = fmt;
            label.background = true;
            label.backgroundColor = 0x0;
            label.selectable = false;
            label.antiAliasType = AntiAliasType.NORMAL;
            label.autoSize = TextFieldAutoSize.LEFT;
            label.text = 'clear';
            _clearBtn.addChild(label);
            _clearBtn.addEventListener(MouseEvent.CLICK, _clickClear);
        }
        
        private function _clickClear($e:MouseEvent):void {
            _paperData.fillRect(_paperData.rect, 0xffffff);
            _scratchFieldLine.graphics.clear();
            _lastP = null;
        }
        
        private function _initDrawing():void {
            _paperData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff);
            _paper = new Bitmap(_paperData);
            
            addChild(_scratchField = new TextField());
            _scratchField.embedFonts = true;
            _scratchField.defaultTextFormat = _scratchFormat = new TextFormat();
            _scratchField.selectable = false;
            
            var paperContainer:Sprite = new Sprite();
            addChild(paperContainer);
            paperContainer.addChild(_paper);
            paperContainer.addEventListener(MouseEvent.MOUSE_DOWN, _onStart);
            paperContainer.addEventListener(MouseEvent.MOUSE_UP, _onStop);
        }
        
        private function _onStart($e:MouseEvent):void {
            _lastP = null;
            addEventListener(MouseEvent.MOUSE_MOVE, _onUpdate);
        }
        
        private function _onStop($e:MouseEvent):void {
            _lastP = null;
            removeEventListener(MouseEvent.MOUSE_MOVE, _onUpdate);
        }
        
        private function _onUpdate($e:MouseEvent):void {
            if(_lastP == null) {
                _lastP = new Point(this.mouseX, this.mouseY);
                return;
            }
            
            // displacement
            _dp = new Point(mouseX-_lastP.x, mouseY-_lastP.y);
            _ds = _dp.length;
            
            _getNextLetter();
            //_renderLine();
            _renderType();
            
            // update last location
            _lastP.x = this.mouseX;
            _lastP.y = this.mouseY;
        }
        
        private function _renderLine():void {
            _scratchFieldLine.graphics.lineStyle(0, 0x0, .25);
            _scratchFieldLine.graphics.moveTo(_lastP.x, _lastP.y);
            _scratchFieldLine.graphics.lineTo(_lastP.x+_dp.x, _lastP.y+_dp.y);
        }
        
        private function _getNextLetter():void {
            var letters:String = 'abcdefghijklmnopqrstuvwxyz';
            _scratchField.text = letters.charAt(Math.floor(letters.length * Math.random()));
        }
        
        private function _renderType():void {
            //trace('dp:'+_dp);
            var s:Number = ((_dp.x/_scratchField.width > _dp.y/_scratchField.height) ? _dp.x/_scratchField.width : _dp.y/_scratchField.height) * 15;
            var m:Matrix = new Matrix();
            var r:Number = Math.atan2(_dp.y, _dp.x);
            m.scale(s, s);
            m.rotate(r);
            m.tx = _lastP.x;
            m.ty = _lastP.y;
            
            _paperData.draw(_scratchField, m);
        }
    }
}

//class FontEnbed
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.net.URLLoader;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.Font;
import flash.system.LoaderContext;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.Security;

class FontEmbed extends EventDispatcher {

    private var _fontClassName:String
    private var _loader:Loader = new Loader()
    public var progress:int
    
    public static const FONT_LOADED:String = "font_loaded";
    
    public function FontEmbed(fontPath:String, fontClassName:String) {
        Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
        Security.allowDomain("www.digifie.jp");
        swfLoad(fontPath);
        _fontClassName = fontClassName;
    }
    
    //Load FontSwf
    private function swfLoad(fontPath:String):void{
        var context:LoaderContext = new LoaderContext(); 
        context.checkPolicyFile = true;
        context.securityDomain = SecurityDomain.currentDomain; 
        context.applicationDomain = ApplicationDomain.currentDomain;
        var req:URLRequest = new URLRequest(fontPath);
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfLoadComplete);
        _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,onProgressListener);
        _loader.load(req, context);
    }
    
    //Progress
    private function onProgressListener(e:ProgressEvent):void {
        progress = e.bytesLoaded/e.bytesTotal*100;
    }
    
    //Load Complete
    private function swfLoadComplete(e:Event):void {
        _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,swfLoadComplete);
        _loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressListener);
        var fontClass:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition(_fontClassName) as Class; 
        try{
            Font.registerFont(fontClass);
        }catch(e:Error){
            //
        }
        dispatchEvent(new Event(FontEmbed.FONT_LOADED));
    }
    
    //Embeted Font
    public function embetedFont(txt:TextField, fontname:String, size:Number, fmt:TextFormat):void {
        var tfmt:TextFormat = fmt
        tfmt.font = fontname;
        tfmt.size = size;
        txt.embedFonts = true;
        txt.defaultTextFormat = tfmt;
    }
}
