/**
 * Copyright akkey.guitar ( http://wonderfl.net/user/akkey.guitar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/olHq
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
 
    public class Main extends Sprite
    {
        private var sound:Sound;
        private var ba:ByteArray = new ByteArray();
        private const WIDTH:Number = 465;
        private const HEIGHT:Number = 232.5;
 
        public function Main()
        {
            sound = new Sound(new URLRequest("music.mp3"));
            sound.play();
 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
        private function onEnterFrame(event:Event):void 
        {
            SoundMixer.computeSpectrum(ba, false, 6);
 
            graphics.clear();
            graphics.lineStyle(1.0);
            graphics.moveTo(0, HEIGHT);
            for (var i:int = 0; i < 256; i++)
            {
                var value:Number = ba.readFloat();
                graphics.lineTo(WIDTH / 256 * i, HEIGHT - HEIGHT * value);
            }
        }
    }
}