/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/okjR
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	public class Main extends Sprite {
		private var canvas:BitmapData;
		private var canvasRect:Rectangle;
		private var ballBm:BitmapData;
		private var ballSize:int = 100;
		private var threthold:int;
		private var balls:Array;
		private var numBalls:uint = 100;
		
		public function Main():void {
			addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight)));
			canvasRect = canvas.rect;
			ballBm = createBallBm();
			init();
		}
		
		private function init():void {
			balls = new Array();
			for (var i:uint = 0; i < numBalls; i ++) {
				balls.push(createBall());
			}
			addEventListener(Event.ENTER_FRAME, h_enterFrame);
		}
		
		private function h_enterFrame(evt:Event):void {
			canvas.fillRect(canvasRect, 0xffffffff);
			for (var i:uint = 0; i < balls.length; i ++) {
				balls[i].x += balls[i].vx;
				balls[i].y += balls[i].vy;
				var mtx:Matrix = new Matrix(1,0,0,1,balls[i].x,balls[i].y);
				canvas.draw(ballBm,mtx);
				if (	balls[i].x < -ballSize / 2 || balls[i].x > stage.stageWidth + ballSize / 2 ||
						balls[i].y < -ballSize / 2 || balls[i].y > stage.stageHeight + ballSize / 2) {
					balls[i] = createBall();
				}
			}
			canvas.threshold(canvas,canvasRect,new Point(0,0),"<=", 0xff555555, 0xffff00ff);
			canvas.threshold(canvas,canvasRect,new Point(0,0),"!=", 0xffff00ff, 0xffffffff);
		}
		
		private function createBall():Object {
			var ball:Object = new Object;
			var ang:Number = Math.PI * 2 * Math.random();
			var spd:Number = Math.random() * 5;
			ball.x = Math.random() * stage.stageWidth;
			ball.y = Math.random() * stage.stageHeight;
			ball.vx = Math.cos(ang) * spd;
			ball.vy = Math.sin(ang) * spd;
			return ball
		}
		
		
		private function createBallBm():BitmapData {
			var bm:BitmapData = new BitmapData(ballSize, ballSize,true,0x00000000);
			var temp:Sprite = new Sprite();
			for (var i:int = ballSize / 2; i > 0; i -= 2) {
				var g:Graphics = temp.graphics;
				g.beginFill(0x000000, 1 / (ballSize / 4));
				g.drawCircle(ballSize / 2, ballSize / 2, i);
				g.endFill();
			}
			bm.draw(temp);
			return bm
		}
	}
}