/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/okRM
 */

// forked from summerTree's Sound Sprite
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.media.*;
    import flash.utils.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.system.*;
    import flash.text.*;  
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    public class Main extends Sprite
    {
        private var sound:Sound;//声音对象
        private var channel:SoundChannel;
        private var memory:TextField=new TextField();//用于显示内存使用状态文本
 
        public function Main()
        {
            Security.allowDomain("*");
            sound=new Sound(new URLRequest("http://v6.cache7.c.bigcache.googleapis.com/bradsedito/audio/03%20Burn%20The%20Clock.mp3"),new SoundLoaderContext(1000,true));//加载声音对象
            sound.addEventListener(Event.COMPLETE,loadSoundComplete);
            sound.addEventListener(ProgressEvent.PROGRESS,onProgress);
            
             
            memory.x=50;
            memory.y=50;
            memory.width=100;
            memory.height=20;
            addChild(memory);
            memory.defaultTextFormat=new TextFormat("Arrail",15,0xffffff);
        }
        
        private function loadSoundComplete(event:Event):void
        {
            channel=sound.play();
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        private function onProgress(event:ProgressEvent):void
        {
              memory.text=String(Math.round(event.bytesLoaded /event.bytesTotal*100))+"/%";
             
        }
        
        public function onEnterFrame(event:Event):void
        {    
            memory.text=String(System.totalMemory/1024 )+"/k";//显示内存使用情况
            var ss:ByteArray=new ByteArray();
            SoundMixer.computeSpectrum(ss);
            
            var shape:MixerSprite=new MixerSprite(ss,0x00ff00);//创建图形
            shape.x=100;
            shape.y=200;
            addChild(shape);
            shape.addEventListener(MixerSprite.REMOVE_SELF,onComplete);//监听并删除自己
            
        }
         
         private function onComplete(event:Event):void
         {
             removeChild(event.currentTarget as DisplayObject);
         }
         
        
    }
}import flash.display.Sprite;
    import flash.media.*;
    import flash.events.*;
    import flash.utils.ByteArray;
    import flash.filters.*;

     class MixerSprite extends Sprite
    {
        private var glow:GlowFilter;//发光滤镜
        private var blur:BlurFilter;
        private var key:Boolean=true;
        private var byte:ByteArray;
        private var value:Number;
        private var s_height:Number;//振幅最高度
        private var color:uint;
        public static var  REMOVE_SELF:String="removeself";//删除自己事件类型
         function MixerSprite(byte:ByteArray,color:uint,s_height:Number=100)  
        {
            this.byte=byte;
            this.s_height=s_height;
            this.color=color;
            glow=new GlowFilter(color,1,2,2);
            blur=new BlurFilter(1,1);
            this.graphics.lineStyle(1,color);
            this.filters=[glow,blur];//组合滤镜
            this.value=Math.random()*8;
            addEventListener(Event.ENTER_FRAME,Run);
        }
        private function Run(event:Event):void
        {
            if (key)
            {
                key=false;
                
                for (var i:int=0; i<256; i++)
                {
                    this.graphics.lineTo(i*1.2,s_height*Math.sin(byte.readFloat()));//显示波频
                }
                //this.graphics.lineStyle(1,color);
//                this.graphics.moveTo(0,0);
//                for (var j:int=0; j<256; j++)
//                {
//                    this.graphics.lineTo(j*1.2,40+(s_height+20)*Math.sin(byte.readFloat()));//显示波频
//                }
            }            
            this.value+=1;
            blur.blurX=this.value;
            blur.blurY=this.value;
            this.scaleX=this.scaleY-=0.04;
            this.alpha-=0.04;
            glow.alpha-=0.01;
            this.filters=[glow,blur];     
            if (blur.blurX>20)
            {                
                this.graphics.clear();
                this.removeEventListener(Event.ENTER_FRAME,Run);
                this.dispatchEvent(new Event(MixerSprite.REMOVE_SELF));
            }            
        }
    }