/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/okOV
 */

// forked from spanvega's ISOWAVES
package
{
    import flash.events.Event;
    import flash.display.Sprite;

    import com.bit101.components.*;

    import com.risonhuang.pixas.math.Coord3D;
    import com.risonhuang.pixas.colors.CubeColor;
    import com.risonhuang.pixas.dimensions.CubeDms;
    import com.risonhuang.pixas.objects.PixelObject;
    import com.risonhuang.pixas.objects.primitives.Cube;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [ SWF (width = '465', height = '465', backgroundColor = '0x000000', frameRate = '30')]

    public class ISOWAVES extends Sprite
    {
        private var po : PixelObject = new PixelObject ();

        private var num_x : uint = 20, num_y : uint = 20;
        private var cub_w : uint = 10, cub_h : uint = 10;
        private var min : int = 3; // smallest cube height
        private var max : int = num_x * num_y;

        private var px : Number, py : Number;

        private var piece : PixelObject;

        private var frame : int = 0x80; // number of stored cube primitives
        private var stack : Vector.<Cube> = new Vector.<Cube> (frame, true);

        private var cx : Number, cy : Number;
        private var pivot : Vector.<Number>;

        private var wavesize : Number = 0.25;
        private var speed : Number = 2.5;

        private var n : int, t : Number = 0;
        private var clamp : Boolean = true;
        private var radian : Number;


        public function ISOWAVES ()
        {
            gui ();

            build ();

            stage.scaleMode = 'noScale';

            with (addChild (po)) { x = 233; y = 185; }

            render (); stage.addEventListener (Event.ENTER_FRAME, render);
        }

        private function build () : void
        {
            var ratio : uint;

            var cube : Cube = new Cube ();
            var c3d : Coord3D = new Coord3D ();
            var cubeCol : CubeColor = new CubeColor ();
            var cubeDms : CubeDms = new CubeDms (cub_w, cub_h);

            n = min-1;
            while (++n < (frame + min))
            {
                ratio = (((n + 1) - min) / frame) * 0xFF;

                cubeCol = CubeColor.getByHorizontalColor (ratio << 16 | 0xFF << 8 | 0xFF);

                cubeDms.zAxis = n;

                cube = new Cube (cubeDms, cubeCol, true);

                stack [n - min] = cube;
            }

            n = -1;
            while (++n < max)
            {
                c3d.x = int (n % num_x) * cub_w;
                c3d.y = int (n / num_x) * cub_h;

                po.addChild (new PixelObject (stack[stack.length - 1], c3d));
            }

            pivot = new <Number>
            [
                /* CENTER */  0, cub_h * (num_y - 1) * .5,
                /* LEFT */   -cub_w * (num_x - 1), cub_h * (num_y - 1) * .5,
                /* TOP */     cx = 0, cy = 0,
                /* RIGHT */   cub_w * (num_x - 1), cub_h * (num_y - 1) * .5,
                /* BOTTOM */  0, cub_h * (num_y - 1)
            ];
        }

        private function render (e : Event = null) : void
        {
            n = -1;
            while (++n < max)
            {
                radian = t * (3.1415926535 / 180);

                piece = PixelObject (po.getChildAt (n));

                var yy : Number = (frame - 1) * Math.cos ((wavesize * 0.1) * distance (piece.x, piece.y, cx, cy) + radian) >> 0;

                if (yy < 0) yy = clamp ? 0 : -yy;

                piece.primitive = stack [yy];
            }

            t -= speed;
        }

        private function distance (fx : Number, fy : Number, tx : Number, ty : Number) : Number
        {
            var dx : Number = tx - fx, dy : Number = ty - fy;

            return Math.sqrt (dx * dx + dy * dy);
        }

        private function gui () : void
        {
            with (Style) { BUTTON_FACE = BACKGROUND = 0xFFFFFF; LABEL_TEXT = DROPSHADOW = 0x000000; }

            with (addChild (new Sprite ()))
            { graphics.beginFill (0xBFBFBF, 0.25); graphics.drawRect (0, 440, 465, 25); }

            var w : HUISlider = new HUISlider (this, 10, 443, 'WAVESIZE', function () : void { wavesize = w.value; });
            with (w) { setSliderParams (0.01, 0.5, wavesize); width = 160; labelPrecision = 2; tick = 0.01; draw (); }

            var s : HUISlider = new HUISlider (this, 170, 443, 'SPEED', function () : void { speed = s.value; });
            with (s) { setSliderParams (-5, 5, speed); width = 160; labelPrecision = 2; draw (); }

            var c : CheckBox = new CheckBox (this, 333, 447, '' /* 'CLAMP' */, function () : void { clamp = c.selected; });
            c.selected = clamp; // opt

            var d : ComboBox = new ComboBox (this, 353, 445, 'DIRECTION', ['CENTER', 'LEFT', 'TOP', 'RIGHT', 'BOTTOM']);
            d.addEventListener (Event.SELECT, function () : void { cx = pivot [d.selectedIndex << 1]; cy = pivot [(d.selectedIndex << 1) + 1]; });
            with (d) { numVisibleItems = 5; openPosition = 'top'; height = 14; draw (); }
        }
    }
}