/**
 * Copyright cuegraphix ( http://wonderfl.net/user/cuegraphix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ok3V
 */

// forked from ProjectNya's DotWind
// こんな感じですか？？getColorBoundsRect多用してしまったので重いかも。。
// 煙は正直サボりました
////////////////////////////////////////////////////////////////////////////////
// DotWind
//
// 砂が竜巻のような動きで舞い上がって、文字を構成し、
// すべての文字が表示された後、文字が煙のように消えて行く
// ...ようにしたいの。
// (現状は、砂が舞い上がってるだけ)
// [竜巻のような動きは3Dっぽくない方がいい]
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var rect:Rectangle;
        private var canvas:BitmapData;
        private var wind:Wind;
        private static var dots:uint = 20;

        private var text:InputText;
        private var button:PushButton;
        
        public function Main() {
            Wonderfl.capture_delay(8);
            init();
        }

        private function init():void {
            rect = new Rectangle(0, 0, 465, 465);
            canvas = new BitmapData(rect.width, rect.height, false, 0xFFFFFFFF);
            var bitmap:Bitmap = new Bitmap(canvas);
            addChild(bitmap);
            wind = new Wind(canvas);
            
            text = new InputText(this, 150, 10, "Wonderfl");
            button = new PushButton(this, 250, 8, "UPDATE", changeText);
            button.width = 60;
            
            wind.setText(text.text);
            
            addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
        }
        private function draw(evt:Event):void {
            wind.create(dots);
            canvas.lock();
            canvas.fillRect(canvas.rect, 0xFFFFFFFF);
            wind.blow();
            canvas.unlock();
        }
        private function changeText(e:Event):void {
            wind.setText(text.text);
        }
        private function clearText(e:Event):void {
            wind.burn();
        }
    }

}


import flash.display.Sprite;
import flash.display.BitmapData;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Wind extends Sprite {
    private var canvas:BitmapData;
    private var rect:Rectangle;
    private var dots:Array;
    private static var acceleration:Number = 0.02;

    private var textSource:BitmapData;
    private var textBmd:BitmapData;
    private var textBurn:BitmapData;
    private var burnBlur:BlurFilter;
    private var textBounds:Rectangle;
    
    public function Wind(c:BitmapData) {
        canvas = c;
        init();
    }

    private function init():void {
        rect = canvas.rect;
        dots = new Array();
        textBmd = new BitmapData(rect.width, rect.height, true, 0x00000000);
        burnBlur = new BlurFilter(1.5, 2, 3);
    }
    public function create(max:uint):void {
        for (var n:uint = 0; n < max; n++) {
            var px:Number = Math.random()*rect.width;
            var py:Number = rect.height;
            var power:Number = Math.random() + 0.5;
            var velocity:Number = Math.random() + 0.5;
            var angle:Number = (Math.random()*2 - 1)*Math.PI;
            var dot:Dot = new Dot(px, py, power, velocity, angle);
            dots.push(dot);
        }
    }
    public function blow():void {
        for (var n:uint = 0; n < dots.length; n++) {
            var dot:Dot = dots[n];
            dot.angle += Math.PI/180;
            dot.vx = dot.velocity*Math.cos(dot.angle);
            dot.vy += acceleration*dot.power;
            dot.vy *= 0.99;
            dot.x += dot.vx;
            dot.y -= dot.vy;
            
            // 描画領域のみを走査する
            if (textSource && textBounds.contains(dot.x, dot.y)) {
                var p:int = textSource.getPixel(dot.x, dot.y);
                if (p != 0) {
                    // ソースからピクセルを消す
                    textSource.setPixel32(dot.x, dot.y, 0x00000000);
                    // アンチエイリアス用
                    var alpha:int = p >> 16;
                    textBmd.setPixel32(dot.x, dot.y, alpha << 24 + dot.rgb);
                    // 全部表示された？
                    if (textSource.getColorBoundsRect(0x0FFFF0000, 0xFFFF0000, true).isEmpty()) {
                        burn();
                    }
                    dots.splice(n, 1);
                    dot = null;
                    continue;
                }
            }
            canvas.setPixel(dot.x, dot.y, dot.rgb);
            if (dot.x < rect.left) dot.x += rect.width;
            if (dot.x > rect.right) dot.x -= rect.width;
            if (dot.y < rect.top) {
                dots.splice(n, 1);
                dot = null;
            }
        }
        canvas.draw(textBmd);
    }
    
    public function setText(str:String):void {
        burn();
        textSource = new BitmapData(rect.width, rect.height, true, 0x00000000);
        var txt:TextField = new TextField();
        txt.autoSize = TextFieldAutoSize.LEFT;
        txt.defaultTextFormat = new TextFormat(null, 48, 0xFF0000);
        txt.text = str;
        var matrix:Matrix = new Matrix();
        // 中心へ移動
        matrix.tx = (rect.width - txt.width) * 0.5;
        matrix.ty = (rect.height - txt.height) * 0.5;
        textSource.draw(txt, matrix);
        // 描画領域を取得
        textBounds = textSource.getColorBoundsRect(0xFFFF0000, 0xFFFF0000, true);
    }
    public function burn():void {
        if(textSource) {
            textBurn = new BitmapData(rect.width, rect.height, true, 0x00000000);
            textBurn.draw(textBmd);
            textSource.dispose();
            textSource = null;
            textBounds = new Rectangle();
            textBmd.dispose();
            textBmd = new BitmapData(rect.width, rect.height, true, 0x00000000);
            removeEventListener(Event.ENTER_FRAME, _burn);
            canvas.draw(textBurn);
            addEventListener(Event.ENTER_FRAME, _burn, false, 0, true);
        }
    }
    private function _burn(e:Event):void {
        textBurn.applyFilter(textBurn, textBurn.rect, new Point(), burnBlur);
        textBurn.scroll(0, -1);
        canvas.draw(textBurn);
        // 煙が全部消えたかどうか
        if (textBurn.getColorBoundsRect(0xFFFFFFFF, 0x00000000, false).isEmpty()) {
            removeEventListener(Event.ENTER_FRAME, _burn);
        }
    }
}


class Dot {
    public var x:Number = 0;
    public var y:Number = 0;
    public var angle:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var power:Number = 1;
    public var velocity:Number = 1;
    public var rgb:uint = 0x000000;

    public function Dot(_x:Number, _y:Number, p:Number, v:Number, a:Number):void {
        x = _x;
        y = _y;
        power = p;
        velocity = v;
        angle = a;
    }

}
