/**
 * Copyright dada_sygnas ( http://wonderfl.net/user/dada_sygnas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ojrk
 */

/*
ドキュメントクラス
*/

package {
	
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;

	[SWF(backgroundColor = "#FFFFFF", frameRate = 25)]
	
	public class Main extends Sprite{

		public static const ATTACH_MAX:int	= 20;	// 配置個数
		
		private var $boxList:Array;
		private var $moveList:Array;
		private var $cursorBox:Box;
		
		/***********************************
		* コンストラクタ
		*/
		public function Main(){

			$boxList = [];
			$moveList = [];

			// 動く箱を描画
			for ( var i:int = 0; i < ATTACH_MAX; i++ ) {
				var box:Box = new Box( this, i );
				$boxList.push( box );
				$moveList.push( box );
			}
			
			// マウスに追従する箱を描画
			$cursorBox = new Box( this, ATTACH_MAX );
			$cursorBox.x = mouseX;
			$cursorBox.y = mouseY;
			$boxList.push( $cursorBox );

			this.addEventListener( Event.ENTER_FRAME, ___onEnterFrame );
		}
		
		/***********************************
		* エンターフレーム
		*/
		protected function ___onEnterFrame( e:Event ):void{
			var moveList:Array = $moveList;
			var len:int = moveList.length;

			// 箱を動かす
			for( var i:int=0; i<len; i++ ){
				moveList[i].move();
			}
			
			// カーソルも動かす
			$cursorBox.x = mouseX;
			$cursorBox.y = mouseY;
			
			DepthSort.sortY( $boxList, this );
		}
	}
}


import flash.display.*;
import flash.events.*;
import flash.geom.*;

/**************************************
 * Y座標で重ね順を変更するクラス
 */
class DepthSort {

	/***********************
	 * 並べ替えを行う
	 * indexListと itemListを別に用意しているのは、同じ DisplayObjectContainerに配置されていても
	 * 並べ替え対象でないものがある可能性があるから。
	 * 
	 * @param objList		並べ替えを行いたい DisplayObjectが格納された配列
	 * @param stage			対象 DisplayObjectの親となる DisplayObjectContainer
	 */
	public static function sortY( objList:Array, stage:DisplayObjectContainer ):void{
		var length:int = objList.length;
		var itemList:Array = [];
		var indexList:Array = [];
		var i:int;
		
		// ソートの材料を作る
		for ( i = 0; i < length; i++ ) {
			var obj:DisplayObject = objList[i];
			
			// indexを保存
			var index:int = stage.getChildIndex( obj );
			indexList.push( index );
			
			itemList.push( {obj:obj, index:index, y:obj.y} );
		}
		
		// index順ソート
		indexList.sort( Array.NUMERIC );
		
		// 座標順ソート
		itemList.sortOn( "y", Array.NUMERIC );
		
		// 重ね合わせ変更
		for ( i = 0; i < length; i++ ) {
			// 現在の重ね順と違う場合のみ変更
			if( itemList[i].index != indexList[i] ){
				stage.setChildIndex( itemList[i].obj, indexList[i] );
			}
		}
	}
	
}

/**************************************
 * 動き回る箱
 */
class Box extends Sprite {

	public static const STAGE_H:Number		= 480;
	public static const BOX_H:Number		= 60;
	public static const SPEED_MIN:Number	= 2;
	public static const SPEED_MAX:Number	= 6 - SPEED_MIN;

	public var id:int;
	
	private var $stage:Sprite;
	private var $speed:Number;
	
	/**************************************
	 * コンストラクタ
	 */
	public function Box( myStage:Sprite, myId:int ) {
		super();
		
		$stage = myStage;
		id = myId;
		
		$speed = Math.random() * SPEED_MAX + SPEED_MIN;
		
		this.x = Math.random() * (STAGE_H - BOX_H);
		this.y = Math.random() * (STAGE_H - BOX_H);
		$stage.addChild( this );
		
		var rect:Shape = new Shape();
		rect.graphics.beginFill( Math.random() * 0xffffff );
		rect.graphics.drawRect( 0, 0, BOX_H, BOX_H );
		rect.graphics.endFill();
		this.addChild( rect );
	}
	
	/**************************************
	 * 動けゃ！
	 */
	public function move():void {
		
		if ( $speed > 0 && this.y + $speed >= STAGE_H - BOX_H ) {
			$speed *= -1;
		}else if ( $speed < 0 && this.y + $speed < 0 ) {
			$speed *= -1;
		}
		
		this.y += $speed;
	}
}

