/**
 * Copyright mirrorboy ( http://wonderfl.net/user/mirrorboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ojlv
 */

package
{
    import flash.display.GraphicsPathCommand;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    public class ChangingPointsOnAPath extends Sprite
    {
        private const COLOR:uint = 0xFF;
        private const THICKNESS:uint = 3;
        
        private var _pathCommands:Vector.<int>;
        private var _pathData:Vector.<Number>;
        private var _anchors:Vector.<Sprite>;
        private var _anchor:Sprite;
        private var _anchorIndex:uint;
        
        public function ChangingPointsOnAPath()
        {
            init();
        }
        
        private function init():void{
        
            _anchors = new Vector.<Sprite>();
            _pathCommands = new Vector.<int>();
            _pathData = new Vector.<Number>();
            graphics.lineStyle(THICKNESS,COLOR);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
        }
        
        
        private function addAnchor(x:Number,y:Number):void{
            var anchor:Sprite = new Sprite();
            anchor.graphics.lineStyle(20);
            anchor.graphics.lineTo(1,0);
            anchor.addEventListener(MouseEvent.MOUSE_DOWN,onAnchorDown);
            anchor.addEventListener(MouseEvent.MOUSE_UP,onAnchorUp);
            anchor.x = x;
            anchor.y = y;
            addChild(anchor);
            _anchors.push(anchor);
        }
        
        private function redrawPath():void{
            graphics.clear();
            graphics.lineStyle(THICKNESS,COLOR);
            graphics.drawPath(_pathCommands,_pathData);
            var dataLength:uint = _pathData.length;
            graphics.moveTo(_pathData[dataLength-2],_pathData[dataLength-1]);
        }
        
        private function onAnchorDown(event:MouseEvent):void{
        
            _anchor = event.target as Sprite;
            _anchor.startDrag();
            _anchorIndex = _anchors.indexOf(_anchor);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onAnchorMove);
            event.stopPropagation();
        }
        
        private function onAnchorMove(event:MouseEvent):void
        {
            _pathData[_anchorIndex * 2] = _anchor.x;
            _pathData[_anchorIndex * 2 + 1] = _anchor.y;
            redrawPath();
            
            event.updateAfterEvent();
        }
        
        private function onAnchorUp(event:MouseEvent):void{
            if(_anchor){
                _anchor.stopDrag();
                stage.removeEventListener(MouseEvent.MOUSE_MOVE,onAnchorMove);
            }
        }
        private function onStageMouseDown(event:MouseEvent):void{
            var x:Number = stage.mouseX;
            var y:Number = stage.mouseY;
            
            addAnchor(x,y);
            
            if(_pathCommands.length < 1){
                _pathCommands.push(GraphicsPathCommand.MOVE_TO);
                graphics.moveTo(x,y);

            }
            else
            {
                _pathCommands.push(GraphicsPathCommand.LINE_TO);
                graphics.lineTo(x,y);
            }
            _pathData.push(x,y);
        }
        
        
    }
}