/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oj4p
 */

package  {
    import flash.system.LoaderContext;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.ProgressEvent;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.utils.Timer;
    
    public class WonderUniverse3 extends Sprite {
    
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        private static const POLICY_FILE:String = "http://www.bongiovi.tw/crossdomain.xml";
        private static const SOUND_FILE:String = "http://www.bongiovi.tw/wonderfl/essbe/House_Me.mp3";
        private static const PATTERN_FILE:String = "http://www.bongiovi.tw/wonderfl/pattern.png";
        
        public static const W : int = 465;
        public static const H : int = 465;
        public static const R : int = 250;
        public static const MAX : int = 100;
        public static const LEVEL_BLUR : int = 10;
        public static const LEVEL_BRIGHTNESS : int = 20;
        public static const MAX_BLUR : Number = 10;
        public static const MAX_BRIGHTNESS : Number = 1.5;
        
        private var __sLoading : Shape = new Shape;
        private var __loader : Loader = new Loader();
        
        private var __particles : Array = [];
        private var __aBmps : Array = [];
        private var __sContainer : Shape = new Shape;
        private var __sbg : Shape = new Shape;
        private var __bmpd : BitmapData;
        private var __sound  : Sound = new Sound;
        private var __soundChannel : SoundChannel;
        private var __bytes : ByteArray = new ByteArray();
        private var __soundData : Array = [];
        
        private var __vrx : Number = 0;
        private var __vry : Number = 0;
        private var __vrz : Number = 0;
        
        public var angle : Number = 0;
        private var __timer : Timer;
        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
    
        /**
         *    @constructor
         */
        public function WonderUniverse3(){
            __loader.contentLoaderInfo.addEventListener(Event.COMPLETE, __onImageLoadedHandler);
            __loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, __onError);
            __loader.load(new URLRequest(PATTERN_FILE), new LoaderContext(true) );
        }

        
        private function __onImageLoadedHandler(e:Event) : void {
            __bmpd = Bitmap(__loader.content).bitmapData;
            addChild(__sbg);
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(465, 465);
            __sbg.graphics.beginGradientFill(GradientType.RADIAL, [0x62410d, 0x000000], [1, 1], [25, 255], mtx);
            __sbg.graphics.drawRect(0, 0, 465, 465);
            __sbg.graphics.endFill();
            
            addChild(__sLoading);
            
            __sound.addEventListener(Event.COMPLETE, __onSoundLoaded);
            __sound.addEventListener(ProgressEvent.PROGRESS, __onProgress);
            __sound.addEventListener(IOErrorEvent.IO_ERROR, __onError );
            __sound.load(new URLRequest(SOUND_FILE), new SoundLoaderContext(10000, true));
        }
        
        
        private function __onProgress(e:ProgressEvent) : void {
            __sLoading.graphics.clear();
            __sLoading.y = 465 / 2;
            __sLoading.graphics.beginFill(0xFFFFFF, 1);
            __sLoading.graphics.drawRect(0, 0, 465 * e.bytesLoaded / e.bytesTotal, 1);
            __sLoading.graphics.endFill();
        }

        
        private function __onSoundLoaded(e:Event) : void {
            removeChild(__sLoading);
            
            __initBmps();
            __initParticles();
            addChild(__sContainer);
            
            __soundChannel = __sound.play();
            __soundChannel.addEventListener(Event.SOUND_COMPLETE, function(e:Event) : void  {__soundChannel = __sound.play(); } );
            
            addEventListener(Event.ENTER_FRAME, render);
            addParticles();
        }
        
        
        public function render(e:Event=null) : void {
            SoundMixer.computeSpectrum(__bytes, true);
            __soundData = [];
            for (var j:int = 0; j < 128; j++){
                __soundData[j] = __bytes.readFloat();
            }
            
            __sContainer.graphics.clear();
            var pos : Vector3D;
            var color:uint;
            var ary:Array = [];
            var p:Particle;
            var globalScale:Number = Math.sin(angle)*.03 + 1;
            
            
            __vrx += __soundData[2] == 0 ? 0 : (__soundData[2] - .3) * .8;
            __vry += __soundData[14] == 0 ? 0 : (__soundData[14] - .3) * .8;
            __vrz += __soundData[26] == 0 ? 0 : (__soundData[26] - .3) * .8;
            
            for each ( p in __particles) {
                p.matrix.appendRotation(__vry, Vector3D.Y_AXIS);
                p.matrix.appendRotation(__vrx, Vector3D.X_AXIS);
                p.matrix.appendRotation(__vrz, Vector3D.Z_AXIS);
                p.matrix.appendScale(p.speed, p.speed, p.speed);
                p.matrix.appendScale(globalScale, globalScale, globalScale);
                if( p.getLength() < R * 1.5 || p.speed == 1) ary.push(p);
            }
            
            __vrx *=.955;
            __vry *=.955;
            __vrz *=.955;
            
            var mtx:Matrix = new Matrix;
            ary.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            __particles = ary;
            
            var length:Number = 10;
            var scale:Number;
            var bmpScale:Number;
            var index:int, indexBlur:int;
            var i:int = 0;
            
            const CENTER_DISPLACE : Number = 50;
            var pCenter:Point = Point.polar(CENTER_DISPLACE, angle*.25);
            pCenter = pCenter.add(new Point(W*.5, H*.5));
            
            for each( p in ary) {
                pos = p.matrix.position;
                scale = 1 - Math.sqrt( Math.pow(pos.x, 2) + Math.pow(pos.y, 2) + Math.pow(pos.z, 2) ) / R;
                length = getLength(pos.z);
                if(length < 5) continue;
                index = Math.floor(scale * LEVEL_BRIGHTNESS) -1 + Math.floor(__soundData[8] * 8);
                indexBlur = Math.floor( (pos.z + R) / (2 * R) * LEVEL_BLUR) - 1;
                
                if(index<0) index = 0;
                if(index >= LEVEL_BRIGHTNESS ) index = LEVEL_BRIGHTNESS-1;
                if(indexBlur<0) indexBlur = 0;
                
                var bmpd:BitmapData = __aBmps[index][indexBlur];
                mtx.identity();
                bmpScale = length / __bmpd.width;
                mtx.scale(bmpScale*2, bmpScale*2);
                mtx.translate(pos.x - __bmpd.width*bmpScale + pCenter.x, pos.y- __bmpd.height*bmpScale + pCenter.y);
                
                __sContainer.graphics.beginBitmapFill(bmpd, mtx);
                __sContainer.graphics.drawCircle(pos.x+ pCenter.x, pos.y + pCenter.y, __bmpd.width*bmpScale);
                __sContainer.graphics.endFill();
            }
            
            angle += .05;
        }
        
        
        public function addParticles(e:Event=null) : void {
            const ITER : int = 5;
            var i : int = 0;
            if(__particles.length < MAX*2) {
                while(i++<ITER) {
                    __toAddParticle();
                }
            }
            
            var delay:Number = getRandom(.2, .4);
            if(__timer != null) {
                __timer.removeEventListener(TimerEvent.TIMER, addParticles);
                __timer.stop();
            }
            __timer = new Timer(delay * 1000, 1);
            __timer.addEventListener(TimerEvent.TIMER, addParticles);
            __timer.start();
        }
        
        
        private function __toAddParticle(radius:Number = 0, scale:Number = 0) : void {
            var p:Particle = new Particle;
            p.matrix.identity();
            p.matrix.appendTranslation(radius == 0 ? 1 : radius, 0, 0);
            p.matrix.appendRotation(Math.random() * 360, Vector3D.X_AXIS);
            p.matrix.appendRotation(Math.random() * 360, Vector3D.Y_AXIS);
            p.matrix.appendRotation(Math.random() * 360, Vector3D.Z_AXIS);
            p.speed = scale == 0 ? getRandom(1.05, 1.02) : scale;
            __particles.push(p);
        }
        
        
        public function getLength(depth:Number) : Number {
            var __radius : Number = 25 + (__soundData[4] - .3) * 10;
            var sizeOffset:Number = Math.pow( (1 - (depth + R) / (2 * R)) * .8 + .4, 3);
            return Math.floor(__radius*sizeOffset * 100) / 100;
        }
        
        
        private function __initParticles() : void {
            for ( var i:int=0; i<MAX; i++) {
                __toAddParticle(Math.random() * R * .8, 1);
            }
        }
        
        
        private function __initBmps() : void {
            var i : int = 0, j:int = 0;
            var offset : Number = 0;
            var blur:Number;
            
            for ( i = 0; i < LEVEL_BRIGHTNESS; i++ ) {
                offset = .4 + MAX_BRIGHTNESS / LEVEL_BRIGHTNESS * i;
                
                __aBmps[i] = [];
                for ( j=0; j< LEVEL_BLUR; j++ ) {
                    var bmpd:BitmapData = __bmpd.clone();
                    bmpd.colorTransform(bmpd.rect, new ColorTransform(offset, offset, offset, 1));
                    
                    blur = 1 + MAX_BLUR / LEVEL_BLUR * j;
                    bmpd.applyFilter(bmpd, bmpd.rect, new Point, new BlurFilter(blur, blur, 3));
                    __aBmps[i].push(bmpd);
                }
            }
        }
        
        
        private function __onError(e:IOErrorEvent) : void {    trace("Error Loading File :" + e);    }
        
        static public function getRandom(start:Number, end:Number) : Number {    return start + Math.random()*(end-start);    }
        
    }

}


import flash.geom.Matrix3D;
import flash.geom.Vector3D;

class Particle {
    public var matrix : Matrix3D = new Matrix3D;
    public var color : uint;
    public var angle : Number;
    public var length : Number;
    public var speed : Number;
    
    public function get z() : Number {    return matrix.position.z;    }
    
    public function getLength() : Number {
        var pos:Vector3D = matrix.position;
        return Math.sqrt( Math.pow(pos.x, 2) + Math.pow(pos.y, 2) + Math.pow(pos.z, 2) );
    }
}
